/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.split;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.transforms.split.SplitGraph;
import org.apache.hop.neo4j.transforms.split.SplitGraphData;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.w3c.dom.Node;

@Transform(id="Neo4jSplitGraph", name="Neo4j Split Graph", description="Splits the nodes and relationships of a graph data type", image="neo4j_split.svg", categoryDescription="Neo4j", documentationUrl="/plugins/transforms/split-graph.html")
public class SplitGraphMeta
extends BaseTransformMeta
implements ITransformMeta<SplitGraph, SplitGraphData> {
    public static final String GRAPH_FIELD = "graph_field";
    public static final String TYPE_FIELD = "type_field";
    public static final String ID_FIELD = "id_field";
    public static final String PROPERTY_SET_FIELD = "property_set_field";
    protected String graphField;
    protected String typeField;
    protected String idField;
    protected String propertySetField;

    public void setDefault() {
        this.graphField = "graph";
        this.typeField = "type";
        this.idField = "id";
        this.propertySetField = "propertySet";
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextStep, IVariables space, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (StringUtils.isNotEmpty((String)this.typeField)) {
            ValueMetaString typeValueMeta = new ValueMetaString(space.resolve(this.typeField));
            typeValueMeta.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)typeValueMeta);
        }
        if (StringUtils.isNotEmpty((String)this.idField)) {
            ValueMetaString idValueMeta = new ValueMetaString(space.resolve(this.idField));
            idValueMeta.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)idValueMeta);
        }
        if (StringUtils.isNotEmpty((String)this.propertySetField)) {
            ValueMetaString propertySetValueMeta = new ValueMetaString(space.resolve(this.propertySetField));
            propertySetValueMeta.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)propertySetValueMeta);
        }
    }

    public String getXml() throws HopException {
        StringBuffer xml = new StringBuffer();
        xml.append(XmlHandler.addTagValue((String)GRAPH_FIELD, (String)this.graphField));
        xml.append(XmlHandler.addTagValue((String)TYPE_FIELD, (String)this.typeField));
        xml.append(XmlHandler.addTagValue((String)ID_FIELD, (String)this.idField));
        xml.append(XmlHandler.addTagValue((String)PROPERTY_SET_FIELD, (String)this.propertySetField));
        return xml.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.graphField = XmlHandler.getTagValue((Node)transformNode, (String)GRAPH_FIELD);
        this.typeField = XmlHandler.getTagValue((Node)transformNode, (String)TYPE_FIELD);
        this.idField = XmlHandler.getTagValue((Node)transformNode, (String)ID_FIELD);
        this.propertySetField = XmlHandler.getTagValue((Node)transformNode, (String)PROPERTY_SET_FIELD);
    }

    public SplitGraph createTransform(TransformMeta transformMeta, SplitGraphData iTransformData, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new SplitGraph(transformMeta, this, iTransformData, copyNr, pipelineMeta, pipeline);
    }

    public SplitGraphData getTransformData() {
        return new SplitGraphData();
    }

    public String getGraphField() {
        return this.graphField;
    }

    public void setGraphField(String graphField) {
        this.graphField = graphField;
    }

    public String getTypeField() {
        return this.typeField;
    }

    public void setTypeField(String typeField) {
        this.typeField = typeField;
    }

    public String getIdField() {
        return this.idField;
    }

    public void setIdField(String idField) {
        this.idField = idField;
    }

    public String getPropertySetField() {
        return this.propertySetField;
    }

    public void setPropertySetField(String propertySetField) {
        this.propertySetField = propertySetField;
    }
}

