/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.split;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.neo4j.core.data.GraphData;
import org.apache.hop.neo4j.core.data.GraphNodeData;
import org.apache.hop.neo4j.core.data.GraphRelationshipData;
import org.apache.hop.neo4j.core.value.ValueMetaGraph;
import org.apache.hop.neo4j.transforms.split.SplitGraphData;
import org.apache.hop.neo4j.transforms.split.SplitGraphMeta;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

public class SplitGraph
extends BaseTransform<SplitGraphMeta, SplitGraphData>
implements ITransform<SplitGraphMeta, SplitGraphData> {
    public SplitGraph(TransformMeta transformMeta, SplitGraphMeta meta, SplitGraphData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        GraphData copy;
        int index;
        Object[] outputRowData;
        ValueMetaGraph valueMeta;
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((SplitGraphData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((SplitGraphMeta)this.meta).getFields(((SplitGraphData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((SplitGraphData)this.data).graphFieldIndex = this.getInputRowMeta().indexOfValue(((SplitGraphMeta)this.meta).getGraphField());
            if (((SplitGraphData)this.data).graphFieldIndex < 0) {
                throw new HopException("Unable to find graph field " + ((SplitGraphMeta)this.meta).getGraphField() + "' in the transform input");
            }
            valueMeta = this.getInputRowMeta().getValueMeta(((SplitGraphData)this.data).graphFieldIndex);
            if (valueMeta.getType() != 303) {
                throw new HopException("Please specify a Graph field to split");
            }
            ((SplitGraphData)this.data).typeField = null;
            if (StringUtils.isNotEmpty((String)((SplitGraphMeta)this.meta).getTypeField())) {
                ((SplitGraphData)this.data).typeField = this.resolve(((SplitGraphMeta)this.meta).getTypeField());
            }
            ((SplitGraphData)this.data).idField = null;
            if (StringUtils.isNotEmpty((String)((SplitGraphMeta)this.meta).getIdField())) {
                ((SplitGraphData)this.data).idField = this.resolve(((SplitGraphMeta)this.meta).getIdField());
            }
            ((SplitGraphData)this.data).propertySetField = null;
            if (StringUtils.isNotEmpty((String)((SplitGraphMeta)this.meta).getPropertySetField())) {
                ((SplitGraphData)this.data).propertySetField = this.resolve(((SplitGraphMeta)this.meta).getPropertySetField());
            }
        }
        valueMeta = (ValueMetaGraph)this.getInputRowMeta().getValueMeta(((SplitGraphData)this.data).graphFieldIndex);
        Object valueData = row[((SplitGraphData)this.data).graphFieldIndex];
        GraphData graphData = valueMeta.getGraphData(valueData);
        for (GraphNodeData nodeData : graphData.getNodes()) {
            outputRowData = RowDataUtil.createResizedCopy((Object[])row, (int)((SplitGraphData)this.data).outputRowMeta.size());
            index = this.getInputRowMeta().size();
            copy = graphData.createEmptyCopy();
            copy.getNodes().add(nodeData.clone());
            outputRowData[((SplitGraphData)this.data).graphFieldIndex] = copy;
            if (((SplitGraphData)this.data).typeField != null) {
                outputRowData[index++] = "Node";
            }
            if (((SplitGraphData)this.data).idField != null) {
                outputRowData[index++] = nodeData.getId();
            }
            if (((SplitGraphData)this.data).propertySetField != null) {
                outputRowData[index++] = nodeData.getPropertySetId();
            }
            this.putRow(((SplitGraphData)this.data).outputRowMeta, outputRowData);
        }
        for (GraphRelationshipData relationshipData : graphData.getRelationships()) {
            outputRowData = RowDataUtil.createResizedCopy((Object[])row, (int)((SplitGraphData)this.data).outputRowMeta.size());
            index = this.getInputRowMeta().size();
            copy = graphData.createEmptyCopy();
            copy.getRelationships().add(relationshipData.clone());
            outputRowData[((SplitGraphData)this.data).graphFieldIndex] = copy;
            if (((SplitGraphData)this.data).typeField != null) {
                outputRowData[index++] = "Relationship";
            }
            if (((SplitGraphData)this.data).idField != null) {
                outputRowData[index++] = relationshipData.getId();
            }
            if (((SplitGraphData)this.data).propertySetField != null) {
                outputRowData[index++] = relationshipData.getPropertySetId();
            }
            this.putRow(((SplitGraphData)this.data).outputRowMeta, outputRowData);
        }
        return true;
    }
}

