/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.output;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.core.value.ValueMetaGraph;
import org.apache.hop.neo4j.transforms.output.Neo4JOutput;
import org.apache.hop.neo4j.transforms.output.Neo4JOutputData;
import org.apache.hop.neo4j.transforms.output.Neo4JOutputDialog;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Node;

@Transform(id="Neo4JOutput", image="neo4j_output.svg", name="i18n::Neo4JOutput.Transform.Name", description="i18n::Neo4JOutput.Transform.Description", categoryDescription="i18n::Neo4JOutput.Transform.Category", documentationUrl="/pipeline/transforms/neo4j-output.html")
@InjectionSupported(localizationPrefix="Neo4JOutput.Injection.", groups={"FROM_NODE_PROPS", "FROM_LABELS", "TO_NODE_PROPS", "TO_LABELS", "REL_PROPS"})
public class Neo4JOutputMeta
extends BaseTransformMeta
implements ITransformMeta<Neo4JOutput, Neo4JOutputData> {
    private static final String STRING_CONNECTION = "connection";
    private static final String STRING_BATCH_SIZE = "batch_size";
    private static final String STRING_KEY = "key";
    private static final String STRING_FROM = "from";
    private static final String STRING_LABELS = "labels";
    private static final String STRING_LABEL = "label";
    private static final String STRING_VALUE = "value";
    private static final String STRING_PROPERTIES = "properties";
    private static final String STRING_PROPERTY = "property";
    private static final String STRING_PROPERTY_NAME = "name";
    private static final String STRING_PROPERTY_VALUE = "value";
    private static final String STRING_PROPERTY_TYPE = "type";
    private static final String STRING_PROPERTY_PRIMARY = "primary";
    private static final String STRING_TO = "to";
    private static final String STRING_RELATIONSHIP = "relationship";
    private static final String STRING_RELATIONSHIP_VALUE = "relationship_value";
    private static final String STRING_RELPROPS = "relprops";
    private static final String STRING_RELPROP = "relprop";
    private static final String STRING_CREATE_INDEXES = "create_indexes";
    private static final String STRING_USE_CREATE = "use_create";
    private static final String STRING_ONLY_CREATE_RELATIONSHIPS = "only_create_relationships";
    private static final String STRING_READ_ONLY_FROM_NODE = "read_only_from_node";
    private static final String STRING_READ_ONLY_TO_NODE = "read_only_to_node";
    private static final String STRING_RETURNING_GRAPH = "returning_graph";
    private static final String STRING_RETURN_GRAPH_FIELD = "return_graph_field";
    @Injection(name="CONNECTION")
    private String connection;
    @Injection(name="BATCH_SIZE")
    private String batchSize;
    @Injection(name="CREATE_INDEXES")
    private boolean creatingIndexes;
    @Injection(name="USE_CREATE")
    private boolean usingCreate;
    @Injection(name="ONLY_CREATE_RELATIONSHIPS")
    private boolean onlyCreatingRelationships;
    @Injection(name="READ_ONLY_FROM_NODE")
    private boolean readOnlyFromNode;
    @Injection(name="READ_ONLY_TO_NODE")
    private boolean readOnlyToNode;
    @Injection(name="FROM_NODE_PROPERTY_FIELD", group="FROM_NODE_PROPS")
    private String[] fromNodeProps;
    @Injection(name="FROM_NODE_PROPERTY_NAME", group="FROM_NODE_PROPS")
    private String[] fromNodePropNames;
    @Injection(name="FROM_NODE_PROPERTY_TYPE", group="FROM_NODE_PROPS")
    private String[] fromNodePropTypes;
    @Injection(name="FROM_NODE_PROPERTY_PRIMARY", group="FROM_NODE_PROPS")
    private boolean[] fromNodePropPrimary;
    @Injection(name="TO_NODE_PROPERTY_FIELD", group="TO_NODE_PROPS")
    private String[] toNodeProps;
    @Injection(name="TO_NODE_PROPERTY_NAME", group="TO_NODE_PROPS")
    private String[] toNodePropNames;
    @Injection(name="TO_NODE_PROPERTY_TYPE", group="TO_NODE_PROPS")
    private String[] toNodePropTypes;
    @Injection(name="TO_NODE_PROPERTY_PRIMARY", group="TO_NODE_PROPS")
    private boolean[] toNodePropPrimary;
    @Injection(name="FROM_LABEL", group="FROM_LABELS")
    private String[] fromNodeLabels;
    @Injection(name="TO_LABEL", group="TO_LABELS")
    private String[] toNodeLabels;
    @Injection(name="FROM_LABEL_VALUE", group="FROM_LABELS")
    private String[] fromNodeLabelValues;
    @Injection(name="TO_LABEL_VALUE", group="TO_LABELS")
    private String[] toNodeLabelValues;
    @Injection(name="REL_PROPERTY_FIELD", group="REL_PROPS")
    private String[] relProps;
    @Injection(name="REL_PROPERTY_NAME", group="REL_PROPS")
    private String[] relPropNames;
    @Injection(name="REL_PROPERTY_TYPE", group="REL_PROPS")
    private String[] relPropTypes;
    @Injection(name="REL_LABEL")
    private String relationship;
    @Injection(name="REL_VALUE")
    private String relationshipValue;
    @Injection(name="RETURNING_GRAPH")
    private boolean returningGraph;
    @Injection(name="RETURN_GRAPH_FIELD")
    private String returnGraphField;
    private String key;

    public Neo4JOutput createTransform(TransformMeta transformMeta, Neo4JOutputData iTransformData, int cnr, PipelineMeta pipelineMeta, Pipeline disp) {
        return new Neo4JOutput(transformMeta, this, iTransformData, cnr, pipelineMeta, disp);
    }

    public Neo4JOutputData getTransformData() {
        return new Neo4JOutputData();
    }

    public ITransformDialog getDialog(Shell shell, IVariables variables, ITransformMeta meta, PipelineMeta pipelineMeta, String name) {
        return new Neo4JOutputDialog(shell, variables, meta, pipelineMeta, name);
    }

    public void setDefault() {
        this.connection = "";
        this.batchSize = "1000";
        this.creatingIndexes = true;
        this.usingCreate = false;
        this.onlyCreatingRelationships = false;
        this.fromNodeLabels = new String[0];
        this.fromNodeLabelValues = new String[0];
        this.fromNodeProps = new String[0];
        this.fromNodePropNames = new String[0];
        this.fromNodePropTypes = new String[0];
        this.fromNodePropPrimary = new boolean[0];
        this.toNodeLabels = new String[0];
        this.toNodeLabelValues = new String[0];
        this.toNodeProps = new String[0];
        this.toNodePropNames = new String[0];
        this.toNodePropTypes = new String[0];
        this.toNodePropPrimary = new boolean[0];
        this.relProps = new String[0];
        this.relPropNames = new String[0];
        this.relPropTypes = new String[0];
        this.returnGraphField = "graph";
    }

    public String getXml() throws HopException {
        int i;
        StringBuffer xml = new StringBuffer();
        xml.append(XmlHandler.addTagValue((String)STRING_CONNECTION, (String)this.connection));
        xml.append(XmlHandler.addTagValue((String)STRING_BATCH_SIZE, (String)this.batchSize));
        xml.append(XmlHandler.addTagValue((String)STRING_KEY, (String)this.key));
        xml.append(XmlHandler.addTagValue((String)STRING_CREATE_INDEXES, (boolean)this.creatingIndexes));
        xml.append(XmlHandler.addTagValue((String)STRING_USE_CREATE, (boolean)this.usingCreate));
        xml.append(XmlHandler.addTagValue((String)STRING_ONLY_CREATE_RELATIONSHIPS, (boolean)this.onlyCreatingRelationships));
        xml.append(XmlHandler.addTagValue((String)STRING_RETURNING_GRAPH, (boolean)this.returningGraph));
        xml.append(XmlHandler.addTagValue((String)STRING_RETURN_GRAPH_FIELD, (String)this.returnGraphField));
        xml.append(XmlHandler.openTag((String)STRING_FROM));
        xml.append(XmlHandler.addTagValue((String)STRING_READ_ONLY_FROM_NODE, (boolean)this.readOnlyFromNode));
        xml.append(XmlHandler.openTag((String)STRING_LABELS));
        for (i = 0; i < this.fromNodeLabels.length; ++i) {
            xml.append(XmlHandler.addTagValue((String)STRING_LABEL, (String)this.fromNodeLabels[i]));
            xml.append(XmlHandler.addTagValue((String)"value", (String)this.fromNodeLabelValues[i]));
        }
        xml.append(XmlHandler.closeTag((String)STRING_LABELS));
        xml.append(XmlHandler.openTag((String)STRING_PROPERTIES));
        for (i = 0; i < this.fromNodeProps.length; ++i) {
            xml.append(XmlHandler.openTag((String)STRING_PROPERTY));
            xml.append(XmlHandler.addTagValue((String)STRING_PROPERTY_NAME, (String)this.fromNodePropNames[i]));
            xml.append(XmlHandler.addTagValue((String)"value", (String)this.fromNodeProps[i]));
            xml.append(XmlHandler.addTagValue((String)STRING_PROPERTY_TYPE, (String)this.fromNodePropTypes[i]));
            xml.append(XmlHandler.addTagValue((String)STRING_PROPERTY_PRIMARY, (boolean)this.fromNodePropPrimary[i]));
            xml.append(XmlHandler.closeTag((String)STRING_PROPERTY));
        }
        xml.append(XmlHandler.closeTag((String)STRING_PROPERTIES));
        xml.append(XmlHandler.closeTag((String)STRING_FROM));
        xml.append(XmlHandler.openTag((String)STRING_TO));
        xml.append(XmlHandler.addTagValue((String)STRING_READ_ONLY_TO_NODE, (boolean)this.readOnlyToNode));
        xml.append(XmlHandler.openTag((String)STRING_LABELS));
        for (i = 0; i < this.toNodeLabels.length; ++i) {
            xml.append(XmlHandler.addTagValue((String)STRING_LABEL, (String)this.toNodeLabels[i]));
            xml.append(XmlHandler.addTagValue((String)"value", (String)this.toNodeLabelValues[i]));
        }
        xml.append(XmlHandler.closeTag((String)STRING_LABELS));
        xml.append(XmlHandler.openTag((String)STRING_PROPERTIES));
        for (i = 0; i < this.toNodeProps.length; ++i) {
            xml.append(XmlHandler.openTag((String)STRING_PROPERTY));
            xml.append(XmlHandler.addTagValue((String)STRING_PROPERTY_NAME, (String)this.toNodePropNames[i]));
            xml.append(XmlHandler.addTagValue((String)"value", (String)this.toNodeProps[i]));
            xml.append(XmlHandler.addTagValue((String)STRING_PROPERTY_TYPE, (String)this.toNodePropTypes[i]));
            xml.append(XmlHandler.addTagValue((String)STRING_PROPERTY_PRIMARY, (boolean)this.toNodePropPrimary[i]));
            xml.append(XmlHandler.closeTag((String)STRING_PROPERTY));
        }
        xml.append(XmlHandler.closeTag((String)STRING_PROPERTIES));
        xml.append(XmlHandler.closeTag((String)STRING_TO));
        xml.append(XmlHandler.addTagValue((String)STRING_RELATIONSHIP, (String)this.relationship));
        xml.append(XmlHandler.addTagValue((String)STRING_RELATIONSHIP_VALUE, (String)this.relationshipValue));
        xml.append(XmlHandler.openTag((String)STRING_RELPROPS));
        for (i = 0; i < this.relProps.length; ++i) {
            xml.append(XmlHandler.openTag((String)STRING_RELPROP));
            xml.append(XmlHandler.addTagValue((String)STRING_PROPERTY_NAME, (String)this.relPropNames[i]));
            xml.append(XmlHandler.addTagValue((String)"value", (String)this.relProps[i]));
            xml.append(XmlHandler.addTagValue((String)STRING_PROPERTY_TYPE, (String)this.relPropTypes[i]));
            xml.append(XmlHandler.closeTag((String)STRING_RELPROP));
        }
        xml.append(XmlHandler.closeTag((String)STRING_RELPROPS));
        return xml.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        int i;
        int i2;
        this.connection = XmlHandler.getTagValue((Node)transformNode, (String)STRING_CONNECTION);
        this.batchSize = XmlHandler.getTagValue((Node)transformNode, (String)STRING_BATCH_SIZE);
        this.key = XmlHandler.getTagValue((Node)transformNode, (String)STRING_KEY);
        this.creatingIndexes = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)STRING_CREATE_INDEXES));
        this.usingCreate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)STRING_USE_CREATE));
        this.onlyCreatingRelationships = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)STRING_ONLY_CREATE_RELATIONSHIPS));
        this.returningGraph = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)STRING_RETURNING_GRAPH));
        this.returnGraphField = XmlHandler.getTagValue((Node)transformNode, (String)STRING_RETURN_GRAPH_FIELD);
        Node fromNode = XmlHandler.getSubNode((Node)transformNode, (String)STRING_FROM);
        this.readOnlyFromNode = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)fromNode, (String)STRING_READ_ONLY_FROM_NODE));
        Node fromLabelsNode = XmlHandler.getSubNode((Node)fromNode, (String)STRING_LABELS);
        List fromLabelNodes = XmlHandler.getNodes((Node)fromLabelsNode, (String)STRING_LABEL);
        List fromLabelValueNodes = XmlHandler.getNodes((Node)fromLabelsNode, (String)"value");
        this.fromNodeLabels = new String[fromLabelNodes.size()];
        this.fromNodeLabelValues = new String[Math.max(fromLabelValueNodes.size(), fromLabelNodes.size())];
        for (i2 = 0; i2 < fromLabelNodes.size(); ++i2) {
            Node labelNode = (Node)fromLabelNodes.get(i2);
            this.fromNodeLabels[i2] = XmlHandler.getNodeValue((Node)labelNode);
        }
        for (i2 = 0; i2 < fromLabelValueNodes.size(); ++i2) {
            Node valueNode = (Node)fromLabelValueNodes.get(i2);
            this.fromNodeLabelValues[i2] = XmlHandler.getNodeValue((Node)valueNode);
        }
        Node fromPropsNode = XmlHandler.getSubNode((Node)fromNode, (String)STRING_PROPERTIES);
        List fromPropertyNodes = XmlHandler.getNodes((Node)fromPropsNode, (String)STRING_PROPERTY);
        this.fromNodeProps = new String[fromPropertyNodes.size()];
        this.fromNodePropNames = new String[fromPropertyNodes.size()];
        this.fromNodePropTypes = new String[fromPropertyNodes.size()];
        this.fromNodePropPrimary = new boolean[fromPropertyNodes.size()];
        for (int i3 = 0; i3 < fromPropertyNodes.size(); ++i3) {
            Node propNode = (Node)fromPropertyNodes.get(i3);
            this.fromNodeProps[i3] = XmlHandler.getTagValue((Node)propNode, (String)"value");
            this.fromNodePropNames[i3] = XmlHandler.getTagValue((Node)propNode, (String)STRING_PROPERTY_NAME);
            this.fromNodePropTypes[i3] = XmlHandler.getTagValue((Node)propNode, (String)STRING_PROPERTY_TYPE);
            this.fromNodePropPrimary[i3] = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)propNode, (String)STRING_PROPERTY_PRIMARY));
        }
        Node toNode = XmlHandler.getSubNode((Node)transformNode, (String)STRING_TO);
        this.readOnlyToNode = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)toNode, (String)STRING_READ_ONLY_TO_NODE));
        Node toLabelsNode = XmlHandler.getSubNode((Node)toNode, (String)STRING_LABELS);
        List toLabelNodes = XmlHandler.getNodes((Node)toLabelsNode, (String)STRING_LABEL);
        List toLabelValueNodes = XmlHandler.getNodes((Node)toLabelsNode, (String)"value");
        this.toNodeLabels = new String[toLabelNodes.size()];
        this.toNodeLabelValues = new String[Math.max(toLabelValueNodes.size(), toLabelNodes.size())];
        for (i = 0; i < toLabelNodes.size(); ++i) {
            Node labelNode = (Node)toLabelNodes.get(i);
            this.toNodeLabels[i] = XmlHandler.getNodeValue((Node)labelNode);
        }
        for (i = 0; i < toLabelValueNodes.size(); ++i) {
            Node valueNode = (Node)toLabelValueNodes.get(i);
            this.toNodeLabelValues[i] = XmlHandler.getNodeValue((Node)valueNode);
        }
        Node toPropsNode = XmlHandler.getSubNode((Node)toNode, (String)STRING_PROPERTIES);
        List toPropertyNodes = XmlHandler.getNodes((Node)toPropsNode, (String)STRING_PROPERTY);
        this.toNodeProps = new String[toPropertyNodes.size()];
        this.toNodePropNames = new String[toPropertyNodes.size()];
        this.toNodePropTypes = new String[toPropertyNodes.size()];
        this.toNodePropPrimary = new boolean[toPropertyNodes.size()];
        for (int i4 = 0; i4 < toPropertyNodes.size(); ++i4) {
            Node propNode = (Node)toPropertyNodes.get(i4);
            this.toNodeProps[i4] = XmlHandler.getTagValue((Node)propNode, (String)"value");
            this.toNodePropNames[i4] = XmlHandler.getTagValue((Node)propNode, (String)STRING_PROPERTY_NAME);
            this.toNodePropTypes[i4] = XmlHandler.getTagValue((Node)propNode, (String)STRING_PROPERTY_TYPE);
            this.toNodePropPrimary[i4] = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)propNode, (String)STRING_PROPERTY_PRIMARY));
        }
        this.relationship = XmlHandler.getTagValue((Node)transformNode, (String)STRING_RELATIONSHIP);
        this.relationshipValue = XmlHandler.getTagValue((Node)transformNode, (String)STRING_RELATIONSHIP_VALUE);
        Node relPropsNode = XmlHandler.getSubNode((Node)transformNode, (String)STRING_RELPROPS);
        List relPropNodes = XmlHandler.getNodes((Node)relPropsNode, (String)STRING_RELPROP);
        this.relProps = new String[relPropNodes.size()];
        this.relPropNames = new String[relPropNodes.size()];
        this.relPropTypes = new String[relPropNodes.size()];
        for (int i5 = 0; i5 < relPropNodes.size(); ++i5) {
            Node propNode = (Node)relPropNodes.get(i5);
            this.relProps[i5] = XmlHandler.getTagValue((Node)propNode, (String)"value");
            this.relPropNames[i5] = XmlHandler.getTagValue((Node)propNode, (String)STRING_PROPERTY_NAME);
            this.relPropTypes[i5] = XmlHandler.getTagValue((Node)propNode, (String)STRING_PROPERTY_TYPE);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables space, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous transform!", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, "Transform is connected to previous one, receiving " + prev.size() + " fields", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Transform is receiving info from other transform.", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, "No input received from other transform!", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextStep, IVariables space, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.returningGraph) {
            ValueMetaGraph valueMetaGraph = new ValueMetaGraph(Const.NVL((String)this.returnGraphField, (String)"graph"));
            valueMetaGraph.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)valueMetaGraph);
        }
    }

    public Object clone() {
        return super.clone();
    }

    protected boolean dynamicLabels(String[] nodeLabelsFields) {
        for (String nodeLabelField : nodeLabelsFields) {
            if (!StringUtils.isNotEmpty((String)nodeLabelField)) continue;
            return true;
        }
        return false;
    }

    public boolean dynamicFromLabels() {
        return this.dynamicLabels(this.fromNodeLabels);
    }

    public boolean dynamicToLabels() {
        return this.dynamicLabels(this.toNodeLabels);
    }

    public boolean dynamicRelationshipLabel() {
        return StringUtils.isNotEmpty((String)this.relationship);
    }

    public boolean isCreatingRelationships() {
        return StringUtils.isNotEmpty((String)this.relationship) || StringUtils.isNotEmpty((String)this.relationshipValue);
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isCreatingIndexes() {
        return this.creatingIndexes;
    }

    public void setCreatingIndexes(boolean creatingIndexes) {
        this.creatingIndexes = creatingIndexes;
    }

    public boolean isUsingCreate() {
        return this.usingCreate;
    }

    public void setUsingCreate(boolean usingCreate) {
        this.usingCreate = usingCreate;
    }

    public boolean isOnlyCreatingRelationships() {
        return this.onlyCreatingRelationships;
    }

    public void setOnlyCreatingRelationships(boolean onlyCreatingRelationships) {
        this.onlyCreatingRelationships = onlyCreatingRelationships;
    }

    public String[] getFromNodeProps() {
        return this.fromNodeProps;
    }

    public void setFromNodeProps(String[] fromNodeProps) {
        this.fromNodeProps = fromNodeProps;
    }

    public String[] getFromNodePropNames() {
        return this.fromNodePropNames;
    }

    public void setFromNodePropNames(String[] fromNodePropNames) {
        this.fromNodePropNames = fromNodePropNames;
    }

    public String[] getFromNodePropTypes() {
        return this.fromNodePropTypes;
    }

    public void setFromNodePropTypes(String[] fromNodePropTypes) {
        this.fromNodePropTypes = fromNodePropTypes;
    }

    public boolean[] getFromNodePropPrimary() {
        return this.fromNodePropPrimary;
    }

    public void setFromNodePropPrimary(boolean[] fromNodePropPrimary) {
        this.fromNodePropPrimary = fromNodePropPrimary;
    }

    public String[] getToNodeProps() {
        return this.toNodeProps;
    }

    public void setToNodeProps(String[] toNodeProps) {
        this.toNodeProps = toNodeProps;
    }

    public String[] getToNodePropNames() {
        return this.toNodePropNames;
    }

    public void setToNodePropNames(String[] toNodePropNames) {
        this.toNodePropNames = toNodePropNames;
    }

    public String[] getToNodePropTypes() {
        return this.toNodePropTypes;
    }

    public void setToNodePropTypes(String[] toNodePropTypes) {
        this.toNodePropTypes = toNodePropTypes;
    }

    public boolean[] getToNodePropPrimary() {
        return this.toNodePropPrimary;
    }

    public void setToNodePropPrimary(boolean[] toNodePropPrimary) {
        this.toNodePropPrimary = toNodePropPrimary;
    }

    public String[] getFromNodeLabels() {
        return this.fromNodeLabels;
    }

    public void setFromNodeLabels(String[] fromNodeLabels) {
        this.fromNodeLabels = fromNodeLabels;
    }

    public String[] getToNodeLabels() {
        return this.toNodeLabels;
    }

    public void setToNodeLabels(String[] toNodeLabels) {
        this.toNodeLabels = toNodeLabels;
    }

    public String[] getRelProps() {
        return this.relProps;
    }

    public void setRelProps(String[] relProps) {
        this.relProps = relProps;
    }

    public String[] getRelPropNames() {
        return this.relPropNames;
    }

    public void setRelPropNames(String[] relPropNames) {
        this.relPropNames = relPropNames;
    }

    public String[] getRelPropTypes() {
        return this.relPropTypes;
    }

    public void setRelPropTypes(String[] relPropTypes) {
        this.relPropTypes = relPropTypes;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    public String[] getFromNodeLabelValues() {
        return this.fromNodeLabelValues;
    }

    public void setFromNodeLabelValues(String[] fromNodeLabelValues) {
        this.fromNodeLabelValues = fromNodeLabelValues;
    }

    public String[] getToNodeLabelValues() {
        return this.toNodeLabelValues;
    }

    public void setToNodeLabelValues(String[] toNodeLabelValues) {
        this.toNodeLabelValues = toNodeLabelValues;
    }

    public String getRelationshipValue() {
        return this.relationshipValue;
    }

    public void setRelationshipValue(String relationshipValue) {
        this.relationshipValue = relationshipValue;
    }

    public boolean isReturningGraph() {
        return this.returningGraph;
    }

    public void setReturningGraph(boolean returningGraph) {
        this.returningGraph = returningGraph;
    }

    public String getReturnGraphField() {
        return this.returnGraphField;
    }

    public void setReturnGraphField(String returnGraphField) {
        this.returnGraphField = returnGraphField;
    }

    public boolean isReadOnlyFromNode() {
        return this.readOnlyFromNode;
    }

    public void setReadOnlyFromNode(boolean readOnlyFromNode) {
        this.readOnlyFromNode = readOnlyFromNode;
    }

    public boolean isReadOnlyToNode() {
        return this.readOnlyToNode;
    }

    public void setReadOnlyToNode(boolean readOnlyToNode) {
        this.readOnlyToNode = readOnlyToNode;
    }
}

