/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.loginfo;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfo;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfoMeta;
import org.apache.hop.neo4j.transforms.loginfo.GetLoggingInfoTypes;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class GetLoggingInfoDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static Class<?> PKG = GetLoggingInfo.class;
    private Label wlTransformname;
    private Text wTransformname;
    private FormData fdlTransformname;
    private FormData fdTransformname;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private GetLoggingInfoMeta input;
    private boolean isReceivingInput = false;

    public GetLoggingInfoDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (GetLoggingInfoMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GetLoggingInfoDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.Button.PreviewRows", (String[])new String[0]));
        this.wPreview.setEnabled(!this.isReceivingInput);
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        this.isReceivingInput = this.pipelineMeta.findPreviousTransforms(this.transformMeta).size() > 0;
        this.wlTransformname = new Label((Composite)this.shell, 131072);
        this.wlTransformname.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformname);
        this.fdlTransformname = new FormData();
        this.fdlTransformname.left = new FormAttachment(0, 0);
        this.fdlTransformname.right = new FormAttachment(middle, -margin);
        this.fdlTransformname.top = new FormAttachment(0, margin);
        this.wlTransformname.setLayoutData((Object)this.fdlTransformname);
        this.wTransformname = new Text((Composite)this.shell, 18436);
        this.wTransformname.setText(this.transformName);
        this.props.setLook((Control)this.wTransformname);
        this.wTransformname.addModifyListener(lsMod);
        this.fdTransformname = new FormData();
        this.fdTransformname.left = new FormAttachment(middle, 0);
        this.fdTransformname.top = new FormAttachment(0, margin);
        this.fdTransformname.right = new FormAttachment(100, 0);
        this.wTransformname.setLayoutData((Object)this.fdTransformname);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wTransformname, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsCols = 3;
        int FieldsRows = this.input.getFieldName().length;
        final String[] functionDesc = new String[GetLoggingInfoTypes.values().length - 1];
        for (int i = 1; i < GetLoggingInfoTypes.values().length; ++i) {
            functionDesc[i - 1] = GetLoggingInfoTypes.values()[i].lookupDescription();
        }
        ColumnInfo[] colinf = new ColumnInfo[3];
        colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.NameColumn.Column", (String[])new String[0]), 1, false);
        colinf[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.TypeColumn.Column", (String[])new String[0]), 1, false);
        colinf[1].setSelectionAdapter((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterSelectionDialog esd = new EnterSelectionDialog(GetLoggingInfoDialog.this.shell, functionDesc, BaseMessages.getString((Class)PKG, (String)"GetLoggingInfoDialog.SelectInfoType.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"GetLoggingInfoDialog.SelectInfoType.DialogMessage", (String[])new String[0]));
                String string = esd.open();
                if (string != null) {
                    TableView tv = (TableView)e.widget;
                    tv.setText(string, e.x, e.y);
                }
                GetLoggingInfoDialog.this.input.setChanged();
            }
        });
        colinf[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.ArgumentColumn.Column", (String[])new String[0]), 1, false);
        colinf[2].setUsingVariables(true);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)this.fdFields);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wTransformname.setText(this.transformName);
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, Const.NVL((String)this.input.getFieldName()[i], (String)""));
            item.setText(2, Const.NVL((String)this.input.getFieldType()[i].lookupDescription(), (String)""));
            item.setText(3, Const.NVL((String)this.input.getFieldArgument()[i], (String)""));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformname.selectAll();
        this.wTransformname.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (StringUtils.isEmpty((String)this.wTransformname.getText())) {
            return;
        }
        try {
            this.getInfo(this.input);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    private void getInfo(GetLoggingInfoMeta in) throws HopException {
        this.transformName = this.wTransformname.getText();
        int count = this.wFields.nrNonEmpty();
        in.allocate(count);
        for (int i = 0; i < count; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            in.getFieldName()[i] = item.getText(1);
            in.getFieldType()[i] = GetLoggingInfoTypes.getTypeFromString(item.getText(2));
            in.getFieldArgument()[i] = item.getText(3);
        }
    }

    private void preview() {
        try {
            GetLoggingInfoMeta oneMeta = new GetLoggingInfoMeta();
            this.getInfo(oneMeta);
            PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.metadataProvider, (ITransformMeta)oneMeta, (String)this.wTransformname.getText());
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.NumberRows.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.NumberRows.DialogMessage", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformname.getText()}, new int[]{previewSize});
                progressDialog.open();
                if (!progressDialog.isCancelled()) {
                    Pipeline pipeline = progressDialog.getPipeline();
                    String loggingText = progressDialog.getLoggingText();
                    if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                        etd.setReadOnly();
                        etd.open();
                    }
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformname.getText(), progressDialog.getPreviewRowsMeta(this.wTransformname.getText()), progressDialog.getPreviewRows(this.wTransformname.getText()), loggingText);
                    prd.open();
                }
            }
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.ErrorPreviewingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetLoggingInfoDialog.ErrorPreviewingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }
}

