/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.importer;

import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.transforms.importer.Importer;
import org.apache.hop.neo4j.transforms.importer.ImporterData;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.w3c.dom.Node;

@Transform(id="Neo4jImport", name="Neo4j Import", description="Runs an import command using the provided CSV files ", image="neo4j_import.svg", categoryDescription="Neo4j", documentationUrl="/pipeline/transforms/neo4j-import.html")
public class ImporterMeta
extends BaseTransformMeta
implements ITransformMeta<Importer, ImporterData> {
    public static final String DB_NAME = "db_name";
    public static final String FILENAME_FIELD = "filename_field_name";
    public static final String FILE_TYPE_FIELD = "file_type_field_name";
    public static final String BASE_FOLDER = "base_folder";
    public static final String REPORT_FILE = "report_file";
    public static final String ADMIN_COMMAND = "admin_command";
    public static final String VERBOSE = "verbose";
    public static final String HIGH_IO = "high_io";
    public static final String CACHE_ON_HEAP = "cache_on_heap";
    public static final String IGNORE_EMPTY_STRINGS = "ignore_empty_strings";
    public static final String IGNORE_EXTRA_COLUMNS = "ignore_extra_columns";
    public static final String LEGACY_STYLE_QUOTING = "legacy_style_quoting";
    public static final String MULTI_LINE = "multi_line";
    public static final String NORMALIZE_TYPES = "normalize_types";
    public static final String SKIP_BAD_ENTRIES_LOGGING = "skip_bad_entries_logging";
    public static final String SKIP_BAD_RELATIONSHIPS = "skip_bad_relationships";
    public static final String SKIP_DUPLICATE_NODES = "skip_duplicate_nodes";
    public static final String TRIM_STRINGS = "trim_strings";
    public static final String BAD_TOLERANCE = "bad_tolerance";
    public static final String MAX_MEMORY = "max_memory";
    public static final String READ_BUFFER_SIZE = "read_buffer_size";
    public static final String PROCESSORS = "processors";
    protected String filenameField;
    protected String fileTypeField;
    protected String baseFolder;
    protected String adminCommand;
    protected String reportFile;
    protected String databaseName;
    protected boolean verbose;
    protected boolean highIo;
    protected boolean cacheOnHeap;
    protected boolean ignoringEmptyStrings;
    protected boolean ignoringExtraColumns;
    protected boolean quotingLegacyStyle;
    protected boolean multiLine;
    protected boolean normalizingTypes;
    protected boolean skippingBadEntriesLogging;
    protected boolean skippingBadRelationships;
    protected boolean skippingDuplicateNodes;
    protected boolean trimmingStrings;
    protected String badTolerance;
    protected String maxMemory;
    protected String readBufferSize;
    protected String processors;

    public void setDefault() {
        this.databaseName = "neo4j";
        this.adminCommand = "neo4j-admin";
        this.baseFolder = "/var/lib/neo4j/";
        this.reportFile = "import.report";
        this.ignoringExtraColumns = false;
        this.multiLine = false;
        this.ignoringEmptyStrings = false;
        this.trimmingStrings = false;
        this.quotingLegacyStyle = false;
        this.readBufferSize = "4M";
        this.maxMemory = "90%";
        this.highIo = true;
        this.cacheOnHeap = false;
        this.badTolerance = "1000";
        this.skippingBadEntriesLogging = false;
        this.skippingBadRelationships = false;
        this.skippingDuplicateNodes = false;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextStep, IVariables space, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    public String getXml() throws HopException {
        StringBuffer xml = new StringBuffer();
        xml.append(XmlHandler.addTagValue((String)FILENAME_FIELD, (String)this.filenameField));
        xml.append(XmlHandler.addTagValue((String)FILE_TYPE_FIELD, (String)this.fileTypeField));
        xml.append(XmlHandler.addTagValue((String)ADMIN_COMMAND, (String)this.adminCommand));
        xml.append(XmlHandler.addTagValue((String)BASE_FOLDER, (String)this.baseFolder));
        xml.append(XmlHandler.addTagValue((String)REPORT_FILE, (String)this.reportFile));
        xml.append(XmlHandler.addTagValue((String)DB_NAME, (String)this.databaseName));
        xml.append(XmlHandler.addTagValue((String)VERBOSE, (boolean)this.verbose));
        xml.append(XmlHandler.addTagValue((String)HIGH_IO, (boolean)this.highIo));
        xml.append(XmlHandler.addTagValue((String)CACHE_ON_HEAP, (boolean)this.cacheOnHeap));
        xml.append(XmlHandler.addTagValue((String)IGNORE_EMPTY_STRINGS, (boolean)this.ignoringEmptyStrings));
        xml.append(XmlHandler.addTagValue((String)IGNORE_EXTRA_COLUMNS, (boolean)this.ignoringExtraColumns));
        xml.append(XmlHandler.addTagValue((String)LEGACY_STYLE_QUOTING, (boolean)this.quotingLegacyStyle));
        xml.append(XmlHandler.addTagValue((String)MULTI_LINE, (boolean)this.multiLine));
        xml.append(XmlHandler.addTagValue((String)NORMALIZE_TYPES, (boolean)this.normalizingTypes));
        xml.append(XmlHandler.addTagValue((String)SKIP_BAD_ENTRIES_LOGGING, (boolean)this.skippingBadEntriesLogging));
        xml.append(XmlHandler.addTagValue((String)SKIP_BAD_RELATIONSHIPS, (boolean)this.skippingBadRelationships));
        xml.append(XmlHandler.addTagValue((String)MAX_MEMORY, (String)this.maxMemory));
        xml.append(XmlHandler.addTagValue((String)TRIM_STRINGS, (boolean)this.trimmingStrings));
        xml.append(XmlHandler.addTagValue((String)BAD_TOLERANCE, (String)this.badTolerance));
        xml.append(XmlHandler.addTagValue((String)MAX_MEMORY, (String)this.maxMemory));
        xml.append(XmlHandler.addTagValue((String)READ_BUFFER_SIZE, (String)this.readBufferSize));
        xml.append(XmlHandler.addTagValue((String)PROCESSORS, (String)this.processors));
        return xml.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.filenameField = XmlHandler.getTagValue((Node)transformNode, (String)FILENAME_FIELD);
        this.fileTypeField = XmlHandler.getTagValue((Node)transformNode, (String)FILE_TYPE_FIELD);
        this.adminCommand = XmlHandler.getTagValue((Node)transformNode, (String)ADMIN_COMMAND);
        this.baseFolder = XmlHandler.getTagValue((Node)transformNode, (String)BASE_FOLDER);
        this.reportFile = XmlHandler.getTagValue((Node)transformNode, (String)REPORT_FILE);
        this.databaseName = XmlHandler.getTagValue((Node)transformNode, (String)DB_NAME);
        this.highIo = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)HIGH_IO));
        this.cacheOnHeap = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)CACHE_ON_HEAP));
        this.ignoringEmptyStrings = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)IGNORE_EMPTY_STRINGS));
        this.ignoringExtraColumns = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)IGNORE_EXTRA_COLUMNS));
        this.quotingLegacyStyle = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)LEGACY_STYLE_QUOTING));
        this.multiLine = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)MULTI_LINE));
        this.normalizingTypes = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)NORMALIZE_TYPES));
        this.skippingBadEntriesLogging = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)SKIP_BAD_ENTRIES_LOGGING));
        this.skippingBadRelationships = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)SKIP_BAD_RELATIONSHIPS));
        this.skippingDuplicateNodes = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)SKIP_DUPLICATE_NODES));
        this.trimmingStrings = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)TRIM_STRINGS));
        this.badTolerance = XmlHandler.getTagValue((Node)transformNode, (String)BAD_TOLERANCE);
        this.maxMemory = XmlHandler.getTagValue((Node)transformNode, (String)MAX_MEMORY);
        this.readBufferSize = XmlHandler.getTagValue((Node)transformNode, (String)READ_BUFFER_SIZE);
        this.processors = XmlHandler.getTagValue((Node)transformNode, (String)PROCESSORS);
    }

    public Importer createTransform(TransformMeta transformMeta, ImporterData iTransformData, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new Importer(transformMeta, this, iTransformData, copyNr, pipelineMeta, pipeline);
    }

    public ImporterData getTransformData() {
        return new ImporterData();
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public String getFileTypeField() {
        return this.fileTypeField;
    }

    public void setFileTypeField(String fileTypeField) {
        this.fileTypeField = fileTypeField;
    }

    public String getBaseFolder() {
        return this.baseFolder;
    }

    public void setBaseFolder(String baseFolder) {
        this.baseFolder = baseFolder;
    }

    public String getAdminCommand() {
        return this.adminCommand;
    }

    public void setAdminCommand(String adminCommand) {
        this.adminCommand = adminCommand;
    }

    public String getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(String reportFile) {
        this.reportFile = reportFile;
    }

    public String getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(String maxMemory) {
        this.maxMemory = maxMemory;
    }

    public boolean isSkippingDuplicateNodes() {
        return this.skippingDuplicateNodes;
    }

    public void setSkippingDuplicateNodes(boolean skippingDuplicateNodes) {
        this.skippingDuplicateNodes = skippingDuplicateNodes;
    }

    public boolean isIgnoringExtraColumns() {
        return this.ignoringExtraColumns;
    }

    public void setIgnoringExtraColumns(boolean ignoringExtraColumns) {
        this.ignoringExtraColumns = ignoringExtraColumns;
    }

    public boolean isHighIo() {
        return this.highIo;
    }

    public void setHighIo(boolean highIo) {
        this.highIo = highIo;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }

    public boolean isSkippingBadRelationships() {
        return this.skippingBadRelationships;
    }

    public void setSkippingBadRelationships(boolean skippingBadRelationships) {
        this.skippingBadRelationships = skippingBadRelationships;
    }

    public String getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(String readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public boolean isCacheOnHeap() {
        return this.cacheOnHeap;
    }

    public void setCacheOnHeap(boolean cacheOnHeap) {
        this.cacheOnHeap = cacheOnHeap;
    }

    public boolean isIgnoringEmptyStrings() {
        return this.ignoringEmptyStrings;
    }

    public void setIgnoringEmptyStrings(boolean ignoringEmptyStrings) {
        this.ignoringEmptyStrings = ignoringEmptyStrings;
    }

    public boolean isQuotingLegacyStyle() {
        return this.quotingLegacyStyle;
    }

    public void setQuotingLegacyStyle(boolean quotingLegacyStyle) {
        this.quotingLegacyStyle = quotingLegacyStyle;
    }

    public boolean isNormalizingTypes() {
        return this.normalizingTypes;
    }

    public void setNormalizingTypes(boolean normalizingTypes) {
        this.normalizingTypes = normalizingTypes;
    }

    public boolean isSkippingBadEntriesLogging() {
        return this.skippingBadEntriesLogging;
    }

    public void setSkippingBadEntriesLogging(boolean skippingBadEntriesLogging) {
        this.skippingBadEntriesLogging = skippingBadEntriesLogging;
    }

    public boolean isTrimmingStrings() {
        return this.trimmingStrings;
    }

    public void setTrimmingStrings(boolean trimmingStrings) {
        this.trimmingStrings = trimmingStrings;
    }

    public String getBadTolerance() {
        return this.badTolerance;
    }

    public void setBadTolerance(String badTolerance) {
        this.badTolerance = badTolerance;
    }

    public String getProcessors() {
        return this.processors;
    }

    public void setProcessors(String processors) {
        this.processors = processors;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

