/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.graph;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.core.value.ValueMetaGraph;
import org.apache.hop.neo4j.transforms.graph.FieldModelMapping;
import org.apache.hop.neo4j.transforms.graph.GraphOutput;
import org.apache.hop.neo4j.transforms.graph.GraphOutputData;
import org.apache.hop.neo4j.transforms.graph.GraphOutputDialog;
import org.apache.hop.neo4j.transforms.graph.ModelTargetType;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.w3c.dom.Node;

@Transform(id="Neo4jGraphOutput", name="Neo4j Graph Output", description="Write to a Neo4j graph using an input field mapping", image="neo4j_graph_output.svg", categoryDescription="Neo4j", documentationUrl="/pipeline/transforms/neo4j-graphoutput.html")
@InjectionSupported(localizationPrefix="GraphOutput.Injection.", groups={"MAPPINGS"})
public class GraphOutputMeta
extends BaseTransformMeta
implements ITransformMeta<GraphOutput, GraphOutputData> {
    private static final String RETURNING_GRAPH = "returning_graph";
    private static final String RETURN_GRAPH_FIELD = "return_graph_field";
    public static final String CONNECTION = "connection";
    public static final String MODEL = "model";
    public static final String BATCH_SIZE = "batch_size";
    public static final String CREATE_INDEXES = "create_indexes";
    public static final String MAPPINGS = "mappings";
    public static final String MAPPING = "mapping";
    public static final String SOURCE_FIELD = "source_field";
    public static final String TARGET_TYPE = "target_type";
    public static final String TARGET_NAME = "target_name";
    public static final String TARGET_PROPERTY = "target_property";
    public static final String VALIDATE_AGAINST_MODEL = "validate_against_model";
    public static final String OUT_OF_ORDER_ALLOWED = "out_of_order_allowed";
    @Injection(name="connection")
    private String connectionName;
    @Injection(name="model")
    private String model;
    @Injection(name="batch_size")
    private String batchSize;
    @Injection(name="create_indexes")
    private boolean creatingIndexes = true;
    @Injection(name="returning_graph")
    private boolean returningGraph;
    @Injection(name="return_graph_field")
    private String returnGraphField;
    @Injection(name="validate_against_model")
    private boolean validatingAgainstModel;
    @Injection(name="out_of_order_allowed")
    private boolean outOfOrderAllowed = true;
    @InjectionDeep
    private List<FieldModelMapping> fieldModelMappings = new ArrayList<FieldModelMapping>();

    public void setDefault() {
    }

    public GraphOutput createTransform(TransformMeta transformMeta, GraphOutputData iTransformData, int i, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new GraphOutput(transformMeta, this, iTransformData, i, pipelineMeta, pipeline);
    }

    public GraphOutputData getTransformData() {
        return new GraphOutputData();
    }

    public String getDialogClassName() {
        return GraphOutputDialog.class.getName();
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextStep, IVariables space, IHopMetadataProvider metadataProvider) {
        if (this.returningGraph) {
            ValueMetaGraph valueMetaGraph = new ValueMetaGraph(Const.NVL((String)this.returnGraphField, (String)"graph"));
            valueMetaGraph.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)valueMetaGraph);
        }
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.addTagValue((String)CONNECTION, (String)this.connectionName));
        xml.append(XmlHandler.addTagValue((String)MODEL, (String)this.model));
        xml.append(XmlHandler.addTagValue((String)BATCH_SIZE, (String)this.batchSize));
        xml.append(XmlHandler.addTagValue((String)CREATE_INDEXES, (boolean)this.creatingIndexes));
        xml.append(XmlHandler.addTagValue((String)RETURNING_GRAPH, (boolean)this.returningGraph));
        xml.append(XmlHandler.addTagValue((String)RETURN_GRAPH_FIELD, (String)this.returnGraphField));
        xml.append(XmlHandler.addTagValue((String)VALIDATE_AGAINST_MODEL, (boolean)this.validatingAgainstModel));
        xml.append(XmlHandler.addTagValue((String)OUT_OF_ORDER_ALLOWED, (boolean)this.outOfOrderAllowed));
        xml.append(XmlHandler.openTag((String)MAPPINGS));
        for (FieldModelMapping fieldModelMapping : this.fieldModelMappings) {
            xml.append(XmlHandler.openTag((String)MAPPING));
            xml.append(XmlHandler.addTagValue((String)SOURCE_FIELD, (String)fieldModelMapping.getField()));
            xml.append(XmlHandler.addTagValue((String)TARGET_TYPE, (String)ModelTargetType.getCode(fieldModelMapping.getTargetType())));
            xml.append(XmlHandler.addTagValue((String)TARGET_NAME, (String)fieldModelMapping.getTargetName()));
            xml.append(XmlHandler.addTagValue((String)TARGET_PROPERTY, (String)fieldModelMapping.getTargetProperty()));
            xml.append(XmlHandler.closeTag((String)MAPPING));
        }
        xml.append(XmlHandler.closeTag((String)MAPPINGS));
        return xml.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.connectionName = XmlHandler.getTagValue((Node)transformNode, (String)CONNECTION);
        this.model = XmlHandler.getTagValue((Node)transformNode, (String)MODEL);
        this.batchSize = XmlHandler.getTagValue((Node)transformNode, (String)BATCH_SIZE);
        this.creatingIndexes = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)CREATE_INDEXES));
        this.returningGraph = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)RETURNING_GRAPH));
        this.returnGraphField = XmlHandler.getTagValue((Node)transformNode, (String)RETURN_GRAPH_FIELD);
        this.validatingAgainstModel = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)VALIDATE_AGAINST_MODEL));
        this.outOfOrderAllowed = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)OUT_OF_ORDER_ALLOWED));
        Node mappingsNode = XmlHandler.getSubNode((Node)transformNode, (String)MAPPINGS);
        List mappingNodes = XmlHandler.getNodes((Node)mappingsNode, (String)MAPPING);
        this.fieldModelMappings = new ArrayList<FieldModelMapping>();
        for (Node mappingNode : mappingNodes) {
            String field = XmlHandler.getTagValue((Node)mappingNode, (String)SOURCE_FIELD);
            ModelTargetType targetType = ModelTargetType.parseCode(XmlHandler.getTagValue((Node)mappingNode, (String)TARGET_TYPE));
            String targetName = XmlHandler.getTagValue((Node)mappingNode, (String)TARGET_NAME);
            String targetProperty = XmlHandler.getTagValue((Node)mappingNode, (String)TARGET_PROPERTY);
            this.fieldModelMappings.add(new FieldModelMapping(field, targetType, targetName, targetProperty));
        }
        super.loadXml(transformNode, metadataProvider);
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isCreatingIndexes() {
        return this.creatingIndexes;
    }

    public void setCreatingIndexes(boolean creatingIndexes) {
        this.creatingIndexes = creatingIndexes;
    }

    public List<FieldModelMapping> getFieldModelMappings() {
        return this.fieldModelMappings;
    }

    public void setFieldModelMappings(List<FieldModelMapping> fieldModelMappings) {
        this.fieldModelMappings = fieldModelMappings;
    }

    public boolean isReturningGraph() {
        return this.returningGraph;
    }

    public void setReturningGraph(boolean returningGraph) {
        this.returningGraph = returningGraph;
    }

    public String getReturnGraphField() {
        return this.returnGraphField;
    }

    public void setReturnGraphField(String returnGraphField) {
        this.returnGraphField = returnGraphField;
    }

    public boolean isValidatingAgainstModel() {
        return this.validatingAgainstModel;
    }

    public void setValidatingAgainstModel(boolean validatingAgainstModel) {
        this.validatingAgainstModel = validatingAgainstModel;
    }

    public boolean isOutOfOrderAllowed() {
        return this.outOfOrderAllowed;
    }

    public void setOutOfOrderAllowed(boolean outOfOrderAllowed) {
        this.outOfOrderAllowed = outOfOrderAllowed;
    }
}

