/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.graph;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.neo4j.model.GraphModel;
import org.apache.hop.neo4j.model.GraphNode;
import org.apache.hop.neo4j.model.GraphProperty;
import org.apache.hop.neo4j.model.GraphRelationship;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.neo4j.transforms.graph.FieldModelMapping;
import org.apache.hop.neo4j.transforms.graph.GraphOutputMeta;
import org.apache.hop.neo4j.transforms.graph.ModelTargetType;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class GraphOutputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static Class<?> PKG = GraphOutputMeta.class;
    private Text wTransformName;
    private MetaSelectionLine<NeoConnection> wConnection;
    private MetaSelectionLine<GraphModel> wModel;
    private Label wlBatchSize;
    private TextVar wBatchSize;
    private Label wlCreateIndexes;
    private Button wCreateIndexes;
    private Button wReturnGraph;
    private Label wlReturnGraphField;
    private TextVar wReturnGraphField;
    private Button wValidateAgainstModel;
    private Button wOutOfOrderAllowed;
    private TableView wFieldMappings;
    private GraphOutputMeta input;
    private GraphModel activeModel;

    public GraphOutputDialog(Shell parent, IVariables variables, Object inputMetadata, PipelineMeta pipelineMeta, String transformName) {
        super(parent, variables, (BaseTransformMeta)inputMetadata, pipelineMeta, transformName);
        this.input = (GraphOutputMeta)((Object)inputMetadata);
        this.metadataProvider = HopGui.getInstance().getMetadataProvider();
    }

    public String open() {
        String[] fieldNames;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText("Neo4j GraphOutput");
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText("Transform name");
        this.props.setLook((Control)wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        TextVar lastControl = this.wTransformName;
        this.wConnection = new MetaSelectionLine(this.variables, this.metadataProvider, NeoConnection.class, (Composite)this.shell, 18436, "Neo4j Connection", "The name of the Neo4j connection to use");
        this.props.setLook(this.wConnection);
        this.wConnection.addModifyListener(lsMod);
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment(100, 0);
        fdConnection.top = new FormAttachment((Control)lastControl, margin);
        this.wConnection.setLayoutData((Object)fdConnection);
        try {
            this.wConnection.fillItems();
        }
        catch (Exception e2) {
            new ErrorDialog(this.shell, "Error", "Error getting list of connections", e2);
        }
        lastControl = this.wConnection;
        this.wModel = new MetaSelectionLine(this.variables, this.metadataProvider, GraphModel.class, (Composite)this.shell, 18436, "Graph model", "The name of the Neo4j logical Graph Model to use");
        this.props.setLook(this.wModel);
        this.wModel.addModifyListener(lsMod);
        FormData fdModel = new FormData();
        fdModel.left = new FormAttachment(0, 0);
        fdModel.right = new FormAttachment(100, 0);
        fdModel.top = new FormAttachment(lastControl, margin);
        this.wModel.setLayoutData((Object)fdModel);
        try {
            this.wModel.fillItems();
        }
        catch (Exception e3) {
            new ErrorDialog(this.shell, "Error", "Error getting list of models", e3);
        }
        lastControl = this.wModel;
        this.wlBatchSize = new Label((Composite)this.shell, 131072);
        this.wlBatchSize.setText("Batch size (rows)");
        this.props.setLook((Control)this.wlBatchSize);
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.right = new FormAttachment(middle, -margin);
        fdlBatchSize.top = new FormAttachment(lastControl, 2 * margin);
        this.wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wBatchSize);
        this.wBatchSize.addModifyListener(lsMod);
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment(middle, 0);
        fdBatchSize.right = new FormAttachment(100, 0);
        fdBatchSize.top = new FormAttachment((Control)this.wlBatchSize, 0, 0x1000000);
        this.wBatchSize.setLayoutData((Object)fdBatchSize);
        lastControl = this.wBatchSize;
        this.wlCreateIndexes = new Label((Composite)this.shell, 131072);
        this.wlCreateIndexes.setText("Create indexes? ");
        this.wlCreateIndexes.setToolTipText("Create index on first row using label field and primary key properties.");
        this.props.setLook((Control)this.wlCreateIndexes);
        FormData fdlCreateIndexes = new FormData();
        fdlCreateIndexes.left = new FormAttachment(0, 0);
        fdlCreateIndexes.right = new FormAttachment(middle, -margin);
        fdlCreateIndexes.top = new FormAttachment((Control)lastControl, 2 * margin);
        this.wlCreateIndexes.setLayoutData((Object)fdlCreateIndexes);
        this.wCreateIndexes = new Button((Composite)this.shell, 2080);
        this.wCreateIndexes.setToolTipText("Create index on first row using label field and primary key properties.");
        this.props.setLook((Control)this.wCreateIndexes);
        FormData fdCreateIndexes = new FormData();
        fdCreateIndexes.left = new FormAttachment(middle, 0);
        fdCreateIndexes.right = new FormAttachment(100, 0);
        fdCreateIndexes.top = new FormAttachment((Control)this.wlCreateIndexes, 0, 0x1000000);
        this.wCreateIndexes.setLayoutData((Object)fdCreateIndexes);
        lastControl = this.wCreateIndexes;
        Label wlReturnGraph = new Label((Composite)this.shell, 131072);
        wlReturnGraph.setText("Return graph data?");
        String returnGraphTooltipText = "The update data to be updated in the form of Graph a value in the output of this transform";
        wlReturnGraph.setToolTipText(returnGraphTooltipText);
        this.props.setLook((Control)wlReturnGraph);
        FormData fdlReturnGraph = new FormData();
        fdlReturnGraph.left = new FormAttachment(0, 0);
        fdlReturnGraph.right = new FormAttachment(middle, -margin);
        fdlReturnGraph.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlReturnGraph.setLayoutData((Object)fdlReturnGraph);
        this.wReturnGraph = new Button((Composite)this.shell, 2080);
        this.wReturnGraph.setToolTipText(returnGraphTooltipText);
        this.props.setLook((Control)this.wReturnGraph);
        FormData fdReturnGraph = new FormData();
        fdReturnGraph.left = new FormAttachment(middle, 0);
        fdReturnGraph.right = new FormAttachment(100, 0);
        fdReturnGraph.top = new FormAttachment((Control)wlReturnGraph, 0, 0x1000000);
        this.wReturnGraph.setLayoutData((Object)fdReturnGraph);
        this.wReturnGraph.addListener(13, e -> this.enableFields());
        lastControl = this.wReturnGraph;
        this.wlReturnGraphField = new Label((Composite)this.shell, 131072);
        this.wlReturnGraphField.setText("Graph output field name");
        this.props.setLook((Control)this.wlReturnGraphField);
        FormData fdlReturnGraphField = new FormData();
        fdlReturnGraphField.left = new FormAttachment(0, 0);
        fdlReturnGraphField.right = new FormAttachment(middle, -margin);
        fdlReturnGraphField.top = new FormAttachment((Control)lastControl, 2 * margin);
        this.wlReturnGraphField.setLayoutData((Object)fdlReturnGraphField);
        this.wReturnGraphField = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wReturnGraphField);
        this.wReturnGraphField.addModifyListener(lsMod);
        FormData fdReturnGraphField = new FormData();
        fdReturnGraphField.left = new FormAttachment(middle, 0);
        fdReturnGraphField.right = new FormAttachment(100, 0);
        fdReturnGraphField.top = new FormAttachment((Control)this.wlReturnGraphField, 0, 0x1000000);
        this.wReturnGraphField.setLayoutData((Object)fdReturnGraphField);
        lastControl = this.wReturnGraphField;
        Label wlValidateAgainstModel = new Label((Composite)this.shell, 131072);
        wlValidateAgainstModel.setText("Validate against model?");
        wlValidateAgainstModel.setToolTipText("This validates indexes, constraints and properties as specified in the model");
        this.props.setLook((Control)wlValidateAgainstModel);
        FormData fdlValidateAgainstModel = new FormData();
        fdlValidateAgainstModel.left = new FormAttachment(0, 0);
        fdlValidateAgainstModel.right = new FormAttachment(middle, -margin);
        fdlValidateAgainstModel.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlValidateAgainstModel.setLayoutData((Object)fdlValidateAgainstModel);
        this.wValidateAgainstModel = new Button((Composite)this.shell, 2080);
        this.wValidateAgainstModel.setToolTipText(returnGraphTooltipText);
        this.props.setLook((Control)this.wValidateAgainstModel);
        FormData fdValidateAgainstModel = new FormData();
        fdValidateAgainstModel.left = new FormAttachment(middle, 0);
        fdValidateAgainstModel.right = new FormAttachment(100, 0);
        fdValidateAgainstModel.top = new FormAttachment((Control)wlValidateAgainstModel, 0, 0x1000000);
        this.wValidateAgainstModel.setLayoutData((Object)fdValidateAgainstModel);
        this.wValidateAgainstModel.addListener(13, e -> this.enableFields());
        lastControl = wlValidateAgainstModel;
        Label wlOutOfOrderAllowed = new Label((Composite)this.shell, 131072);
        wlOutOfOrderAllowed.setText("Allow out of order updates?");
        wlOutOfOrderAllowed.setToolTipText("The transform can group similar cypher statements to increase performance.");
        this.props.setLook((Control)wlOutOfOrderAllowed);
        FormData fdlOutOfOrderAllowed = new FormData();
        fdlOutOfOrderAllowed.left = new FormAttachment(0, 0);
        fdlOutOfOrderAllowed.right = new FormAttachment(middle, -margin);
        fdlOutOfOrderAllowed.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlOutOfOrderAllowed.setLayoutData((Object)fdlOutOfOrderAllowed);
        this.wOutOfOrderAllowed = new Button((Composite)this.shell, 2080);
        this.wOutOfOrderAllowed.setToolTipText(returnGraphTooltipText);
        this.props.setLook((Control)this.wOutOfOrderAllowed);
        FormData fdOutOfOrderAllowed = new FormData();
        fdOutOfOrderAllowed.left = new FormAttachment(middle, 0);
        fdOutOfOrderAllowed.right = new FormAttachment(100, 0);
        fdOutOfOrderAllowed.top = new FormAttachment((Control)wlOutOfOrderAllowed, 0, 0x1000000);
        this.wOutOfOrderAllowed.setLayoutData((Object)fdOutOfOrderAllowed);
        lastControl = wlOutOfOrderAllowed;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        Button wMapping = new Button((Composite)this.shell, 8);
        wMapping.setText("Map fields");
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, wMapping, this.wCancel}, margin, null);
        try {
            fieldNames = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName).getFieldNames();
        }
        catch (Exception e4) {
            this.logError("Unable to get fields from previous transform", e4);
            fieldNames = new String[]{};
        }
        ColumnInfo[] parameterColumns = new ColumnInfo[]{new ColumnInfo("Field", 2, fieldNames, false), new ColumnInfo("Target type", 2, ModelTargetType.getNames(), false), new ColumnInfo("Target", 2, new String[0], false), new ColumnInfo("Property", 2, new String[0], false)};
        Label wlFieldMappings = new Label((Composite)this.shell, 16384);
        wlFieldMappings.setText("Mappings...");
        this.props.setLook((Control)wlFieldMappings);
        FormData fdlFieldMappings = new FormData();
        fdlFieldMappings.left = new FormAttachment(0, 0);
        fdlFieldMappings.right = new FormAttachment(middle, -margin);
        fdlFieldMappings.top = new FormAttachment((Control)lastControl, margin);
        wlFieldMappings.setLayoutData((Object)fdlFieldMappings);
        this.wFieldMappings = new TableView(this.variables, (Composite)this.shell, 65538, parameterColumns, this.input.getFieldModelMappings().size(), lsMod, this.props);
        this.props.setLook((Control)this.wFieldMappings);
        this.wFieldMappings.addModifyListener(lsMod);
        FormData fdFieldMappings = new FormData();
        fdFieldMappings.left = new FormAttachment(0, 0);
        fdFieldMappings.right = new FormAttachment(100, 0);
        fdFieldMappings.top = new FormAttachment((Control)wlFieldMappings, margin);
        fdFieldMappings.bottom = new FormAttachment((Control)this.wOk, -margin * 2);
        this.wFieldMappings.setLayoutData((Object)fdFieldMappings);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        wMapping.addListener(13, e -> this.enterMapping());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void enableFields() {
        boolean toNeo = !this.wReturnGraph.getSelection();
        this.wConnection.setEnabled(toNeo);
        this.wlBatchSize.setEnabled(toNeo);
        this.wBatchSize.setEnabled(toNeo);
        this.wlCreateIndexes.setEnabled(toNeo);
        this.wCreateIndexes.setEnabled(toNeo);
        this.wlReturnGraphField.setEnabled(!toNeo);
        this.wReturnGraphField.setEnabled(!toNeo);
    }

    private void enterMapping() {
        try {
            String combo;
            IHopMetadataSerializer modelSerializer = this.metadataProvider.getSerializer(GraphModel.class);
            if (this.activeModel == null) {
                if (StringUtils.isEmpty((String)this.wModel.getText())) {
                    return;
                }
                this.activeModel = (GraphModel)modelSerializer.load(this.wModel.getText());
            }
            IRowMeta inputRowMeta = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
            String[] inputFields = inputRowMeta.getFieldNames();
            String separator = " . ";
            ArrayList<String> targetPropertiesList = new ArrayList<String>();
            for (GraphNode node : this.activeModel.getNodes()) {
                for (GraphProperty property : node.getProperties()) {
                    combo = node.getName() + " . " + property.getName();
                    targetPropertiesList.add(combo);
                }
            }
            for (GraphRelationship relationship : this.activeModel.getRelationships()) {
                for (GraphProperty property : relationship.getProperties()) {
                    combo = relationship.getName() + " . " + property.getName();
                    targetPropertiesList.add(combo);
                }
            }
            String[] targetProperties = targetPropertiesList.toArray(new String[0]);
            List<SourceToTargetMapping> mappings = new ArrayList();
            for (int i = 0; i < this.wFieldMappings.nrNonEmpty(); ++i) {
                TableItem item = this.wFieldMappings.getNonEmpty(i);
                int sourceIndex = Const.indexOfString((String)item.getText(1), (String[])inputFields);
                int targetIndex = Const.indexOfString((String)(item.getText(3) + separator + item.getText(4)), (String[])targetProperties);
                if (sourceIndex < 0 || targetIndex < 0) continue;
                mappings.add(new SourceToTargetMapping(sourceIndex, targetIndex));
            }
            EnterMappingDialog dialog = new EnterMappingDialog(this.shell, inputFields, targetProperties, mappings);
            if ((mappings = dialog.open()) != null) {
                this.wFieldMappings.clearAll();
                for (SourceToTargetMapping mapping : mappings) {
                    String field = mapping.getSourceString(inputFields);
                    String target = mapping.getTargetString(targetProperties);
                    int index = target.indexOf(separator);
                    String targetName = target.substring(0, index);
                    String property = target.substring(index + separator.length());
                    String targetType = null;
                    if (this.activeModel.findNode(targetName) != null) {
                        targetType = "Node";
                    } else if (this.activeModel.findRelationship(targetName) != null) {
                        targetType = "Relationship";
                    } else {
                        throw new HopException("Neither node nor pipeline found for target '" + targetName + ": internal error");
                    }
                    this.wFieldMappings.add(new String[]{field, targetType, targetName, property});
                }
                this.wFieldMappings.removeEmptyRows();
                this.wFieldMappings.setRowNums();
                this.wFieldMappings.optWidth(true);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error mapping input fields to node properties", e);
        }
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    public void getData() {
        this.wTransformName.setText(Const.NVL((String)this.transformName, (String)""));
        this.wConnection.setText(Const.NVL((String)this.input.getConnectionName(), (String)""));
        try {
            this.wConnection.fillItems();
        }
        catch (HopException e) {
            this.log.logError("Error getting list of Neo4j Connection names", (Throwable)e);
        }
        this.wModel.setText(Const.NVL((String)this.input.getModel(), (String)""));
        try {
            this.wModel.fillItems();
        }
        catch (HopException e) {
            this.log.logError("Error getting list of Neo4j Graph Model names", (Throwable)e);
        }
        this.wBatchSize.setText(Const.NVL((String)this.input.getBatchSize(), (String)""));
        this.wCreateIndexes.setSelection(this.input.isCreatingIndexes());
        for (int i = 0; i < this.input.getFieldModelMappings().size(); ++i) {
            FieldModelMapping mapping = this.input.getFieldModelMappings().get(i);
            TableItem item = this.wFieldMappings.table.getItem(i);
            int idx = 1;
            item.setText(idx++, Const.NVL((String)mapping.getField(), (String)""));
            item.setText(idx++, ModelTargetType.getCode(mapping.getTargetType()));
            item.setText(idx++, Const.NVL((String)mapping.getTargetName(), (String)""));
            item.setText(idx++, Const.NVL((String)mapping.getTargetProperty(), (String)""));
        }
        this.wFieldMappings.removeEmptyRows();
        this.wFieldMappings.setRowNums();
        this.wFieldMappings.optWidth(true);
        this.wReturnGraph.setSelection(this.input.isReturningGraph());
        this.wReturnGraphField.setText(Const.NVL((String)this.input.getReturnGraphField(), (String)""));
        this.wValidateAgainstModel.setSelection(this.input.isValidatingAgainstModel());
        this.wOutOfOrderAllowed.setSelection(this.input.isOutOfOrderAllowed());
        this.enableFields();
    }

    private void ok() {
        if (StringUtils.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setConnectionName(this.wConnection.getText());
        this.input.setBatchSize(this.wBatchSize.getText());
        this.input.setCreatingIndexes(this.wCreateIndexes.getSelection());
        this.input.setModel(this.wModel.getText());
        this.input.setReturningGraph(this.wReturnGraph.getSelection());
        this.input.setReturnGraphField(this.wReturnGraphField.getText());
        this.input.setValidatingAgainstModel(this.wValidateAgainstModel.getSelection());
        this.input.setOutOfOrderAllowed(this.wOutOfOrderAllowed.getSelection());
        ArrayList<FieldModelMapping> mappings = new ArrayList<FieldModelMapping>();
        for (int i = 0; i < this.wFieldMappings.nrNonEmpty(); ++i) {
            TableItem item = this.wFieldMappings.getNonEmpty(i);
            int idx = 1;
            String sourceField = item.getText(idx++);
            ModelTargetType targetType = ModelTargetType.parseCode(item.getText(idx++));
            String targetName = item.getText(idx++);
            String targetProperty = item.getText(idx++);
            mappings.add(new FieldModelMapping(sourceField, targetType, targetName, targetProperty));
        }
        this.input.setFieldModelMappings(mappings);
        this.dispose();
    }

    private IRowMeta getInputRowMeta() {
        IRowMeta inputRowMeta = null;
        try {
            inputRowMeta = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
        }
        catch (HopTransformException e) {
            LogChannel.GENERAL.logError("Unable to find transform input field", (Throwable)e);
        }
        return inputRowMeta;
    }
}

