/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.neo4j.core.GraphUsage;
import org.apache.hop.neo4j.core.data.GraphData;
import org.apache.hop.neo4j.core.data.GraphNodeData;
import org.apache.hop.neo4j.core.data.GraphPropertyData;
import org.apache.hop.neo4j.core.data.GraphPropertyDataType;
import org.apache.hop.neo4j.core.data.GraphRelationshipData;
import org.apache.hop.neo4j.model.GraphModel;
import org.apache.hop.neo4j.model.GraphNode;
import org.apache.hop.neo4j.model.GraphProperty;
import org.apache.hop.neo4j.model.GraphPropertyType;
import org.apache.hop.neo4j.model.GraphRelationship;
import org.apache.hop.neo4j.model.validation.ModelValidator;
import org.apache.hop.neo4j.model.validation.NodeProperty;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.neo4j.shared.NeoConnectionUtils;
import org.apache.hop.neo4j.transforms.BaseNeoTransform;
import org.apache.hop.neo4j.transforms.graph.CypherParameters;
import org.apache.hop.neo4j.transforms.graph.FieldModelMapping;
import org.apache.hop.neo4j.transforms.graph.GraphOutputData;
import org.apache.hop.neo4j.transforms.graph.GraphOutputMeta;
import org.apache.hop.neo4j.transforms.graph.ModelTargetType;
import org.apache.hop.neo4j.transforms.graph.TargetParameter;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.neo4j.driver.Result;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.ResultSummary;

public class GraphOutput
extends BaseNeoTransform<GraphOutputMeta, GraphOutputData>
implements ITransform<GraphOutputMeta, GraphOutputData> {
    public GraphOutput(TransformMeta transformMeta, GraphOutputMeta meta, GraphOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, meta, data, copyNr, pipelineMeta, pipeline);
    }

    @Override
    public boolean init() {
        try {
            if (!((GraphOutputMeta)this.meta).isReturningGraph()) {
                if (StringUtils.isEmpty((String)((GraphOutputMeta)this.meta).getConnectionName())) {
                    this.log.logError("You need to specify a Neo4j connection to use in this transform");
                    return false;
                }
                IHopMetadataSerializer serializer = this.metadataProvider.getSerializer(NeoConnection.class);
                ((GraphOutputData)this.data).neoConnection = (NeoConnection)serializer.load(((GraphOutputMeta)this.meta).getConnectionName());
                if (((GraphOutputData)this.data).neoConnection == null) {
                    this.log.logError("Connection '" + ((GraphOutputMeta)this.meta).getConnectionName() + "' could not be found in the metadata : " + this.metadataProvider.getDescription());
                    return false;
                }
                try {
                    ((GraphOutputData)this.data).driver = ((GraphOutputData)this.data).neoConnection.getDriver(this.log, (IVariables)this);
                    ((GraphOutputData)this.data).session = ((GraphOutputData)this.data).neoConnection.getSession(this.log, ((GraphOutputData)this.data).driver, (IVariables)this);
                    ((GraphOutputData)this.data).version4 = ((GraphOutputData)this.data).neoConnection.isVersion4();
                }
                catch (Exception e) {
                    this.log.logError("Unable to get or create Neo4j database driver for database '" + ((GraphOutputData)this.data).neoConnection.getName() + "'", (Throwable)e);
                    return false;
                }
                ((GraphOutputData)this.data).batchSize = Const.toLong((String)this.resolve(((GraphOutputMeta)this.meta).getBatchSize()), (long)1L);
            }
            if (StringUtils.isEmpty((String)((GraphOutputMeta)this.meta).getModel())) {
                this.logError("No model name is specified");
                return false;
            }
            IHopMetadataSerializer modelSerializer = this.metadataProvider.getSerializer(GraphModel.class);
            ((GraphOutputData)this.data).graphModel = (GraphModel)modelSerializer.load(((GraphOutputMeta)this.meta).getModel());
            if (((GraphOutputData)this.data).graphModel == null) {
                this.logError("Model '" + ((GraphOutputMeta)this.meta).getModel() + "' could not be found!");
                return false;
            }
            ((GraphOutputData)this.data).modelValidator = null;
            if (((GraphOutputMeta)this.meta).isValidatingAgainstModel()) {
                List<NodeProperty> usedNodeProperties = this.findUsedNodeProperties();
                ((GraphOutputData)this.data).modelValidator = new ModelValidator(((GraphOutputData)this.data).graphModel, usedNodeProperties);
                int nrErrors = ((GraphOutputData)this.data).modelValidator.validateBeforeLoad(this.log, ((GraphOutputData)this.data).session);
                if (nrErrors > 0) {
                    this.log.logError("Validation against graph model '" + ((GraphOutputData)this.data).graphModel.getName() + "' failed with " + nrErrors + " errors.");
                    return false;
                }
                this.log.logBasic("Validation against graph model '" + ((GraphOutputData)this.data).graphModel.getName() + "' was successful.");
            }
        }
        catch (HopException e) {
            this.log.logError("Could not find Neo4j connection'" + ((GraphOutputMeta)this.meta).getConnectionName() + "'", (Throwable)e);
            return false;
        }
        ((GraphOutputData)this.data).nodeCount = this.countDistinctNodes(((GraphOutputMeta)this.meta).getFieldModelMappings());
        return super.init();
    }

    private List<NodeProperty> findUsedNodeProperties() {
        ArrayList<NodeProperty> list = new ArrayList<NodeProperty>();
        for (FieldModelMapping fieldModelMapping : ((GraphOutputMeta)this.meta).getFieldModelMappings()) {
            if (fieldModelMapping.getTargetType() != ModelTargetType.Node) continue;
            list.add(new NodeProperty(fieldModelMapping.getTargetName(), fieldModelMapping.getTargetProperty()));
        }
        return list;
    }

    private int countDistinctNodes(List<FieldModelMapping> fieldModelMappings) {
        ArrayList<String> nodes = new ArrayList<String>();
        for (FieldModelMapping mapping : fieldModelMappings) {
            if (nodes.contains(mapping.getTargetName())) continue;
            nodes.add(mapping.getTargetName());
        }
        return nodes.size();
    }

    @Override
    public void dispose() {
        this.wrapUpTransaction();
        if (((GraphOutputData)this.data).session != null) {
            ((GraphOutputData)this.data).session.close();
        }
        if (((GraphOutputData)this.data).driver != null) {
            ((GraphOutputData)this.data).driver.close();
        }
        if (((GraphOutputData)this.data).cypherMap != null) {
            ((GraphOutputData)this.data).cypherMap.clear();
        }
        super.dispose();
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.wrapUpTransaction();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((GraphOutputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((GraphOutputMeta)this.meta).getFields(((GraphOutputData)this.data).outputRowMeta, this.getTransformName(), null, this.getTransformMeta(), (IVariables)this, this.metadataProvider);
            ((GraphOutputData)this.data).fieldIndexes = new int[((GraphOutputMeta)this.meta).getFieldModelMappings().size()];
            for (int i = 0; i < ((GraphOutputMeta)this.meta).getFieldModelMappings().size(); ++i) {
                String field = ((GraphOutputMeta)this.meta).getFieldModelMappings().get(i).getField();
                ((GraphOutputData)this.data).fieldIndexes[i] = this.getInputRowMeta().indexOfValue(field);
                if (((GraphOutputData)this.data).fieldIndexes[i] >= 0) continue;
                throw new HopException("Unable to find parameter field '" + field);
            }
            ((GraphOutputData)this.data).relationshipPropertyIndexMap = new HashMap();
            for (FieldModelMapping mapping : ((GraphOutputMeta)this.meta).getFieldModelMappings()) {
                if (!mapping.getTargetType().equals((Object)ModelTargetType.Relationship)) continue;
                String relationshipName = mapping.getTargetName();
                GraphRelationship relationship = ((GraphOutputData)this.data).graphModel.findRelationship(relationshipName);
                if (relationship == null) {
                    throw new HopException("Unable to find relationship '" + relationshipName + "' in the graph model");
                }
                String propertyName = mapping.getTargetProperty();
                GraphProperty graphProperty = relationship.findProperty(propertyName);
                if (graphProperty == null) {
                    throw new HopException("Unable to find relationship property '" + relationshipName + "." + propertyName + "' in the graph model");
                }
                String fieldName = mapping.getField();
                int fieldIndex = this.getInputRowMeta().indexOfValue(fieldName);
                if (fieldIndex < 0) {
                    throw new HopException("Unable to find field to map to relationship property: " + relationshipName + "." + propertyName);
                }
                Map<GraphProperty, Integer> propertyIndexMap = ((GraphOutputData)this.data).relationshipPropertyIndexMap.get(relationshipName);
                if (propertyIndexMap == null) {
                    propertyIndexMap = new HashMap<GraphProperty, Integer>();
                    ((GraphOutputData)this.data).relationshipPropertyIndexMap.put(relationshipName, propertyIndexMap);
                }
                propertyIndexMap.put(graphProperty, fieldIndex);
            }
            if (!((GraphOutputMeta)this.meta).isReturningGraph() && ((GraphOutputMeta)this.meta).isCreatingIndexes()) {
                this.createNodePropertyIndexes((GraphOutputMeta)this.meta, (GraphOutputData)this.data);
            }
            ((GraphOutputData)this.data).cypherMap = new HashMap<String, CypherParameters>();
        }
        if (((GraphOutputMeta)this.meta).isReturningGraph()) {
            GraphData graphData = this.getGraphData(((GraphOutputData)this.data).graphModel, ((GraphOutputMeta)this.meta).getFieldModelMappings(), ((GraphOutputData)this.data).nodeCount, row, this.getInputRowMeta(), ((GraphOutputData)this.data).fieldIndexes);
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])row, (int)((GraphOutputData)this.data).outputRowMeta.size());
            outputRowData[this.getInputRowMeta().size()] = graphData;
            this.putRow(((GraphOutputData)this.data).outputRowMeta, outputRowData);
        } else {
            boolean errors;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            String cypher = this.getCypher(((GraphOutputData)this.data).graphModel, ((GraphOutputMeta)this.meta).getFieldModelMappings(), ((GraphOutputData)this.data).nodeCount, row, this.getInputRowMeta(), ((GraphOutputData)this.data).fieldIndexes, parameters);
            if (this.log.isDebug()) {
                this.logDebug("Parameters found : " + parameters.size());
                this.logDebug("Merge statement : " + cypher);
            }
            if (errors = this.executeStatement((GraphOutputData)this.data, cypher, parameters)) {
                this.setErrors(1L);
                this.setOutputDone();
                return false;
            }
            this.putRow(this.getInputRowMeta(), row);
        }
        return true;
    }

    private void createNodePropertyIndexes(GraphOutputMeta meta, GraphOutputData data) throws HopException {
        if (this.getCopy() > 0) {
            return;
        }
        HashMap<GraphNode, ArrayList<String>> nodePropertiesMap = new HashMap<GraphNode, ArrayList<String>>();
        for (int f = 0; f < meta.getFieldModelMappings().size(); ++f) {
            FieldModelMapping fieldModelMapping = meta.getFieldModelMappings().get(f);
            if (fieldModelMapping.getTargetType() != ModelTargetType.Node) continue;
            int index = data.fieldIndexes[f];
            GraphNode node = data.graphModel.findNode(fieldModelMapping.getTargetName());
            if (node == null) {
                throw new HopException("Unable to find target node '" + fieldModelMapping.getTargetName() + "'");
            }
            GraphProperty graphProperty = node.findProperty(fieldModelMapping.getTargetProperty());
            if (graphProperty == null) {
                throw new HopException("Unable to find target property '" + fieldModelMapping.getTargetProperty() + "' of node '" + fieldModelMapping.getTargetName() + "'");
            }
            if (!graphProperty.isPrimary()) continue;
            ArrayList<String> propertiesList = (ArrayList<String>)nodePropertiesMap.get(node);
            if (propertiesList == null) {
                propertiesList = new ArrayList<String>();
                nodePropertiesMap.put(node, propertiesList);
            }
            propertiesList.add(graphProperty.getName());
        }
        for (GraphNode node : nodePropertiesMap.keySet()) {
            NeoConnectionUtils.createNodeIndex(this.log, data.session, node.getLabels(), (List)nodePropertiesMap.get(node));
        }
    }

    private boolean executeStatement(GraphOutputData data, String cypher, Map<String, Object> parameters) {
        boolean errors = false;
        if (data.batchSize <= 1L) {
            Result result = data.session.run(cypher, parameters);
            errors = this.processSummary(result);
        } else if (((GraphOutputMeta)this.meta).isOutOfOrderAllowed()) {
            if (data.unwindCount == 0) {
                data.unwindMapList = new HashMap<String, List<Map<String, Object>>>();
            }
            List unwindList = data.unwindMapList.computeIfAbsent(cypher, k -> new ArrayList());
            unwindList.add(parameters);
            ++data.unwindCount;
            if ((long)data.unwindCount >= data.batchSize) {
                errors = this.emptyUnwindMap();
            }
        } else {
            if (data.outputCount == 0L) {
                data.transaction = data.session.beginTransaction();
            }
            Result result = data.transaction.run(cypher, parameters);
            errors = this.processSummary(result);
            ++data.outputCount;
            this.incrementLinesOutput();
            if (!errors && data.outputCount >= data.batchSize) {
                data.transaction.commit();
                data.transaction.close();
                data.outputCount = 0L;
            }
        }
        if (errors) {
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
        }
        return errors;
    }

    private boolean emptyUnwindMap() {
        List<Map<String, Object>> unwindList;
        Map<String, List<Map<String, Object>>> props;
        String unwindCypher;
        Result result;
        if (((GraphOutputData)this.data).unwindCount == 0 || ((GraphOutputData)this.data).unwindMapList == null || ((GraphOutputData)this.data).unwindMapList.isEmpty()) {
            return false;
        }
        boolean errors = false;
        Iterator<String> iterator = ((GraphOutputData)this.data).unwindMapList.keySet().iterator();
        while (iterator.hasNext() && !(errors = this.processSummary(result = (Result)((GraphOutputData)this.data).session.writeTransaction(arg_0 -> GraphOutput.lambda$emptyUnwindMap$1(unwindCypher = iterator.next(), props = Collections.singletonMap("props", unwindList = ((GraphOutputData)this.data).unwindMapList.get(unwindCypher)), arg_0))))) {
            this.setLinesOutput(this.getLinesOutput() + (long)unwindList.size());
        }
        ((GraphOutputData)this.data).unwindCount = 0;
        ((GraphOutputData)this.data).unwindMapList.clear();
        return errors;
    }

    private boolean processSummary(Result result) {
        boolean errors = false;
        ResultSummary summary = result.consume();
        for (Notification notification : summary.notifications()) {
            this.log.logError(notification.title() + " (" + notification.severity() + ")");
            this.log.logError(notification.code() + " : " + notification.description() + ", position " + notification.position());
            errors = true;
        }
        return errors;
    }

    protected String getCypher(GraphModel graphModel, List<FieldModelMapping> fieldModelMappings, int nodeCount, Object[] row, IRowMeta rowMeta, int[] fieldIndexes, Map<String, Object> parameters) throws HopException {
        StringBuffer pattern = new StringBuffer();
        for (int index : ((GraphOutputData)this.data).fieldIndexes) {
            boolean isNull = rowMeta.isNull(row, index);
            pattern.append(isNull ? (char)'0' : '1');
        }
        CypherParameters cypherParameters = ((GraphOutputData)this.data).cypherMap.get(pattern.toString());
        if (cypherParameters != null) {
            this.setParameters(rowMeta, row, parameters, cypherParameters);
            return cypherParameters.getCypher();
        }
        cypherParameters = new CypherParameters();
        ArrayList<GraphNode> nodes = new ArrayList<GraphNode>();
        ArrayList<NodeAndPropertyData> nodeProperties = new ArrayList<NodeAndPropertyData>();
        for (int f = 0; f < fieldModelMappings.size(); ++f) {
            FieldModelMapping fieldModelMapping = fieldModelMappings.get(f);
            if (fieldModelMapping.getTargetType() != ModelTargetType.Node) continue;
            int index = fieldIndexes[f];
            IValueMeta valueMeta = rowMeta.getValueMeta(index);
            Object valueData = row[index];
            GraphNode node = graphModel.findNode(fieldModelMapping.getTargetName());
            if (node == null) {
                throw new HopException("Unable to find target node '" + fieldModelMapping.getTargetName() + "'");
            }
            GraphProperty graphProperty = node.findProperty(fieldModelMapping.getTargetProperty());
            if (graphProperty == null) {
                throw new HopException("Unable to find target property '" + fieldModelMapping.getTargetProperty() + "' of node '" + fieldModelMapping.getTargetName() + "'");
            }
            if (!nodes.contains(node)) {
                nodes.add(node);
            }
            nodeProperties.add(new NodeAndPropertyData(node, graphProperty, valueMeta, valueData, index));
        }
        HashSet<GraphNode> ignored = new HashSet<GraphNode>();
        for (NodeAndPropertyData nodeProperty : nodeProperties) {
            if (!nodeProperty.property.isPrimary() || !nodeProperty.sourceValueMeta.isNull(nodeProperty.sourceValueData)) continue;
            if (this.log.isDebug()) {
                this.logDebug("Detected primary null property for node " + nodeProperty.node + " property " + nodeProperty.property + " value : " + nodeProperty.sourceValueMeta.getString(nodeProperty.sourceValueData));
            }
            if (ignored.contains(nodeProperty.node)) continue;
            ignored.add(nodeProperty.node);
        }
        ArrayList<GraphRelationship> relationships = new ArrayList<GraphRelationship>();
        for (int x = 0; x < nodes.size(); ++x) {
            for (int y = 0; y < nodes.size(); ++y) {
                if (x == y) continue;
                GraphNode sourceNode = (GraphNode)nodes.get(x);
                GraphNode targetNode = (GraphNode)nodes.get(y);
                GraphRelationship relationship = graphModel.findRelationship(sourceNode.getName(), targetNode.getName());
                if (relationship == null || relationships.contains(relationship)) continue;
                relationships.add(relationship);
            }
        }
        if (this.log.isDebug()) {
            this.logDebug("Found " + relationships.size() + " relationships to consider : " + ((Object)relationships).toString());
            this.logDebug("Found " + ignored.size() + " nodes to ignore : " + ((Object)ignored).toString());
        }
        int relationshipIndex = 0;
        AtomicInteger parameterIndex = new AtomicInteger(0);
        AtomicInteger nodeIndex = new AtomicInteger(0);
        StringBuilder cypher = new StringBuilder();
        HashSet<GraphNode> handled = new HashSet<GraphNode>();
        HashMap<GraphNode, Integer> nodeIndexMap = new HashMap<GraphNode, Integer>();
        if (((GraphOutputMeta)this.meta).isOutOfOrderAllowed()) {
            cypher.append("UNWIND $props AS pr ");
            cypher.append(Const.CR);
        }
        if (nodes.size() == 1) {
            GraphNode node = (GraphNode)nodes.get(0);
            this.addNodeCypher(cypher, node, handled, ignored, parameterIndex, nodeIndex, nodeIndexMap, nodeProperties, parameters, cypherParameters);
        } else {
            for (GraphRelationship relationship : relationships) {
                ++relationshipIndex;
                if (this.log.isDebug()) {
                    this.logDebug("Handling relationship : " + relationship.getName());
                }
                GraphNode nodeSource = graphModel.findNode(relationship.getNodeSource());
                GraphNode nodeTarget = graphModel.findNode(relationship.getNodeTarget());
                for (GraphNode node : new GraphNode[]{nodeSource, nodeTarget}) {
                    this.addNodeCypher(cypher, node, handled, ignored, parameterIndex, nodeIndex, nodeIndexMap, nodeProperties, parameters, cypherParameters);
                }
                if (nodeIndexMap.get(nodeSource) == null || nodeIndexMap.get(nodeTarget) == null) continue;
                String sourceNodeName = "node" + nodeIndexMap.get(nodeSource);
                String targetNodeName = "node" + nodeIndexMap.get(nodeTarget);
                String relationshipAlias = "rel" + relationshipIndex;
                cypher.append("MERGE(" + sourceNodeName + ")-[" + relationshipAlias + ":" + relationship.getLabel() + "]-(" + targetNodeName + ") ");
                cypher.append(Const.CR);
                ArrayList<GraphProperty> relProps = new ArrayList<GraphProperty>();
                ArrayList<Integer> relPropIndexes = new ArrayList<Integer>();
                Map<GraphProperty, Integer> propertyIndexMap = ((GraphOutputData)this.data).relationshipPropertyIndexMap.get(relationship.getName());
                if (propertyIndexMap != null) {
                    for (GraphProperty relProp : propertyIndexMap.keySet()) {
                        Integer relFieldIndex = propertyIndexMap.get(relProp);
                        if (relFieldIndex == null) continue;
                        relProps.add(relProp);
                        relPropIndexes.add(relFieldIndex);
                    }
                }
                if (!relProps.isEmpty()) {
                    cypher.append("SET ");
                    for (int i = 0; i < relProps.size(); ++i) {
                        parameterIndex.incrementAndGet();
                        String parameterName = "param" + parameterIndex;
                        if (i > 0) {
                            cypher.append(", ");
                        }
                        GraphProperty relProp = (GraphProperty)relProps.get(i);
                        int propFieldIndex = (Integer)relPropIndexes.get(i);
                        IValueMeta sourceFieldMeta = rowMeta.getValueMeta(propFieldIndex);
                        Object sourceFieldValue = row[propFieldIndex];
                        boolean isNull = sourceFieldMeta.isNull(sourceFieldValue);
                        cypher.append(relationshipAlias + "." + relProp.getName());
                        cypher.append(" = ");
                        if (isNull) {
                            cypher.append("NULL");
                            continue;
                        }
                        Object neoValue = relProp.getType().convertFromHop(sourceFieldMeta, sourceFieldValue);
                        parameters.put(parameterName, neoValue);
                        cypher.append(this.buildParameterClause(parameterName));
                        TargetParameter targetParameter = new TargetParameter(sourceFieldMeta.getName(), propFieldIndex, parameterName, relProp.getType());
                        cypherParameters.getTargetParameters().add(targetParameter);
                    }
                    cypher.append(Const.CR);
                }
                this.updateUsageMap(Arrays.asList(relationship.getLabel()), GraphUsage.RELATIONSHIP_UPDATE);
            }
            cypher.append(";" + Const.CR);
        }
        cypherParameters.setCypher(cypher.toString());
        ((GraphOutputData)this.data).cypherMap.put(pattern.toString(), cypherParameters);
        return cypher.toString();
    }

    private void setParameters(IRowMeta rowMeta, Object[] row, Map<String, Object> parameters, CypherParameters cypherParameters) throws HopValueException {
        for (TargetParameter targetParameter : cypherParameters.getTargetParameters()) {
            int fieldIndex = targetParameter.getInputFieldIndex();
            IValueMeta valueMeta = rowMeta.getValueMeta(fieldIndex);
            Object valueData = row[fieldIndex];
            String parameterName = targetParameter.getParameterName();
            GraphPropertyType parameterType = targetParameter.getParameterType();
            Object neoObject = parameterType.convertFromHop(valueMeta, valueData);
            parameters.put(parameterName, neoObject);
        }
    }

    private void addNodeCypher(StringBuilder cypher, GraphNode node, Set<GraphNode> handled, Set<GraphNode> ignored, AtomicInteger parameterIndex, AtomicInteger nodeIndex, Map<GraphNode, Integer> nodeIndexMap, List<NodeAndPropertyData> nodeProperties, Map<String, Object> parameters, CypherParameters cypherParameters) throws HopValueException {
        if (!ignored.contains(node) && !handled.contains(node)) {
            handled.add(node);
            nodeIndexMap.put(node, nodeIndex.incrementAndGet());
            String nodeLabels = "";
            for (String nodeLabel : node.getLabels()) {
                nodeLabels = nodeLabels + ":";
                nodeLabels = nodeLabels + nodeLabel;
            }
            StringBuilder matchCypher = new StringBuilder();
            String nodeAlias = "node" + nodeIndex;
            cypher.append("MERGE (" + nodeAlias + nodeLabels + " { ");
            this.updateUsageMap(node.getLabels(), GraphUsage.NODE_UPDATE);
            if (this.log.isDebug()) {
                this.logBasic(" - node merge : " + node.getName());
            }
            boolean firstPrimary = true;
            boolean firstMatch = true;
            for (NodeAndPropertyData napd : nodeProperties) {
                if (!napd.node.equals(node)) continue;
                parameterIndex.incrementAndGet();
                boolean isNull = napd.sourceValueMeta.isNull(napd.sourceValueData);
                String parameterName = "param" + parameterIndex;
                if (napd.property.isPrimary()) {
                    if (!firstPrimary) {
                        cypher.append(", ");
                    }
                    cypher.append(napd.property.getName() + " : " + this.buildParameterClause(parameterName) + " ");
                    firstPrimary = false;
                    if (this.log.isDebug()) {
                        this.logBasic("   * property match/create : " + napd.property.getName() + " with value " + napd.sourceValueMeta.toStringMeta() + " : " + napd.sourceValueMeta.getString(napd.sourceValueData));
                    }
                } else {
                    if (firstMatch) {
                        matchCypher.append("SET ");
                    } else {
                        matchCypher.append(", ");
                    }
                    firstMatch = false;
                    matchCypher.append(nodeAlias + "." + napd.property.getName() + " = ");
                    if (isNull) {
                        matchCypher.append("NULL ");
                    } else {
                        matchCypher.append(this.buildParameterClause(parameterName) + " ");
                    }
                    if (this.log.isDebug()) {
                        this.logBasic("   * property update : " + napd.property.getName() + " with value " + napd.sourceValueMeta.toStringMeta() + " : " + napd.sourceValueMeta.getString(napd.sourceValueData));
                    }
                }
                if (isNull) continue;
                parameters.put(parameterName, napd.property.getType().convertFromHop(napd.sourceValueMeta, napd.sourceValueData));
                TargetParameter targetParameter = new TargetParameter(napd.sourceValueMeta.getName(), napd.sourceFieldIndex, parameterName, napd.property.getType());
                cypherParameters.getTargetParameters().add(targetParameter);
            }
            cypher.append("}) " + Const.CR);
            if (matchCypher.length() > 0) {
                cypher.append((CharSequence)matchCypher);
            }
        }
    }

    private String buildParameterClause(String parameterName) {
        if (((GraphOutputMeta)this.meta).isOutOfOrderAllowed()) {
            return "pr." + parameterName;
        }
        return "$" + parameterName;
    }

    public void batchComplete() {
        this.wrapUpTransaction();
    }

    private void wrapUpTransaction() {
        if (((GraphOutputMeta)this.meta).isOutOfOrderAllowed()) {
            boolean errors = this.emptyUnwindMap();
            if (errors) {
                this.stopAll();
                this.setErrors(1L);
            }
        } else if (((GraphOutputData)this.data).outputCount > 0L) {
            ((GraphOutputData)this.data).transaction.commit();
            ((GraphOutputData)this.data).transaction.close();
            ((GraphOutputData)this.data).outputCount = 0L;
        }
    }

    protected void updateUsageMap(List<String> nodeLabels, GraphUsage usage) throws HopValueException {
        HashSet<String> labelSet;
        HashMap transformsMap = (HashMap)((GraphOutputData)this.data).usageMap.get(usage.name());
        if (transformsMap == null) {
            transformsMap = new HashMap();
            ((GraphOutputData)this.data).usageMap.put(usage.name(), transformsMap);
        }
        if ((labelSet = (HashSet<String>)transformsMap.get(this.getTransformName())) == null) {
            labelSet = new HashSet<String>();
            transformsMap.put(this.getTransformName(), labelSet);
        }
        for (String label : nodeLabels) {
            if (!StringUtils.isNotEmpty((String)label)) continue;
            labelSet.add(label);
        }
    }

    protected GraphData getGraphData(GraphModel graphModel, List<FieldModelMapping> fieldModelMappings, int nodeCount, Object[] row, IRowMeta rowMeta, int[] fieldIndexes) throws HopException {
        GraphRelationship relationship2;
        GraphData graphData = new GraphData();
        graphData.setSourcePipelineName(this.getPipelineMeta().getName());
        graphData.setSourceTransformName(this.getTransformMeta().getName());
        ArrayList<GraphNode> nodes = new ArrayList<GraphNode>();
        ArrayList<GraphRelationship> relationships = new ArrayList<GraphRelationship>();
        ArrayList<NodeAndPropertyData> nodeProperties = new ArrayList<NodeAndPropertyData>();
        ArrayList<RelationshipAndPropertyData> relationshipProperties = new ArrayList<RelationshipAndPropertyData>();
        for (int f = 0; f < fieldModelMappings.size(); ++f) {
            GraphProperty graphProperty;
            FieldModelMapping fieldModelMapping = fieldModelMappings.get(f);
            int index = fieldIndexes[f];
            IValueMeta valueMeta = rowMeta.getValueMeta(index);
            Object valueData = row[index];
            if (fieldModelMapping.getTargetType() == ModelTargetType.Node) {
                GraphNode node = graphModel.findNode(fieldModelMapping.getTargetName());
                if (node == null) {
                    throw new HopException("Unable to find target node '" + fieldModelMapping.getTargetName() + "'");
                }
                graphProperty = node.findProperty(fieldModelMapping.getTargetProperty());
                if (graphProperty == null) {
                    throw new HopException("Unable to find target property '" + fieldModelMapping.getTargetProperty() + "' of node '" + fieldModelMapping.getTargetName() + "'");
                }
                if (!nodes.contains(node)) {
                    nodes.add(node);
                }
                nodeProperties.add(new NodeAndPropertyData(node, graphProperty, valueMeta, valueData, index));
                continue;
            }
            relationship2 = graphModel.findRelationship(fieldModelMapping.getTargetName());
            if (relationship2 == null) {
                throw new HopException("Unable to find target relationship '" + fieldModelMapping.getTargetName() + "'");
            }
            graphProperty = relationship2.findProperty(fieldModelMapping.getTargetProperty());
            if (graphProperty == null) {
                throw new HopException("Unable to find target property '" + fieldModelMapping.getTargetProperty() + "' of relationship '" + fieldModelMapping.getTargetName() + "'");
            }
            if (!relationships.contains(relationship2)) {
                relationships.add(relationship2);
            }
            relationshipProperties.add(new RelationshipAndPropertyData(relationship2, graphProperty, valueMeta, valueData, index));
        }
        HashSet<GraphNode> ignored = new HashSet<GraphNode>();
        for (NodeAndPropertyData nodeProperty : nodeProperties) {
            if (!nodeProperty.property.isPrimary() || !nodeProperty.sourceValueMeta.isNull(nodeProperty.sourceValueData)) continue;
            if (this.log.isDebug()) {
                this.logDebug("Detected primary null property for node " + nodeProperty.node + " property " + nodeProperty.property + " value : " + nodeProperty.sourceValueMeta.getString(nodeProperty.sourceValueData));
            }
            if (ignored.contains(nodeProperty.node)) continue;
            ignored.add(nodeProperty.node);
        }
        for (int x = 0; x < nodes.size(); ++x) {
            for (int y = 0; y < nodes.size(); ++y) {
                if (x == y) continue;
                GraphNode sourceNode = (GraphNode)nodes.get(x);
                GraphNode targetNode = (GraphNode)nodes.get(y);
                relationship2 = graphModel.findRelationship(sourceNode.getName(), targetNode.getName());
                if (relationship2 == null || relationships.contains(relationship2)) continue;
                relationships.add(relationship2);
            }
        }
        AtomicInteger nodeIndex = new AtomicInteger(0);
        HashSet<GraphNode> handled = new HashSet<GraphNode>();
        HashMap<GraphNode, Integer> nodeIndexMap = new HashMap<GraphNode, Integer>();
        if (nodes.size() == 1) {
            GraphNode node = (GraphNode)nodes.get(0);
            GraphNodeData nodeData = this.getGraphNodeData(node, handled, ignored, nodeIndex, nodeIndexMap, nodeProperties);
            if (nodeData != null) {
                graphData.getNodes().add(nodeData);
            }
        } else {
            for (GraphRelationship relationship2 : relationships) {
                GraphNode nodeSource = graphModel.findNode(relationship2.getNodeSource());
                GraphNode nodeTarget = graphModel.findNode(relationship2.getNodeTarget());
                for (GraphNode node : new GraphNode[]{nodeSource, nodeTarget}) {
                    GraphNodeData nodeData = this.getGraphNodeData(node, handled, ignored, nodeIndex, nodeIndexMap, nodeProperties);
                    if (nodeData == null) continue;
                    graphData.getNodes().add(nodeData);
                }
                if (nodeIndexMap.get(nodeSource) == null || nodeIndexMap.get(nodeTarget) == null) continue;
                String sourceNodeId = this.getGraphNodeDataId(nodeSource, nodeProperties);
                String targetNodeId = this.getGraphNodeDataId(nodeTarget, nodeProperties);
                String id = sourceNodeId + " -> " + targetNodeId;
                GraphRelationshipData relationshipData = new GraphRelationshipData();
                relationshipData.setId(id);
                relationshipData.setLabel(relationship2.getLabel());
                relationshipData.setSourceNodeId(sourceNodeId);
                relationshipData.setTargetNodeId(targetNodeId);
                relationshipData.setPropertySetId(relationship2.getName());
                ArrayList<GraphProperty> relProps = new ArrayList<GraphProperty>();
                ArrayList<Integer> relPropIndexes = new ArrayList<Integer>();
                Map<GraphProperty, Integer> propertyIndexMap = ((GraphOutputData)this.data).relationshipPropertyIndexMap.get(relationship2.getName());
                if (propertyIndexMap != null) {
                    for (GraphProperty relProp : propertyIndexMap.keySet()) {
                        Integer relFieldIndex = propertyIndexMap.get(relProp);
                        if (relFieldIndex == null) continue;
                        relProps.add(relProp);
                        relPropIndexes.add(relFieldIndex);
                    }
                }
                if (!relProps.isEmpty()) {
                    for (int i = 0; i < relProps.size(); ++i) {
                        GraphProperty relProp;
                        relProp = (GraphProperty)relProps.get(i);
                        int propFieldIndex = (Integer)relPropIndexes.get(i);
                        IValueMeta sourceFieldMeta = rowMeta.getValueMeta(propFieldIndex);
                        Object sourceFieldValue = row[propFieldIndex];
                        String propId = relProp.getName();
                        GraphPropertyDataType relPropType = GraphPropertyDataType.getTypeFromHop(sourceFieldMeta);
                        Object neoValue = relPropType.convertFromHop(sourceFieldMeta, sourceFieldValue);
                        boolean primary = false;
                        relationshipData.getProperties().add(new GraphPropertyData(propId, neoValue, relPropType, primary));
                    }
                }
                graphData.getRelationships().add(relationshipData);
            }
        }
        return graphData;
    }

    private GraphNodeData getGraphNodeData(GraphNode node, Set<GraphNode> handled, Set<GraphNode> ignored, AtomicInteger nodeIndex, Map<GraphNode, Integer> nodeIndexMap, List<NodeAndPropertyData> nodeProperties) throws HopValueException {
        if (!ignored.contains(node) && !handled.contains(node)) {
            GraphNodeData graphNodeData = new GraphNodeData();
            graphNodeData.setPropertySetId(node.getName());
            handled.add(node);
            nodeIndexMap.put(node, nodeIndex.incrementAndGet());
            graphNodeData.getLabels().addAll(node.getLabels());
            boolean firstPrimary = true;
            boolean firstMatch = true;
            for (NodeAndPropertyData napd : nodeProperties) {
                if (!napd.node.equals(node)) continue;
                boolean isNull = napd.sourceValueMeta.isNull(napd.sourceValueData);
                if (napd.property.isPrimary()) {
                    String oldId = graphNodeData.getId();
                    String propertyString = napd.sourceValueMeta.getString(napd.sourceValueData);
                    if (oldId == null) {
                        graphNodeData.setId(propertyString);
                    } else {
                        graphNodeData.setId(oldId + "-" + propertyString);
                    }
                }
                if (isNull) continue;
                GraphPropertyData propertyData = new GraphPropertyData();
                propertyData.setId(napd.property.getName());
                GraphPropertyDataType type = GraphPropertyDataType.getTypeFromHop(napd.sourceValueMeta);
                propertyData.setType(type);
                propertyData.setValue(type.convertFromHop(napd.sourceValueMeta, napd.sourceValueData));
                propertyData.setPrimary(napd.property.isPrimary());
                graphNodeData.getProperties().add(propertyData);
            }
            return graphNodeData;
        }
        return null;
    }

    public String getGraphNodeDataId(GraphNode node, List<NodeAndPropertyData> nodeProperties) throws HopValueException {
        StringBuffer id = new StringBuffer();
        for (NodeAndPropertyData napd : nodeProperties) {
            if (!napd.node.equals(node) || !napd.property.isPrimary()) continue;
            String propertyString = napd.sourceValueMeta.getString(napd.sourceValueData);
            if (id.length() > 0) {
                id.append("-");
            }
            id.append(propertyString);
        }
        return id.toString();
    }

    private static /* synthetic */ Result lambda$emptyUnwindMap$1(String unwindCypher, Map props, Transaction tx) {
        return tx.run(unwindCypher, props);
    }

    private static class RelationshipAndPropertyData {
        public GraphRelationship relationship;
        public GraphProperty property;
        public IValueMeta sourceValueMeta;
        public Object sourceValueData;
        public int sourceFieldIndex;

        public RelationshipAndPropertyData(GraphRelationship relationship, GraphProperty property, IValueMeta sourceValueMeta, Object sourceValueData, int sourceFieldIndex) {
            this.relationship = relationship;
            this.property = property;
            this.sourceValueMeta = sourceValueMeta;
            this.sourceValueData = sourceValueData;
            this.sourceFieldIndex = sourceFieldIndex;
        }
    }

    private static class NodeAndPropertyData {
        public GraphNode node;
        public GraphProperty property;
        public IValueMeta sourceValueMeta;
        public Object sourceValueData;
        public int sourceFieldIndex;

        public NodeAndPropertyData(GraphNode node, GraphProperty property, IValueMeta sourceValueMeta, Object sourceValueData, int sourceFieldIndex) {
            this.node = node;
            this.property = property;
            this.sourceValueMeta = sourceValueMeta;
            this.sourceValueData = sourceValueData;
            this.sourceFieldIndex = sourceFieldIndex;
        }
    }
}

