/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.gencsv;

import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.transforms.gencsv.GenerateCsv;
import org.apache.hop.neo4j.transforms.gencsv.GenerateCsvData;
import org.apache.hop.neo4j.transforms.gencsv.UniquenessStrategy;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.w3c.dom.Node;

@Transform(id="Neo4jLoad", name="Neo4j Generate CSVs", description="Generate CSV files for nodes and relationships in the import/ folder for use with neo4j-import", image="neo4j_load.svg", categoryDescription="Neo4j", documentationUrl="/pipeline/transforms/generate-csvs.html")
public class GenerateCsvMeta
extends BaseTransformMeta
implements ITransformMeta<GenerateCsv, GenerateCsvData> {
    public static final String GRAPH_FIELD_NAME = "graph_field_name";
    public static final String BASE_FOLDER = "base_folder";
    public static final String UNIQUENESS_STRATEGY = "uniqueness_strategy";
    public static final String FILES_PREFIX = "files_prefix";
    public static final String FILENAME_FIELD = "filename_field";
    public static final String FILE_TYPE_FIELD = "file_type_field";
    protected String graphFieldName;
    protected String baseFolder;
    protected UniquenessStrategy uniquenessStrategy;
    protected String filesPrefix;
    protected String filenameField;
    protected String fileTypeField;

    public void setDefault() {
        this.baseFolder = "/var/lib/neo4j/";
        this.uniquenessStrategy = UniquenessStrategy.None;
        this.filesPrefix = "prefix";
        this.filenameField = "filename";
        this.fileTypeField = "fileType";
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextStep, IVariables space, IHopMetadataProvider metadataProvider) {
        inputRowMeta.clear();
        ValueMetaString filenameValueMeta = new ValueMetaString(space.resolve(this.filenameField));
        filenameValueMeta.setOrigin(name);
        inputRowMeta.addValueMeta((IValueMeta)filenameValueMeta);
        ValueMetaString fileTypeValueMeta = new ValueMetaString(space.resolve(this.fileTypeField));
        fileTypeValueMeta.setOrigin(name);
        inputRowMeta.addValueMeta((IValueMeta)fileTypeValueMeta);
    }

    public String getXml() throws HopException {
        StringBuffer xml = new StringBuffer();
        xml.append(XmlHandler.addTagValue((String)GRAPH_FIELD_NAME, (String)this.graphFieldName));
        xml.append(XmlHandler.addTagValue((String)BASE_FOLDER, (String)this.baseFolder));
        xml.append(XmlHandler.addTagValue((String)UNIQUENESS_STRATEGY, this.uniquenessStrategy != null ? this.uniquenessStrategy.name() : null));
        xml.append(XmlHandler.addTagValue((String)FILES_PREFIX, (String)this.filesPrefix));
        xml.append(XmlHandler.addTagValue((String)FILENAME_FIELD, (String)this.filenameField));
        xml.append(XmlHandler.addTagValue((String)FILE_TYPE_FIELD, (String)this.fileTypeField));
        return xml.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.graphFieldName = XmlHandler.getTagValue((Node)transformNode, (String)GRAPH_FIELD_NAME);
        this.baseFolder = XmlHandler.getTagValue((Node)transformNode, (String)BASE_FOLDER);
        this.uniquenessStrategy = UniquenessStrategy.getStrategyFromName(XmlHandler.getTagValue((Node)transformNode, (String)UNIQUENESS_STRATEGY));
        this.filesPrefix = XmlHandler.getTagValue((Node)transformNode, (String)FILES_PREFIX);
        this.filenameField = XmlHandler.getTagValue((Node)transformNode, (String)FILENAME_FIELD);
        this.fileTypeField = XmlHandler.getTagValue((Node)transformNode, (String)FILE_TYPE_FIELD);
    }

    public GenerateCsv createTransform(TransformMeta transformMeta, GenerateCsvData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new GenerateCsv(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public GenerateCsvData getTransformData() {
        return new GenerateCsvData();
    }

    public String getGraphFieldName() {
        return this.graphFieldName;
    }

    public void setGraphFieldName(String graphFieldName) {
        this.graphFieldName = graphFieldName;
    }

    public String getBaseFolder() {
        return this.baseFolder;
    }

    public void setBaseFolder(String baseFolder) {
        this.baseFolder = baseFolder;
    }

    public UniquenessStrategy getUniquenessStrategy() {
        return this.uniquenessStrategy;
    }

    public void setUniquenessStrategy(UniquenessStrategy uniquenessStrategy) {
        this.uniquenessStrategy = uniquenessStrategy;
    }

    public String getFilesPrefix() {
        return this.filesPrefix;
    }

    public void setFilesPrefix(String filesPrefix) {
        this.filesPrefix = filesPrefix;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public String getFileTypeField() {
        return this.fileTypeField;
    }

    public void setFileTypeField(String fileTypeField) {
        this.fileTypeField = fileTypeField;
    }
}

