/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypher;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.core.value.ValueMetaGraph;
import org.apache.hop.neo4j.model.GraphPropertyType;
import org.apache.hop.neo4j.transforms.cypher.Cypher;
import org.apache.hop.neo4j.transforms.cypher.CypherData;
import org.apache.hop.neo4j.transforms.cypher.CypherDialog;
import org.apache.hop.neo4j.transforms.cypher.ParameterMapping;
import org.apache.hop.neo4j.transforms.cypher.ReturnValue;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.w3c.dom.Node;

@Transform(id="Neo4jCypherOutput", name="Neo4j Cypher", description="Reads from or writes to Neo4j using Cypher with parameter data from input fields", image="neo4j_cypher.svg", categoryDescription="Neo4j", documentationUrl="/pipeline/transforms/neo4j-cypher.html")
@InjectionSupported(localizationPrefix="Cypher.Injection.", groups={"PARAMETERS", "RETURNS"})
public class CypherMeta
extends BaseTransformMeta
implements ITransformMeta<Cypher, CypherData> {
    public static final String CONNECTION = "connection";
    public static final String CYPHER = "cypher";
    public static final String BATCH_SIZE = "batch_size";
    public static final String READ_ONLY = "read_only";
    public static final String RETRY = "retry";
    public static final String NR_RETRIES_ON_ERROR = "nr_retries_on_error";
    public static final String CYPHER_FROM_FIELD = "cypher_from_field";
    public static final String CYPHER_FIELD = "cypher_field";
    public static final String UNWIND = "unwind";
    public static final String UNWIND_MAP = "unwind_map";
    public static final String RETURNING_GRAPH = "returning_graph";
    public static final String RETURN_GRAPH_FIELD = "return_graph_field";
    public static final String MAPPINGS = "mappings";
    public static final String MAPPING = "mapping";
    public static final String PARAMETERS = "parameters";
    public static final String PARAMETER = "parameter";
    public static final String FIELD = "field";
    public static final String TYPE = "type";
    public static final String SOURCE_TYPE = "source_type";
    public static final String RETURNS = "returns";
    public static final String RETURN = "return";
    public static final String NAME = "name";
    public static final String PARAMETER_NAME = "parameter_name";
    public static final String PARAMETER_FIELD = "parameter_field";
    public static final String PARAMETER_TYPE = "parameter_type";
    public static final String RETURN_NAME = "return_name";
    public static final String RETURN_TYPE = "return_type";
    public static final String RETURN_SOURCE_TYPE = "return_source_type";
    @Injection(name="connection")
    private String connectionName;
    @Injection(name="cypher")
    private String cypher;
    @Injection(name="batch_size")
    private String batchSize;
    @Injection(name="read_only")
    private boolean readOnly;
    @Injection(name="retry")
    private boolean retryingOnDisconnect;
    @Injection(name="nr_retries_on_error")
    private String nrRetriesOnError;
    @Injection(name="cypher_from_field")
    private boolean cypherFromField;
    @Injection(name="cypher_field")
    private String cypherField;
    @Injection(name="unwind")
    private boolean usingUnwind;
    @Injection(name="unwind_map")
    private String unwindMapName;
    @Injection(name="returning_graph")
    private boolean returningGraph;
    @Injection(name="return_graph_field")
    private String returnGraphField;
    @InjectionDeep
    private List<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
    @InjectionDeep
    private List<ReturnValue> returnValues = new ArrayList<ReturnValue>();

    public void setDefault() {
        this.retryingOnDisconnect = true;
    }

    public Cypher createTransform(TransformMeta transformMeta, CypherData iTransformData, int i, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new Cypher(transformMeta, this, iTransformData, i, pipelineMeta, pipeline);
    }

    public CypherData getTransformData() {
        return new CypherData();
    }

    public String getDialogClassName() {
        return CypherDialog.class.getName();
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextStep, IVariables space, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.usingUnwind) {
            rowMeta.clear();
        }
        if (this.returningGraph) {
            ValueMetaGraph valueMetaGraph = new ValueMetaGraph(Const.NVL((String)this.returnGraphField, (String)"graph"));
            valueMetaGraph.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)valueMetaGraph);
        } else {
            for (ReturnValue returnValue : this.returnValues) {
                try {
                    int type = ValueMetaFactory.getIdForValueMeta((String)returnValue.getType());
                    IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)returnValue.getName(), (int)type);
                    valueMeta.setOrigin(name);
                    rowMeta.addValueMeta(valueMeta);
                }
                catch (HopPluginException e) {
                    throw new HopTransformException("Unknown data type '" + returnValue.getType() + "' for value named '" + returnValue.getName() + "'");
                }
            }
        }
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.addTagValue((String)CONNECTION, (String)this.connectionName));
        xml.append(XmlHandler.addTagValue((String)CYPHER, (String)this.cypher));
        xml.append(XmlHandler.addTagValue((String)BATCH_SIZE, (String)this.batchSize));
        xml.append(XmlHandler.addTagValue((String)READ_ONLY, (boolean)this.readOnly));
        xml.append(XmlHandler.addTagValue((String)NR_RETRIES_ON_ERROR, (String)this.nrRetriesOnError));
        xml.append(XmlHandler.addTagValue((String)RETRY, (boolean)this.retryingOnDisconnect));
        xml.append(XmlHandler.addTagValue((String)CYPHER_FROM_FIELD, (boolean)this.cypherFromField));
        xml.append(XmlHandler.addTagValue((String)CYPHER_FIELD, (String)this.cypherField));
        xml.append(XmlHandler.addTagValue((String)UNWIND, (boolean)this.usingUnwind));
        xml.append(XmlHandler.addTagValue((String)UNWIND_MAP, (String)this.unwindMapName));
        xml.append(XmlHandler.addTagValue((String)RETURNING_GRAPH, (boolean)this.returningGraph));
        xml.append(XmlHandler.addTagValue((String)RETURN_GRAPH_FIELD, (String)this.returnGraphField));
        xml.append(XmlHandler.openTag((String)MAPPINGS));
        for (ParameterMapping parameterMapping : this.parameterMappings) {
            xml.append(XmlHandler.openTag((String)MAPPING));
            xml.append(XmlHandler.addTagValue((String)PARAMETER, (String)parameterMapping.getParameter()));
            xml.append(XmlHandler.addTagValue((String)FIELD, (String)parameterMapping.getField()));
            xml.append(XmlHandler.addTagValue((String)TYPE, (String)parameterMapping.getNeoType()));
            xml.append(XmlHandler.closeTag((String)MAPPING));
        }
        xml.append(XmlHandler.closeTag((String)MAPPINGS));
        xml.append(XmlHandler.openTag((String)RETURNS));
        for (ReturnValue returnValue : this.returnValues) {
            xml.append(XmlHandler.openTag((String)RETURN));
            xml.append(XmlHandler.addTagValue((String)NAME, (String)returnValue.getName()));
            xml.append(XmlHandler.addTagValue((String)TYPE, (String)returnValue.getType()));
            xml.append(XmlHandler.addTagValue((String)SOURCE_TYPE, (String)returnValue.getSourceType()));
            xml.append(XmlHandler.closeTag((String)RETURN));
        }
        xml.append(XmlHandler.closeTag((String)RETURNS));
        return xml.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.connectionName = XmlHandler.getTagValue((Node)transformNode, (String)CONNECTION);
        this.cypher = XmlHandler.getTagValue((Node)transformNode, (String)CYPHER);
        this.batchSize = XmlHandler.getTagValue((Node)transformNode, (String)BATCH_SIZE);
        this.readOnly = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)READ_ONLY));
        String retryString = XmlHandler.getTagValue((Node)transformNode, (String)RETRY);
        this.retryingOnDisconnect = StringUtils.isEmpty((String)retryString) || "Y".equalsIgnoreCase(retryString);
        this.nrRetriesOnError = XmlHandler.getTagValue((Node)transformNode, (String)NR_RETRIES_ON_ERROR);
        this.cypherFromField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)CYPHER_FROM_FIELD));
        this.cypherField = XmlHandler.getTagValue((Node)transformNode, (String)CYPHER_FIELD);
        this.usingUnwind = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)UNWIND));
        this.unwindMapName = XmlHandler.getTagValue((Node)transformNode, (String)UNWIND_MAP);
        this.returningGraph = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)RETURNING_GRAPH));
        this.returnGraphField = XmlHandler.getTagValue((Node)transformNode, (String)RETURN_GRAPH_FIELD);
        Node mappingsNode = XmlHandler.getSubNode((Node)transformNode, (String)MAPPINGS);
        List mappingNodes = XmlHandler.getNodes((Node)mappingsNode, (String)MAPPING);
        this.parameterMappings = new ArrayList<ParameterMapping>();
        for (Node mappingNode : mappingNodes) {
            String parameter = XmlHandler.getTagValue((Node)mappingNode, (String)PARAMETER);
            String field = XmlHandler.getTagValue((Node)mappingNode, (String)FIELD);
            String neoType = XmlHandler.getTagValue((Node)mappingNode, (String)TYPE);
            if (StringUtils.isEmpty((String)neoType)) {
                neoType = GraphPropertyType.String.name();
            }
            this.parameterMappings.add(new ParameterMapping(parameter, field, neoType));
        }
        Node returnsNode = XmlHandler.getSubNode((Node)transformNode, (String)RETURNS);
        List returnNodes = XmlHandler.getNodes((Node)returnsNode, (String)RETURN);
        this.returnValues = new ArrayList<ReturnValue>();
        for (Node returnNode : returnNodes) {
            String name = XmlHandler.getTagValue((Node)returnNode, (String)NAME);
            String type = XmlHandler.getTagValue((Node)returnNode, (String)TYPE);
            String sourceType = XmlHandler.getTagValue((Node)returnNode, (String)SOURCE_TYPE);
            this.returnValues.add(new ReturnValue(name, type, sourceType));
        }
        super.loadXml(transformNode, metadataProvider);
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getCypher() {
        return this.cypher;
    }

    public void setCypher(String cypher) {
        this.cypher = cypher;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isCypherFromField() {
        return this.cypherFromField;
    }

    public void setCypherFromField(boolean cypherFromField) {
        this.cypherFromField = cypherFromField;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isRetryingOnDisconnect() {
        return this.retryingOnDisconnect;
    }

    public void setRetryingOnDisconnect(boolean retryingOnDisconnect) {
        this.retryingOnDisconnect = retryingOnDisconnect;
    }

    public String getCypherField() {
        return this.cypherField;
    }

    public void setCypherField(String cypherField) {
        this.cypherField = cypherField;
    }

    public boolean isUsingUnwind() {
        return this.usingUnwind;
    }

    public void setUsingUnwind(boolean usingUnwind) {
        this.usingUnwind = usingUnwind;
    }

    public String getUnwindMapName() {
        return this.unwindMapName;
    }

    public boolean isReturningGraph() {
        return this.returningGraph;
    }

    public void setReturningGraph(boolean returningGraph) {
        this.returningGraph = returningGraph;
    }

    public void setUnwindMapName(String unwindMapName) {
        this.unwindMapName = unwindMapName;
    }

    public List<ParameterMapping> getParameterMappings() {
        return this.parameterMappings;
    }

    public void setParameterMappings(List<ParameterMapping> parameterMappings) {
        this.parameterMappings = parameterMappings;
    }

    public List<ReturnValue> getReturnValues() {
        return this.returnValues;
    }

    public void setReturnValues(List<ReturnValue> returnValues) {
        this.returnValues = returnValues;
    }

    public String getReturnGraphField() {
        return this.returnGraphField;
    }

    public void setReturnGraphField(String returnGraphField) {
        this.returnGraphField = returnGraphField;
    }

    public String getNrRetriesOnError() {
        return this.nrRetriesOnError;
    }

    public void setNrRetriesOnError(String nrRetriesOnError) {
        this.nrRetriesOnError = nrRetriesOnError;
    }
}

