/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.shared;

import java.util.List;
import org.apache.hop.core.logging.ILogChannel;
import org.neo4j.driver.Session;

public class NeoConnectionUtils {
    private static Class<?> PKG = NeoConnectionUtils.class;

    public static final void createNodeIndex(ILogChannel log, Session session, List<String> labels, List<String> keyProperties) {
        if (keyProperties.size() == 0) {
            return;
        }
        if (labels.size() == 0) {
            return;
        }
        String labelsClause = ":" + labels.get(0);
        if (keyProperties.size() == 1) {
            String property = keyProperties.get(0);
            String constraintCypher = "CREATE CONSTRAINT IF NOT EXISTS ON (n" + labelsClause + ") ASSERT n." + property + " IS UNIQUE;";
            log.logDetailed("Creating constraint : " + constraintCypher);
            session.run(constraintCypher);
            return;
        }
        String indexCypher = "CREATE INDEX IF NOT EXISTS ON ";
        indexCypher = indexCypher + labelsClause;
        indexCypher = indexCypher + "(";
        boolean firstProperty = true;
        for (String property : keyProperties) {
            if (firstProperty) {
                firstProperty = false;
            } else {
                indexCypher = indexCypher + ", ";
            }
            indexCypher = indexCypher + property;
        }
        indexCypher = indexCypher + ")";
        log.logDetailed("Creating index : " + indexCypher);
        session.run(indexCypher);
    }
}

