/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.shared;

import org.apache.hop.core.Const;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.CheckBoxVar;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.metadata.MetadataPerspective;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class NeoConnectionEditor
extends MetadataEditor<NeoConnection> {
    private static Class<?> PKG = NeoConnectionEditor.class;
    private Text wName;
    private Label wlServer;
    private TextVar wServer;
    private Label wlDatabaseName;
    private TextVar wDatabaseName;
    private CheckBoxVar wVersion4;
    private Label wlBoltPort;
    private TextVar wBoltPort;
    private TextVar wBrowserPort;
    private Label wlPolicy;
    private TextVar wPolicy;
    private TextVar wUsername;
    private TextVar wPassword;
    private Label wlRouting;
    private CheckBoxVar wRouting;
    private Label wlEncryption;
    private CheckBoxVar wEncryption;
    private Label wlTrustAllCertificates;
    private CheckBoxVar wTrustAllCertificates;
    private Group gAdvanced;
    private TextVar wConnectionLivenessCheckTimeout;
    private TextVar wMaxConnectionLifetime;
    private TextVar wMaxConnectionPoolSize;
    private TextVar wConnectionAcquisitionTimeout;
    private TextVar wConnectionTimeout;
    private TextVar wMaxTransactionRetryTime;
    private TableView wUrls;

    public NeoConnectionEditor(HopGui hopGui, MetadataManager<NeoConnection> manager, NeoConnection neoConnection) {
        super(hopGui, manager, (IHopMetadata)neoConnection);
    }

    public void createControl(Composite composite) {
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = 6;
        IVariables variables = this.getHopGui().getVariables();
        Label wlName = new Label(composite, 131072);
        props.setLook((Control)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Name.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(composite, 18436);
        props.setLook((Control)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment(95, 0);
        this.wName.setLayoutData((Object)fdName);
        Text lastControl = this.wName;
        this.wlServer = new Label(composite, 131072);
        props.setLook((Control)this.wlServer);
        this.wlServer.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Server.Label", (String[])new String[0]));
        FormData fdlServer = new FormData();
        fdlServer.top = new FormAttachment((Control)lastControl, margin);
        fdlServer.left = new FormAttachment(0, 0);
        fdlServer.right = new FormAttachment(middle, -margin);
        this.wlServer.setLayoutData((Object)fdlServer);
        this.wServer = new TextVar(variables, composite, 18436);
        props.setLook((Control)this.wServer);
        FormData fdServer = new FormData();
        fdServer.top = new FormAttachment((Control)this.wlServer, 0, 0x1000000);
        fdServer.left = new FormAttachment(middle, 0);
        fdServer.right = new FormAttachment(95, 0);
        this.wServer.setLayoutData((Object)fdServer);
        lastControl = this.wServer;
        this.wlDatabaseName = new Label(composite, 131072);
        props.setLook((Control)this.wlDatabaseName);
        this.wlDatabaseName.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.DatabaseName.Label", (String[])new String[0]));
        FormData fdlDatabaseName = new FormData();
        fdlDatabaseName.top = new FormAttachment((Control)lastControl, margin);
        fdlDatabaseName.left = new FormAttachment(0, 0);
        fdlDatabaseName.right = new FormAttachment(middle, -margin);
        this.wlDatabaseName.setLayoutData((Object)fdlDatabaseName);
        this.wDatabaseName = new TextVar(variables, composite, 18436);
        props.setLook((Control)this.wDatabaseName);
        FormData fdDatabaseName = new FormData();
        fdDatabaseName.top = new FormAttachment((Control)this.wlDatabaseName, 0, 0x1000000);
        fdDatabaseName.left = new FormAttachment(middle, 0);
        fdDatabaseName.right = new FormAttachment(95, 0);
        this.wDatabaseName.setLayoutData((Object)fdDatabaseName);
        lastControl = this.wDatabaseName;
        Label wlVersion4 = new Label(composite, 131072);
        wlVersion4.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Version4.Label", (String[])new String[0]));
        props.setLook((Control)wlVersion4);
        FormData fdlVersion4 = new FormData();
        fdlVersion4.top = new FormAttachment((Control)lastControl, margin);
        fdlVersion4.left = new FormAttachment(0, 0);
        fdlVersion4.right = new FormAttachment(middle, -margin);
        wlVersion4.setLayoutData((Object)fdlVersion4);
        this.wVersion4 = new CheckBoxVar(variables, composite, 32);
        props.setLook((Control)this.wVersion4);
        FormData fdVersion4 = new FormData();
        fdVersion4.top = new FormAttachment((Control)wlVersion4, 0, 0x1000000);
        fdVersion4.left = new FormAttachment(middle, 0);
        fdVersion4.right = new FormAttachment(95, 0);
        this.wVersion4.setLayoutData((Object)fdVersion4);
        lastControl = this.wVersion4;
        this.wlBoltPort = new Label(composite, 131072);
        props.setLook((Control)this.wlBoltPort);
        this.wlBoltPort.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.BoltPort.Label", (String[])new String[0]));
        FormData fdlBoltPort = new FormData();
        fdlBoltPort.top = new FormAttachment((Control)lastControl, margin);
        fdlBoltPort.left = new FormAttachment(0, 0);
        fdlBoltPort.right = new FormAttachment(middle, -margin);
        this.wlBoltPort.setLayoutData((Object)fdlBoltPort);
        this.wBoltPort = new TextVar(variables, composite, 18436);
        props.setLook((Control)this.wBoltPort);
        FormData fdBoltPort = new FormData();
        fdBoltPort.top = new FormAttachment((Control)this.wlBoltPort, 0, 0x1000000);
        fdBoltPort.left = new FormAttachment(middle, 0);
        fdBoltPort.right = new FormAttachment(95, 0);
        this.wBoltPort.setLayoutData((Object)fdBoltPort);
        lastControl = this.wBoltPort;
        Label wlBrowserPort = new Label(composite, 131072);
        props.setLook((Control)wlBrowserPort);
        wlBrowserPort.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.BrowserPort.Label", (String[])new String[0]));
        FormData fdlBrowserPort = new FormData();
        fdlBrowserPort.top = new FormAttachment((Control)lastControl, margin);
        fdlBrowserPort.left = new FormAttachment(0, 0);
        fdlBrowserPort.right = new FormAttachment(middle, -margin);
        wlBrowserPort.setLayoutData((Object)fdlBrowserPort);
        this.wBrowserPort = new TextVar(variables, composite, 18436);
        props.setLook((Control)this.wBrowserPort);
        FormData fdBrowserPort = new FormData();
        fdBrowserPort.top = new FormAttachment((Control)wlBrowserPort, 0, 0x1000000);
        fdBrowserPort.left = new FormAttachment(middle, 0);
        fdBrowserPort.right = new FormAttachment(95, 0);
        this.wBrowserPort.setLayoutData((Object)fdBrowserPort);
        lastControl = this.wBrowserPort;
        this.wlRouting = new Label(composite, 131072);
        this.wlRouting.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Routing.Label", (String[])new String[0]));
        props.setLook((Control)this.wlRouting);
        FormData fdlRouting = new FormData();
        fdlRouting.top = new FormAttachment((Control)lastControl, margin);
        fdlRouting.left = new FormAttachment(0, 0);
        fdlRouting.right = new FormAttachment(middle, -margin);
        this.wlRouting.setLayoutData((Object)fdlRouting);
        this.wRouting = new CheckBoxVar(variables, composite, 32);
        props.setLook((Control)this.wRouting);
        FormData fdRouting = new FormData();
        fdRouting.top = new FormAttachment((Control)this.wlRouting, 0, 0x1000000);
        fdRouting.left = new FormAttachment(middle, 0);
        fdRouting.right = new FormAttachment(95, 0);
        this.wRouting.setLayoutData((Object)fdRouting);
        lastControl = this.wRouting;
        this.wlPolicy = new Label(composite, 131072);
        this.wlPolicy.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Policy.Label", (String[])new String[0]));
        props.setLook((Control)this.wlPolicy);
        FormData fdlPolicy = new FormData();
        fdlPolicy.top = new FormAttachment((Control)lastControl, margin);
        fdlPolicy.left = new FormAttachment(0, 0);
        fdlPolicy.right = new FormAttachment(middle, -margin);
        this.wlPolicy.setLayoutData((Object)fdlPolicy);
        this.wPolicy = new TextVar(variables, composite, 18436);
        props.setLook((Control)this.wPolicy);
        FormData fdPolicy = new FormData();
        fdPolicy.top = new FormAttachment((Control)this.wlPolicy, 0, 0x1000000);
        fdPolicy.left = new FormAttachment(middle, 0);
        fdPolicy.right = new FormAttachment(95, 0);
        this.wPolicy.setLayoutData((Object)fdPolicy);
        lastControl = this.wPolicy;
        this.wRouting.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NeoConnectionEditor.this.enableFields();
            }
        });
        Label wlUsername = new Label(composite, 131072);
        wlUsername.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.UserName.Label", (String[])new String[0]));
        props.setLook((Control)wlUsername);
        FormData fdlUsername = new FormData();
        fdlUsername.top = new FormAttachment((Control)lastControl, margin);
        fdlUsername.left = new FormAttachment(0, 0);
        fdlUsername.right = new FormAttachment(middle, -margin);
        wlUsername.setLayoutData((Object)fdlUsername);
        this.wUsername = new TextVar(variables, composite, 18436);
        props.setLook((Control)this.wUsername);
        FormData fdUsername = new FormData();
        fdUsername.top = new FormAttachment((Control)wlUsername, 0, 0x1000000);
        fdUsername.left = new FormAttachment(middle, 0);
        fdUsername.right = new FormAttachment(95, 0);
        this.wUsername.setLayoutData((Object)fdUsername);
        lastControl = this.wUsername;
        Label wlPassword = new Label(composite, 131072);
        wlPassword.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Password.Label", (String[])new String[0]));
        props.setLook((Control)wlPassword);
        FormData fdlPassword = new FormData();
        fdlPassword.top = new FormAttachment((Control)this.wUsername, margin);
        fdlPassword.left = new FormAttachment(0, 0);
        fdlPassword.right = new FormAttachment(middle, -margin);
        wlPassword.setLayoutData((Object)fdlPassword);
        this.wPassword = new PasswordTextVar(variables, composite, 18436);
        props.setLook((Control)this.wPassword);
        FormData fdPassword = new FormData();
        fdPassword.top = new FormAttachment((Control)wlPassword, 0, 0x1000000);
        fdPassword.left = new FormAttachment(middle, 0);
        fdPassword.right = new FormAttachment(95, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        lastControl = this.wPassword;
        this.wlEncryption = new Label(composite, 131072);
        this.wlEncryption.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.Encryption.Label", (String[])new String[0]));
        props.setLook((Control)this.wlEncryption);
        FormData fdlEncryption = new FormData();
        fdlEncryption.top = new FormAttachment((Control)lastControl, margin);
        fdlEncryption.left = new FormAttachment(0, 0);
        fdlEncryption.right = new FormAttachment(middle, -margin);
        this.wlEncryption.setLayoutData((Object)fdlEncryption);
        this.wEncryption = new CheckBoxVar(variables, composite, 32);
        props.setLook((Control)this.wEncryption);
        FormData fdEncryption = new FormData();
        fdEncryption.top = new FormAttachment((Control)this.wlEncryption, 0, 0x1000000);
        fdEncryption.left = new FormAttachment(middle, 0);
        fdEncryption.right = new FormAttachment(95, 0);
        this.wEncryption.setLayoutData((Object)fdEncryption);
        this.wEncryption.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NeoConnectionEditor.this.enableFields();
            }
        });
        lastControl = this.wEncryption;
        this.wlTrustAllCertificates = new Label(composite, 131072);
        this.wlTrustAllCertificates.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.TrustAllCertificates.Label", (String[])new String[0]));
        props.setLook((Control)this.wlTrustAllCertificates);
        FormData fdlTrustAllCertificates = new FormData();
        fdlTrustAllCertificates.top = new FormAttachment((Control)lastControl, margin);
        fdlTrustAllCertificates.left = new FormAttachment(0, 0);
        fdlTrustAllCertificates.right = new FormAttachment(middle, -margin);
        this.wlTrustAllCertificates.setLayoutData((Object)fdlTrustAllCertificates);
        this.wTrustAllCertificates = new CheckBoxVar(variables, composite, 32);
        props.setLook((Control)this.wEncryption);
        FormData fdTrustAllCertificates = new FormData();
        fdTrustAllCertificates.top = new FormAttachment((Control)this.wlTrustAllCertificates, 0, 0x1000000);
        fdTrustAllCertificates.left = new FormAttachment(middle, 0);
        fdTrustAllCertificates.right = new FormAttachment(95, 0);
        this.wTrustAllCertificates.setLayoutData((Object)fdTrustAllCertificates);
        lastControl = this.wlTrustAllCertificates;
        this.gAdvanced = new Group(composite, 16);
        props.setLook((Control)this.gAdvanced);
        FormLayout advancedLayout = new FormLayout();
        advancedLayout.marginTop = margin;
        advancedLayout.marginBottom = margin;
        this.gAdvanced.setLayout((Layout)advancedLayout);
        this.gAdvanced.setText("Advanced options");
        Label wlConnectionLivenessCheckTimeout = new Label((Composite)this.gAdvanced, 131072);
        wlConnectionLivenessCheckTimeout.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.ConnectionLivenessCheckTimeout.Label", (String[])new String[0]));
        props.setLook((Control)wlConnectionLivenessCheckTimeout);
        FormData fdlConnectionLivenessCheckTimeout = new FormData();
        fdlConnectionLivenessCheckTimeout.top = new FormAttachment(0, 0);
        fdlConnectionLivenessCheckTimeout.left = new FormAttachment(0, 0);
        fdlConnectionLivenessCheckTimeout.right = new FormAttachment(middle, -margin);
        wlConnectionLivenessCheckTimeout.setLayoutData((Object)fdlConnectionLivenessCheckTimeout);
        this.wConnectionLivenessCheckTimeout = new TextVar(variables, (Composite)this.gAdvanced, 18436);
        props.setLook((Control)this.wConnectionLivenessCheckTimeout);
        FormData fdConnectionLivenessCheckTimeout = new FormData();
        fdConnectionLivenessCheckTimeout.top = new FormAttachment((Control)wlConnectionLivenessCheckTimeout, 0, 0x1000000);
        fdConnectionLivenessCheckTimeout.left = new FormAttachment(middle, 0);
        fdConnectionLivenessCheckTimeout.right = new FormAttachment(95, 0);
        this.wConnectionLivenessCheckTimeout.setLayoutData((Object)fdConnectionLivenessCheckTimeout);
        TextVar lastGroupControl = this.wConnectionLivenessCheckTimeout;
        Label wlMaxConnectionLifetime = new Label((Composite)this.gAdvanced, 131072);
        wlMaxConnectionLifetime.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.MaxConnectionLifetime.Label", (String[])new String[0]));
        props.setLook((Control)wlMaxConnectionLifetime);
        FormData fdlMaxConnectionLifetime = new FormData();
        fdlMaxConnectionLifetime.top = new FormAttachment((Control)lastGroupControl, margin);
        fdlMaxConnectionLifetime.left = new FormAttachment(0, 0);
        fdlMaxConnectionLifetime.right = new FormAttachment(middle, -margin);
        wlMaxConnectionLifetime.setLayoutData((Object)fdlMaxConnectionLifetime);
        this.wMaxConnectionLifetime = new TextVar(variables, (Composite)this.gAdvanced, 18436);
        props.setLook((Control)this.wMaxConnectionLifetime);
        FormData fdMaxConnectionLifetime = new FormData();
        fdMaxConnectionLifetime.top = new FormAttachment((Control)wlMaxConnectionLifetime, 0, 0x1000000);
        fdMaxConnectionLifetime.left = new FormAttachment(middle, 0);
        fdMaxConnectionLifetime.right = new FormAttachment(95, 0);
        this.wMaxConnectionLifetime.setLayoutData((Object)fdMaxConnectionLifetime);
        lastGroupControl = this.wMaxConnectionLifetime;
        Label wlMaxConnectionPoolSize = new Label((Composite)this.gAdvanced, 131072);
        wlMaxConnectionPoolSize.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.MaxConnectionPoolSize.Label", (String[])new String[0]));
        props.setLook((Control)wlMaxConnectionPoolSize);
        FormData fdlMaxConnectionPoolSize = new FormData();
        fdlMaxConnectionPoolSize.top = new FormAttachment((Control)lastGroupControl, margin);
        fdlMaxConnectionPoolSize.left = new FormAttachment(0, 0);
        fdlMaxConnectionPoolSize.right = new FormAttachment(middle, -margin);
        wlMaxConnectionPoolSize.setLayoutData((Object)fdlMaxConnectionPoolSize);
        this.wMaxConnectionPoolSize = new TextVar(variables, (Composite)this.gAdvanced, 18436);
        props.setLook((Control)this.wMaxConnectionPoolSize);
        FormData fdMaxConnectionPoolSize = new FormData();
        fdMaxConnectionPoolSize.top = new FormAttachment((Control)wlMaxConnectionPoolSize, 0, 0x1000000);
        fdMaxConnectionPoolSize.left = new FormAttachment(middle, 0);
        fdMaxConnectionPoolSize.right = new FormAttachment(95, 0);
        this.wMaxConnectionPoolSize.setLayoutData((Object)fdMaxConnectionPoolSize);
        lastGroupControl = this.wMaxConnectionPoolSize;
        Label wlConnectionAcquisitionTimeout = new Label((Composite)this.gAdvanced, 131072);
        wlConnectionAcquisitionTimeout.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.ConnectionAcquisitionTimeout.Label", (String[])new String[0]));
        props.setLook((Control)wlConnectionAcquisitionTimeout);
        FormData fdlConnectionAcquisitionTimeout = new FormData();
        fdlConnectionAcquisitionTimeout.top = new FormAttachment((Control)lastGroupControl, margin);
        fdlConnectionAcquisitionTimeout.left = new FormAttachment(0, 0);
        fdlConnectionAcquisitionTimeout.right = new FormAttachment(middle, -margin);
        wlConnectionAcquisitionTimeout.setLayoutData((Object)fdlConnectionAcquisitionTimeout);
        this.wConnectionAcquisitionTimeout = new TextVar(variables, (Composite)this.gAdvanced, 18436);
        props.setLook((Control)this.wConnectionAcquisitionTimeout);
        FormData fdConnectionAcquisitionTimeout = new FormData();
        fdConnectionAcquisitionTimeout.top = new FormAttachment((Control)wlConnectionAcquisitionTimeout, 0, 0x1000000);
        fdConnectionAcquisitionTimeout.left = new FormAttachment(middle, 0);
        fdConnectionAcquisitionTimeout.right = new FormAttachment(95, 0);
        this.wConnectionAcquisitionTimeout.setLayoutData((Object)fdConnectionAcquisitionTimeout);
        lastGroupControl = this.wConnectionAcquisitionTimeout;
        Label wlConnectionTimeout = new Label((Composite)this.gAdvanced, 131072);
        wlConnectionTimeout.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.ConnectionTimeout.Label", (String[])new String[0]));
        props.setLook((Control)wlConnectionTimeout);
        FormData fdlConnectionTimeout = new FormData();
        fdlConnectionTimeout.top = new FormAttachment((Control)lastGroupControl, margin);
        fdlConnectionTimeout.left = new FormAttachment(0, 0);
        fdlConnectionTimeout.right = new FormAttachment(middle, -margin);
        wlConnectionTimeout.setLayoutData((Object)fdlConnectionTimeout);
        this.wConnectionTimeout = new TextVar(variables, (Composite)this.gAdvanced, 18436);
        props.setLook((Control)this.wConnectionTimeout);
        FormData fdConnectionTimeout = new FormData();
        fdConnectionTimeout.top = new FormAttachment((Control)wlConnectionTimeout, 0, 0x1000000);
        fdConnectionTimeout.left = new FormAttachment(middle, 0);
        fdConnectionTimeout.right = new FormAttachment(95, 0);
        this.wConnectionTimeout.setLayoutData((Object)fdConnectionTimeout);
        lastGroupControl = this.wConnectionTimeout;
        Label wlMaxTransactionRetryTime = new Label((Composite)this.gAdvanced, 131072);
        wlMaxTransactionRetryTime.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.MaxTransactionRetryTime.Label", (String[])new String[0]));
        props.setLook((Control)wlMaxTransactionRetryTime);
        FormData fdlMaxTransactionRetryTime = new FormData();
        fdlMaxTransactionRetryTime.top = new FormAttachment((Control)lastGroupControl, margin);
        fdlMaxTransactionRetryTime.left = new FormAttachment(0, 0);
        fdlMaxTransactionRetryTime.right = new FormAttachment(middle, -margin);
        wlMaxTransactionRetryTime.setLayoutData((Object)fdlMaxTransactionRetryTime);
        this.wMaxTransactionRetryTime = new TextVar(variables, (Composite)this.gAdvanced, 18436);
        props.setLook((Control)this.wMaxTransactionRetryTime);
        FormData fdMaxTransactionRetryTime = new FormData();
        fdMaxTransactionRetryTime.top = new FormAttachment((Control)wlMaxTransactionRetryTime, 0, 0x1000000);
        fdMaxTransactionRetryTime.left = new FormAttachment(middle, 0);
        fdMaxTransactionRetryTime.right = new FormAttachment(95, 0);
        this.wMaxTransactionRetryTime.setLayoutData((Object)fdMaxTransactionRetryTime);
        lastGroupControl = this.wMaxTransactionRetryTime;
        FormData fdgAdvanced = new FormData();
        fdgAdvanced.left = new FormAttachment(0, 0);
        fdgAdvanced.right = new FormAttachment(100, 0);
        fdgAdvanced.top = new FormAttachment((Control)lastControl, margin * 2);
        this.gAdvanced.setLayoutData((Object)fdgAdvanced);
        lastControl = this.gAdvanced;
        Group gUrls = new Group(composite, 16);
        props.setLook((Control)gUrls);
        FormLayout urlsLayout = new FormLayout();
        urlsLayout.marginTop = margin;
        urlsLayout.marginBottom = margin;
        gUrls.setLayout((Layout)urlsLayout);
        gUrls.setText(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.URLs.Label", (String[])new String[0]));
        this.wUrls = new TableView(variables, (Composite)gUrls, 0, new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"NeoConnectionEditor.URLColumn.Label", (String[])new String[0]), 1)}, ((NeoConnection)this.getMetadata()).getManualUrls().size(), e -> this.setChanged(), props);
        this.wUrls.table.addListener(13, e -> this.enableFields());
        this.wUrls.table.addListener(3, e -> this.enableFields());
        this.wUrls.table.addListener(4, e -> this.enableFields());
        this.wUrls.table.addListener(15, e -> this.enableFields());
        this.wUrls.table.addListener(16, e -> this.enableFields());
        this.wUrls.addModifyListener(e -> this.enableFields());
        FormData fdUrls = new FormData();
        fdUrls.top = new FormAttachment(0, 0);
        fdUrls.left = new FormAttachment(0, 0);
        fdUrls.right = new FormAttachment(100, 0);
        fdUrls.bottom = new FormAttachment(100, 0);
        this.wUrls.setLayoutData((Object)fdUrls);
        FormData fdgUrls = new FormData();
        fdgUrls.left = new FormAttachment(0, 0);
        fdgUrls.right = new FormAttachment(100, 0);
        fdgUrls.top = new FormAttachment((Control)lastControl, margin * 2);
        fdgUrls.bottom = new FormAttachment(100, -margin * 2);
        gUrls.setLayoutData((Object)fdgUrls);
        this.setWidgetsContent();
        Listener modifyListener = e -> this.setChanged();
        this.wName.addListener(24, modifyListener);
        this.wServer.addListener(24, modifyListener);
        this.wDatabaseName.addListener(24, modifyListener);
        this.wVersion4.addListener(13, modifyListener);
        this.wBoltPort.addListener(13, modifyListener);
        this.wBrowserPort.addListener(24, modifyListener);
        this.wPolicy.addListener(24, modifyListener);
        this.wUsername.addListener(24, modifyListener);
        this.wPassword.addListener(24, modifyListener);
        this.wRouting.addListener(13, modifyListener);
        this.wEncryption.addListener(13, modifyListener);
        this.wTrustAllCertificates.addListener(13, modifyListener);
        this.wConnectionLivenessCheckTimeout.addListener(24, modifyListener);
        this.wMaxConnectionLifetime.addListener(24, modifyListener);
        this.wMaxConnectionPoolSize.addListener(24, modifyListener);
        this.wConnectionAcquisitionTimeout.addListener(24, modifyListener);
        this.wConnectionTimeout.addListener(24, modifyListener);
        this.wMaxTransactionRetryTime.addListener(24, modifyListener);
    }

    private void enableFields() {
        this.wlPolicy.setEnabled(this.wRouting.getSelection());
        this.wPolicy.setEnabled(this.wRouting.getSelection());
        boolean hasNoUrls = this.wUrls.nrNonEmpty() == 0;
        for (Control control : new Control[]{this.wlServer, this.wServer, this.wlDatabaseName, this.wDatabaseName, this.wlBoltPort, this.wBoltPort, this.wlRouting, this.wRouting, this.wlPolicy, this.wPolicy, this.wlEncryption, this.wEncryption, this.gAdvanced}) {
            control.setEnabled(hasNoUrls);
        }
        boolean encryption = this.wEncryption.getSelection();
        this.wlTrustAllCertificates.setEnabled(encryption);
        this.wTrustAllCertificates.setEnabled(encryption);
        this.wTrustAllCertificates.getTextVar().setEnabled(encryption);
    }

    public void setWidgetsContent() {
        this.wName.setText(Const.NVL((String)((NeoConnection)this.metadata).getName(), (String)""));
        this.wServer.setText(Const.NVL((String)((NeoConnection)this.metadata).getServer(), (String)""));
        this.wDatabaseName.setText(Const.NVL((String)((NeoConnection)this.metadata).getDatabaseName(), (String)""));
        this.wVersion4.setSelection(((NeoConnection)this.metadata).isVersion4());
        this.wVersion4.setVariableName(Const.NVL((String)((NeoConnection)this.metadata).getVersion4Variable(), (String)""));
        this.wBoltPort.setText(Const.NVL((String)((NeoConnection)this.metadata).getBoltPort(), (String)""));
        this.wBrowserPort.setText(Const.NVL((String)((NeoConnection)this.metadata).getBrowserPort(), (String)""));
        this.wRouting.setSelection(((NeoConnection)this.metadata).isRouting());
        this.wRouting.setVariableName(Const.NVL((String)((NeoConnection)this.metadata).getRoutingVariable(), (String)""));
        this.wPolicy.setText(Const.NVL((String)((NeoConnection)this.metadata).getRoutingPolicy(), (String)""));
        this.wUsername.setText(Const.NVL((String)((NeoConnection)this.metadata).getUsername(), (String)""));
        this.wPassword.setText(Const.NVL((String)((NeoConnection)this.metadata).getPassword(), (String)""));
        this.wEncryption.setSelection(((NeoConnection)this.metadata).isUsingEncryption());
        this.wEncryption.setVariableName(Const.NVL((String)((NeoConnection)this.metadata).getUsingEncryptionVariable(), (String)""));
        this.wTrustAllCertificates.setSelection(((NeoConnection)this.metadata).isTrustAllCertificates());
        this.wTrustAllCertificates.setVariableName(Const.NVL((String)((NeoConnection)this.metadata).getTrustAllCertificatesVariable(), (String)""));
        this.wConnectionLivenessCheckTimeout.setText(Const.NVL((String)((NeoConnection)this.metadata).getConnectionLivenessCheckTimeout(), (String)""));
        this.wMaxConnectionLifetime.setText(Const.NVL((String)((NeoConnection)this.metadata).getMaxConnectionLifetime(), (String)""));
        this.wMaxConnectionPoolSize.setText(Const.NVL((String)((NeoConnection)this.metadata).getMaxConnectionPoolSize(), (String)""));
        this.wConnectionAcquisitionTimeout.setText(Const.NVL((String)((NeoConnection)this.metadata).getConnectionAcquisitionTimeout(), (String)""));
        this.wConnectionTimeout.setText(Const.NVL((String)((NeoConnection)this.metadata).getConnectionTimeout(), (String)""));
        this.wMaxTransactionRetryTime.setText(Const.NVL((String)((NeoConnection)this.metadata).getMaxTransactionRetryTime(), (String)""));
        for (int i = 0; i < ((NeoConnection)this.metadata).getManualUrls().size(); ++i) {
            TableItem item = this.wUrls.table.getItem(i);
            item.setText(1, Const.NVL((String)((NeoConnection)this.metadata).getManualUrls().get(i), (String)""));
        }
        this.wUrls.setRowNums();
        this.wUrls.optWidth(true);
        this.enableFields();
        this.wName.setFocus();
    }

    public void getWidgetsContent(NeoConnection neoConnection) {
        neoConnection.setName(this.wName.getText());
        neoConnection.setServer(this.wServer.getText());
        neoConnection.setDatabaseName(this.wDatabaseName.getText());
        neoConnection.setVersion4(this.wVersion4.getSelection());
        neoConnection.setVersion4Variable(this.wVersion4.getVariableName());
        neoConnection.setBoltPort(this.wBoltPort.getText());
        neoConnection.setBrowserPort(this.wBrowserPort.getText());
        neoConnection.setRouting(this.wRouting.getSelection());
        neoConnection.setRoutingVariable(this.wRouting.getVariableName());
        neoConnection.setRoutingPolicy(this.wPolicy.getText());
        neoConnection.setUsername(this.wUsername.getText());
        neoConnection.setPassword(this.wPassword.getText());
        neoConnection.setUsingEncryption(this.wEncryption.getSelection());
        neoConnection.setUsingEncryptionVariable(this.wEncryption.getVariableName());
        neoConnection.setTrustAllCertificates(this.wTrustAllCertificates.getSelection());
        neoConnection.setTrustAllCertificatesVariable(this.wTrustAllCertificates.getVariableName());
        neoConnection.setConnectionLivenessCheckTimeout(this.wConnectionLivenessCheckTimeout.getText());
        neoConnection.setMaxConnectionLifetime(this.wMaxConnectionLifetime.getText());
        neoConnection.setMaxConnectionPoolSize(this.wMaxConnectionPoolSize.getText());
        neoConnection.setConnectionAcquisitionTimeout(this.wConnectionAcquisitionTimeout.getText());
        neoConnection.setConnectionTimeout(this.wConnectionTimeout.getText());
        neoConnection.setMaxTransactionRetryTime(this.wMaxTransactionRetryTime.getText());
        neoConnection.getManualUrls().clear();
        for (int i = 0; i < this.wUrls.nrNonEmpty(); ++i) {
            TableItem item = this.wUrls.getNonEmpty(i);
            neoConnection.getManualUrls().add(item.getText(1));
        }
    }

    public void test() {
        IVariables variables = this.manager.getVariables();
        NeoConnection neo = new NeoConnection(this.manager.getVariables(), (NeoConnection)this.metadata);
        try {
            this.getWidgetsContent(neo);
            neo.test(variables);
            MessageBox box = new MessageBox(this.hopGui.getShell(), 32);
            box.setText("OK");
            String message = "Connection successful!" + Const.CR;
            message = message + Const.CR;
            message = message + "URL : " + neo.getUrl(variables);
            box.setMessage(message);
            box.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), "Error", "Error connecting to Neo with URL : " + neo.getUrl(variables), e);
        }
    }

    public Button[] createButtonsForButtonBar(Composite composite) {
        Button wTest = new Button(composite, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"System.Button.Test", (String[])new String[0]));
        wTest.addListener(13, e -> this.test());
        return new Button[]{wTest};
    }

    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }

    public void setChanged() {
        if (!this.isChanged) {
            this.isChanged = true;
            MetadataPerspective.getInstance().updateEditor((MetadataEditor)this);
        }
    }
}

