/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.shared;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.neo4j.driver.Driver;

public class DriverSingleton {
    private static DriverSingleton singleton;
    private Map<String, Driver> driverMap = new HashMap<String, Driver>();

    private DriverSingleton() {
    }

    public static DriverSingleton getInstance() {
        if (singleton == null) {
            singleton = new DriverSingleton();
        }
        return singleton;
    }

    public static Driver getDriver(ILogChannel log, IVariables variables, NeoConnection connection) {
        DriverSingleton ds = DriverSingleton.getInstance();
        String key = DriverSingleton.getDriverKey(connection, variables);
        Driver driver = ds.driverMap.get(key);
        if (driver == null) {
            driver = connection.getDriver(log, variables);
            ds.driverMap.put(key, driver);
        }
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        DriverSingleton ds = DriverSingleton.getInstance();
        ArrayList<String> keys = new ArrayList<String>(ds.getDriverMap().keySet());
        for (String key : keys) {
            Map<String, Driver> map = ds.getDriverMap();
            synchronized (map) {
                Driver driver = ds.driverMap.get(key);
                driver.close();
                ds.driverMap.remove(key);
            }
        }
    }

    private static String getDriverKey(NeoConnection connection, IVariables variables) {
        String hostname = variables.resolve(connection.getServer());
        String boltPort = variables.resolve(connection.getBoltPort());
        String username = variables.resolve(connection.getUsername());
        return hostname + ":" + boltPort + "@" + username;
    }

    public Map<String, Driver> getDriverMap() {
        return this.driverMap;
    }
}

