/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.model.cw;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.neo4j.model.GraphModel;
import org.apache.hop.neo4j.model.GraphNode;
import org.apache.hop.neo4j.model.GraphPresentation;
import org.apache.hop.neo4j.model.GraphProperty;
import org.apache.hop.neo4j.model.GraphPropertyType;
import org.apache.hop.neo4j.model.GraphRelationship;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class CypherWorkbenchImporter {
    public static GraphModel importFromCwJson(String jsonString) throws HopException {
        try {
            GraphModel graphModel = new GraphModel();
            JSONParser parser = new JSONParser();
            JSONObject jModel = (JSONObject)parser.parse(jsonString);
            JSONObject jMetadata = (JSONObject)jModel.get((Object)"metadata");
            String modelName = (String)jMetadata.get((Object)"title");
            graphModel.setName(modelName);
            String modelDescription = (String)jMetadata.get((Object)"description");
            graphModel.setDescription(modelDescription);
            JSONObject jDataModel = (JSONObject)jModel.get((Object)"dataModel");
            JSONObject jNodeLabels = (JSONObject)jDataModel.get((Object)"nodeLabels");
            for (Object jNodeKey : jNodeLabels.keySet()) {
                JSONObject jNodeLabel = (JSONObject)jNodeLabels.get(jNodeKey);
                String classTypeString = (String)jNodeLabel.get((Object)"classType");
                if (!"NodeLabel".equals(classTypeString)) continue;
                GraphNode graphNode = new GraphNode();
                String key = (String)jNodeLabel.get((Object)"key");
                String label = (String)jNodeLabel.get((Object)"label");
                graphNode.setName(key);
                graphNode.getLabels().add(label);
                graphNode.getProperties().addAll(CypherWorkbenchImporter.importProperties(jNodeLabel, "properties"));
                JSONObject jNodeDisplay = (JSONObject)jNodeLabel.get((Object)"display");
                Double nodeLocationX = CypherWorkbenchImporter.getDouble(jNodeDisplay.get((Object)"x"));
                Double nodeLocationY = CypherWorkbenchImporter.getDouble(jNodeDisplay.get((Object)"y"));
                if (nodeLocationX != null && nodeLocationY != null) {
                    graphNode.setPresentation(new GraphPresentation(nodeLocationX.intValue(), nodeLocationY.intValue()));
                }
                graphModel.getNodes().add(graphNode);
            }
            JSONObject jRelationshipTypes = (JSONObject)jDataModel.get((Object)"relationshipTypes");
            for (Object jRelationshipTypeKey : jRelationshipTypes.keySet()) {
                JSONObject jRelationshipType = (JSONObject)jRelationshipTypes.get(jRelationshipTypeKey);
                String classTypeString = (String)jRelationshipType.get((Object)"classType");
                if (!"RelationshipType".equals(classTypeString)) continue;
                String relationshipKey = (String)jRelationshipType.get((Object)"key");
                String relationshipType = (String)jRelationshipType.get((Object)"type");
                String relationshipStartKey = (String)jRelationshipType.get((Object)"startNodeLabelKey");
                String relationshipEndKey = (String)jRelationshipType.get((Object)"endNodeLabelKey");
                List<GraphProperty> relationshipProperties = CypherWorkbenchImporter.importProperties(jRelationshipType, "properties");
                GraphRelationship graphRelationship = new GraphRelationship(relationshipKey, relationshipType, relationshipType, relationshipProperties, relationshipStartKey, relationshipEndKey);
                graphModel.getRelationships().add(graphRelationship);
            }
            return graphModel;
        }
        catch (Exception e) {
            throw new HopException("Error parsing Cypher Workbench model", (Throwable)e);
        }
    }

    private static Double getDouble(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Float) {
            return ((Float)obj).doubleValue();
        }
        if (obj instanceof Long) {
            return ((Long)obj).doubleValue();
        }
        throw new RuntimeException("Unrecognized data type for value " + obj.toString());
    }

    private static List<GraphProperty> importProperties(JSONObject j, String propertiesKey) {
        ArrayList<GraphProperty> properties = new ArrayList<GraphProperty>();
        JSONObject jNodeProperties = (JSONObject)j.get((Object)propertiesKey);
        if (jNodeProperties != null) {
            for (Object jPropertyKey : jNodeProperties.keySet()) {
                JSONObject jNodeProperty = (JSONObject)jNodeProperties.get(jPropertyKey);
                String propertyName = (String)jNodeProperty.get((Object)"name");
                String propertyKey = (String)jNodeProperty.get((Object)"key");
                String propertyTypeString = (String)jNodeProperty.get((Object)"datatype");
                Boolean propertyPartOfKey = (Boolean)jNodeProperty.get((Object)"isPartOfKey");
                Boolean propertyMustExist = (Boolean)jNodeProperty.get((Object)"mustExist");
                Boolean propertyHasUniqueConstraints = (Boolean)jNodeProperty.get((Object)"hasUniqueConstraint");
                Boolean propertyIsIndexed = (Boolean)jNodeProperty.get((Object)"isIndexed");
                GraphPropertyType propertyType = GraphPropertyType.parseCode(propertyTypeString);
                GraphProperty nodeProperty = new GraphProperty(propertyKey, propertyName, propertyType, propertyPartOfKey == null ? false : propertyPartOfKey, propertyMustExist == null ? false : propertyMustExist, propertyHasUniqueConstraints == null ? false : propertyHasUniqueConstraints, propertyIsIndexed == null ? false : propertyIsIndexed);
                properties.add(nodeProperty);
            }
        }
        return properties;
    }

    public static final GraphModel changeNamesToLabels(GraphModel sourceModel) throws HopException {
        String label;
        GraphModel graphModel = new GraphModel(sourceModel);
        HashSet<String> nodeLabels = new HashSet<String>();
        for (GraphNode graphNode : graphModel.getNodes()) {
            if (graphNode.getLabels().isEmpty()) {
                throw new HopException("No node labels found for node " + graphNode.getName());
            }
            for (String label2 : graphNode.getLabels()) {
                if (!nodeLabels.contains(label2)) continue;
                throw new HopException("Node label '" + label2 + "' is used more than once in model " + graphModel.getName());
            }
            label = graphNode.getLabels().get(0);
            if (graphModel.findNode(label) != null) {
                throw new HopException("A node named '" + label + "' already exists in the model. Renaming nodes might break consistency");
            }
            nodeLabels.add(label);
        }
        for (GraphNode graphNode : graphModel.getNodes()) {
            label = graphNode.getLabels().get(0);
            String oldName = graphNode.getName();
            graphNode.setName(label);
            for (GraphProperty property : graphNode.getProperties()) {
                property.setName(property.getDescription());
                property.setDescription(null);
            }
            for (GraphRelationship relationship : graphModel.getRelationships()) {
                if (relationship.getNodeSource().equals(oldName)) {
                    relationship.setNodeSource(label);
                }
                if (!relationship.getNodeTarget().equals(oldName)) continue;
                relationship.setNodeTarget(label);
            }
        }
        HashSet<String> relationshipLabels = new HashSet<String>();
        for (GraphRelationship relationship : graphModel.getRelationships()) {
            String label2;
            label2 = relationship.getLabel();
            if (StringUtils.isEmpty((String)label2)) {
                throw new HopException("No relationship label found for relationship between nodes: " + relationship.getNodeSource() + " and " + relationship.getNodeTarget());
            }
            if (graphModel.findRelationship(label2) != null) {
                throw new HopException("A relationship named '" + label2 + "' already exists in the model. Renaming relationships might break consistency");
            }
            relationshipLabels.add(label2);
        }
        for (GraphRelationship relationship : graphModel.getRelationships()) {
            relationship.setName(relationship.getLabel());
            relationship.setDescription(relationship.getNodeSource() + " - " + relationship.getNodeTarget());
            for (GraphProperty property : relationship.getProperties()) {
                property.setName(property.getDescription());
                property.setDescription(null);
            }
        }
        return graphModel;
    }
}

