/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.neo4j.model.GraphProperty;

public class GraphRelationship {
    @HopMetadataProperty
    protected String name;
    @HopMetadataProperty
    protected String description;
    @HopMetadataProperty
    protected String label;
    @HopMetadataProperty
    protected List<GraphProperty> properties;
    @HopMetadataProperty
    protected String nodeSource;
    @HopMetadataProperty
    protected String nodeTarget;

    public GraphRelationship() {
        this.properties = new ArrayList<GraphProperty>();
    }

    public GraphRelationship(String name, String description, String label, List<GraphProperty> properties, String nodeSource, String nodeTarget) {
        this.name = name;
        this.description = description;
        this.label = label;
        this.properties = properties;
        this.nodeSource = nodeSource;
        this.nodeTarget = nodeTarget;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof GraphRelationship)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return ((GraphRelationship)o).getName().equalsIgnoreCase(this.name);
    }

    public String toString() {
        return this.name == null ? super.toString() : this.name;
    }

    public GraphRelationship(GraphRelationship graphRelationship) {
        this();
        ArrayList<GraphProperty> properties = new ArrayList<GraphProperty>();
        for (GraphProperty property : graphRelationship.getProperties()) {
            properties.add(new GraphProperty(property));
        }
        this.setName(graphRelationship.getName());
        this.setDescription(graphRelationship.getDescription());
        this.setLabel(graphRelationship.getLabel());
        this.setProperties(properties);
        this.setNodeSource(graphRelationship.getNodeSource());
        this.setNodeTarget(graphRelationship.getNodeTarget());
    }

    public GraphProperty findProperty(String name) {
        for (GraphProperty property : this.properties) {
            if (!property.getName().equalsIgnoreCase(name)) continue;
            return property;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<GraphProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<GraphProperty> properties) {
        this.properties = properties;
    }

    public String getNodeSource() {
        return this.nodeSource;
    }

    public void setNodeSource(String nodeSource) {
        this.nodeSource = nodeSource;
    }

    public String getNodeTarget() {
        return this.nodeTarget;
    }

    public void setNodeTarget(String nodeTarget) {
        this.nodeTarget = nodeTarget;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

