/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.logging.util;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingHierarchy;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.neo4j.logging.util.WorkLambda;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.eclipse.swt.graphics.Rectangle;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.Node;

public class LoggingCore {
    public static final boolean isEnabled(IVariables space) {
        String connectionName = space.getVariable("NEO4J_LOGGING_CONNECTION");
        return StringUtils.isNotEmpty((String)connectionName) && !"-".equals(connectionName);
    }

    public static final NeoConnection getConnection(IHopMetadataProvider metadataProvider, IVariables space) throws HopException {
        String connectionName = space.getVariable("NEO4J_LOGGING_CONNECTION");
        if (StringUtils.isEmpty((String)connectionName)) {
            return null;
        }
        IHopMetadataSerializer serializer = metadataProvider.getSerializer(NeoConnection.class);
        NeoConnection connection = (NeoConnection)serializer.load(connectionName);
        return connection;
    }

    public static final void writeHierarchies(ILogChannel log, NeoConnection connection, Transaction transaction, List<LoggingHierarchy> hierarchies, String rootLogChannelId) {
        try {
            StringBuilder execCypher;
            HashMap<String, Object> execPars;
            ILoggingObject loggingObject;
            for (LoggingHierarchy hierarchy : hierarchies) {
                loggingObject = hierarchy.getLoggingObject();
                LogLevel logLevel = loggingObject.getLogLevel();
                execPars = new HashMap<String, Object>();
                execPars.put("name", loggingObject.getObjectName());
                execPars.put("type", loggingObject.getObjectType().name());
                execPars.put("copy", loggingObject.getObjectCopy());
                execPars.put("id", loggingObject.getLogChannelId());
                execPars.put("containerId", loggingObject.getContainerId());
                execPars.put("logLevel", logLevel != null ? logLevel.getCode() : null);
                execPars.put("root", loggingObject.getLogChannelId().equals(rootLogChannelId));
                execPars.put("registrationDate", new SimpleDateFormat("yyyy/MM/dd'T'HH:mm:ss").format(loggingObject.getRegistrationDate()));
                execCypher = new StringBuilder();
                execCypher.append("MERGE (e:Execution { name : $name, type : $type, id : $id } ) ");
                execCypher.append("SET ");
                execCypher.append("  e.containerId = $containerId ");
                execCypher.append(", e.logLevel = $logLevel ");
                execCypher.append(", e.copy = $copy ");
                execCypher.append(", e.registrationDate = $registrationDate ");
                execCypher.append(", e.root = $root ");
                Result run = transaction.run(execCypher.toString(), execPars);
                run.consume();
            }
            for (LoggingHierarchy hierarchy : hierarchies) {
                loggingObject = hierarchy.getLoggingObject();
                ILoggingObject parentObject = loggingObject.getParent();
                if (parentObject == null) continue;
                execPars = new HashMap();
                execPars.put("name", loggingObject.getObjectName());
                execPars.put("type", loggingObject.getObjectType().name());
                execPars.put("id", loggingObject.getLogChannelId());
                execPars.put("parentName", parentObject.getObjectName());
                execPars.put("parentType", parentObject.getObjectType().name());
                execPars.put("parentId", parentObject.getLogChannelId());
                execCypher = new StringBuilder();
                execCypher.append("MATCH (child:Execution { name : $name, type : $type, id : $id } ) ");
                execCypher.append("MATCH (parent:Execution { name : $parentName, type : $parentType, id : $parentId } ) ");
                execCypher.append("MERGE (parent)-[rel:EXECUTES]->(child) ");
                transaction.run(execCypher.toString(), execPars);
            }
            transaction.commit();
        }
        catch (Exception e) {
            log.logError("Error logging hierarchies", (Throwable)e);
            transaction.rollback();
        }
    }

    /*
     * Exception decompiling
     */
    public static <T> T executeCypher(ILogChannel log, IVariables variables, NeoConnection connection, String cypher, Map<String, Object> parameters, WorkLambda<T> lambda) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getStringValue(Record record, int i) {
        if (i >= record.size()) {
            return null;
        }
        Value value = record.get(i);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.asString();
    }

    public static Long getLongValue(Record record, int i) {
        if (i >= record.size()) {
            return null;
        }
        Value value = record.get(i);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.asLong();
    }

    public static Date getDateValue(Record record, int i) {
        if (i >= record.size()) {
            return null;
        }
        Value value = record.get(i);
        if (value == null || value.isNull()) {
            return null;
        }
        LocalDateTime localDateTime = value.asLocalDateTime();
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Boolean getBooleanValue(Record record, int i) {
        if (i >= record.size()) {
            return null;
        }
        Value value = record.get(i);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.asBoolean();
    }

    public static String getStringValue(Node node, String name) {
        Value value = node.get(name);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.asString();
    }

    public static Long getLongValue(Node node, String name) {
        Value value = node.get(name);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.asLong();
    }

    public static Boolean getBooleanValue(Node node, String name) {
        Value value = node.get(name);
        if (value == null || value.isNull()) {
            return null;
        }
        return value.asBoolean();
    }

    public static Date getDateValue(Node node, String name) {
        Value value = node.get(name);
        if (value == null || value.isNull()) {
            return null;
        }
        LocalDateTime localDateTime = value.asLocalDateTime();
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static double calculateRadius(Rectangle bounds) {
        double radius = (double)Math.min(bounds.width, bounds.height) * 0.8 / 2.0;
        return radius;
    }

    public static double calculateOptDistance(Rectangle bounds, int nrNodes) {
        if (nrNodes == 0) {
            return -1.0;
        }
        double radius = LoggingCore.calculateRadius(bounds);
        double circleLength = Math.PI * 2 * radius;
        double optDistance = 0.75 * circleLength / (double)(nrNodes * 2);
        return optDistance;
    }

    public static final List<LoggingHierarchy> getLoggingHierarchy(String logChannelId) {
        ArrayList<LoggingHierarchy> hierarchy = new ArrayList<LoggingHierarchy>();
        List childIds = LoggingRegistry.getInstance().getLogChannelChildren(logChannelId);
        for (String childId : childIds) {
            ILoggingObject loggingObject = LoggingRegistry.getInstance().getLoggingObject(childId);
            if (loggingObject == null) continue;
            hierarchy.add(new LoggingHierarchy(logChannelId, loggingObject));
        }
        return hierarchy;
    }

    public static final String getFancyDurationFromMs(Long durationMs) {
        if (durationMs == null) {
            return "";
        }
        double seconds = (double)durationMs.longValue() / 1000.0;
        return LoggingCore.getFancyDurationFromSeconds(seconds);
    }

    public static final String getFancyDurationFromSeconds(double seconds) {
        int day = (int)TimeUnit.SECONDS.toDays((long)seconds);
        long hours = TimeUnit.SECONDS.toHours((long)seconds) - (long)(day * 24);
        long minute = TimeUnit.SECONDS.toMinutes((long)seconds) - TimeUnit.SECONDS.toHours((long)seconds) * 60L;
        long second = TimeUnit.SECONDS.toSeconds((long)seconds) - TimeUnit.SECONDS.toMinutes((long)seconds) * 60L;
        long ms = (long)((seconds - (double)((long)seconds)) * 1000.0);
        StringBuilder hms = new StringBuilder();
        if (day > 0) {
            hms.append(day + "d ");
        }
        if (day > 0 || hours > 0L) {
            hms.append(hours + "h ");
        }
        if (day > 0 || hours > 0L || minute > 0L) {
            hms.append(String.format("%02d", minute) + "' ");
        }
        hms.append(String.format("%02d", second) + ".");
        hms.append(String.format("%03d", ms) + "\"");
        return hms.toString();
    }

    private static /* synthetic */ Object lambda$executeCypher$0(String cypher, Map parameters, WorkLambda lambda, Transaction tx) {
        Result result = tx.run(cypher, parameters);
        return lambda.getResultValue(result);
    }
}

