/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.actions.cypherscript;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.neo4j.actions.cypherscript.CypherScript;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CypherScriptDialog
extends ActionDialog
implements IActionDialog {
    private static Class<?> PKG = CypherScriptDialog.class;
    private Shell shell;
    private CypherScript cypherScript;
    private boolean changed;
    private Text wName;
    private MetaSelectionLine<NeoConnection> wConnection;
    private TextVar wScript;
    private Button wReplaceVariables;
    private Button wOk;
    private Button wCancel;

    public CypherScriptDialog(Shell parent, IAction iAction, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.cypherScript = (CypherScript)iAction;
        if (this.cypherScript.getName() == null) {
            this.cypherScript.setName(BaseMessages.getString(PKG, (String)"CypherScriptDialog.Action.Name", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.cypherScript);
        ModifyListener lsMod = e -> this.cypherScript.setChanged();
        this.changed = this.cypherScript.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CypherScriptDialog.Dialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"CypherScriptDialog.ActionName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Text lastControl = this.wName;
        this.wConnection = new MetaSelectionLine(this.variables, this.getMetadataProvider(), NeoConnection.class, (Composite)this.shell, 18436, BaseMessages.getString(PKG, (String)"CypherScriptDialog.NeoConnection.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CypherScriptDialog.NeoConnection.Tooltip", (String[])new String[0]));
        this.props.setLook(this.wConnection);
        this.wConnection.addModifyListener(lsMod);
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment(100, 0);
        fdConnection.top = new FormAttachment((Control)lastControl, margin);
        this.wConnection.setLayoutData((Object)fdConnection);
        try {
            this.wConnection.fillItems();
        }
        catch (Exception e2) {
            new ErrorDialog(this.shell, "Error", "Error getting list of connections", e2);
        }
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        Label wlReplaceVariables = new Label((Composite)this.shell, 16384);
        wlReplaceVariables.setText(BaseMessages.getString(PKG, (String)"CypherScriptDialog.ReplaceVariables.Label", (String[])new String[0]));
        this.props.setLook((Control)wlReplaceVariables);
        FormData fdlReplaceVariables = new FormData();
        fdlReplaceVariables.left = new FormAttachment(0, 0);
        fdlReplaceVariables.right = new FormAttachment(middle, -margin);
        fdlReplaceVariables.bottom = new FormAttachment((Control)this.wOk, -margin * 2);
        wlReplaceVariables.setLayoutData((Object)fdlReplaceVariables);
        this.wReplaceVariables = new Button((Composite)this.shell, 2080);
        this.props.setLook((Control)this.wReplaceVariables);
        FormData fdReplaceVariables = new FormData();
        fdReplaceVariables.left = new FormAttachment(middle, 0);
        fdReplaceVariables.right = new FormAttachment(100, 0);
        fdReplaceVariables.top = new FormAttachment((Control)wlReplaceVariables, 0, 0x1000000);
        this.wReplaceVariables.setLayoutData((Object)fdReplaceVariables);
        Label wlScript = new Label((Composite)this.shell, 16384);
        wlScript.setText(BaseMessages.getString(PKG, (String)"CypherScriptDialog.CypherScript.Label", (String[])new String[0]));
        this.props.setLook((Control)wlScript);
        FormData fdlCypher = new FormData();
        fdlCypher.left = new FormAttachment(0, 0);
        fdlCypher.right = new FormAttachment(100, 0);
        fdlCypher.top = new FormAttachment(this.wConnection, margin);
        wlScript.setLayoutData((Object)fdlCypher);
        this.wScript = new TextVar(this.variables, (Composite)this.shell, 19202);
        this.wScript.getTextWidget().setFont(GuiResource.getInstance().getFontFixed());
        this.props.setLook((Control)this.wScript);
        this.wScript.addModifyListener(lsMod);
        FormData fdCypher = new FormData();
        fdCypher.left = new FormAttachment(0, 0);
        fdCypher.right = new FormAttachment(100, 0);
        fdCypher.top = new FormAttachment((Control)wlScript, margin);
        fdCypher.bottom = new FormAttachment((Control)this.wReplaceVariables, -margin * 2);
        this.wScript.setLayoutData((Object)fdCypher);
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)margin, null);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.cypherScript;
    }

    private void cancel() {
        this.cypherScript.setChanged(this.changed);
        this.cypherScript = null;
        this.dispose();
    }

    private void getData() {
        this.wName.setText(Const.NVL((String)this.cypherScript.getName(), (String)""));
        this.wConnection.setText(Const.NVL((String)this.cypherScript.getConnectionName(), (String)""));
        this.wScript.setText(Const.NVL((String)this.cypherScript.getScript(), (String)""));
        this.wReplaceVariables.setSelection(this.cypherScript.isReplacingVariables());
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"CypherScriptDialog.MissingName.Warning.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"CypherScriptDialog.MissingName.Warning.Message", (String[])new String[0]));
            mb.open();
            return;
        }
        this.cypherScript.setName(this.wName.getText());
        this.cypherScript.setConnectionName(this.wConnection.getText());
        this.cypherScript.setScript(this.wScript.getText());
        this.cypherScript.setReplacingVariables(this.wReplaceVariables.getSelection());
        this.dispose();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }
}

