/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.actions.constraint;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.neo4j.actions.constraint.ConstraintType;
import org.apache.hop.neo4j.actions.constraint.ConstraintUpdate;
import org.apache.hop.neo4j.actions.constraint.Neo4jConstraint;
import org.apache.hop.neo4j.actions.constraint.ObjectType;
import org.apache.hop.neo4j.actions.constraint.UpdateType;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class Neo4jConstraintDialog
extends ActionDialog
implements IActionDialog {
    private static Class<?> PKG = Neo4jConstraintDialog.class;
    private Shell shell;
    private Neo4jConstraint meta;
    private boolean changed;
    private Text wName;
    private MetaSelectionLine<NeoConnection> wConnection;
    private TableView wUpdates;
    private Button wCancel;

    public Neo4jConstraintDialog(Shell parent, IAction iAction, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.meta = (Neo4jConstraint)iAction;
        if (this.meta.getName() == null) {
            this.meta.setName(BaseMessages.getString(PKG, (String)"Neo4jConstraintDialog.Action.Name", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.meta);
        ModifyListener lsMod = e -> this.meta.setChanged();
        this.changed = this.meta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"Neo4jConstraintDialog.Dialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"Neo4jConstraintDialog.ActionName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Text lastControl = this.wName;
        this.wConnection = new MetaSelectionLine(this.variables, this.getMetadataProvider(), NeoConnection.class, (Composite)this.shell, 18436, BaseMessages.getString(PKG, (String)"Neo4jConstraintDialog.NeoConnection.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Neo4jConstraintDialog.NeoConnection.Tooltip", (String[])new String[0]));
        this.props.setLook(this.wConnection);
        this.wConnection.addModifyListener(lsMod);
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment(100, 0);
        fdConnection.top = new FormAttachment((Control)lastControl, margin);
        this.wConnection.setLayoutData((Object)fdConnection);
        try {
            this.wConnection.fillItems();
        }
        catch (Exception e2) {
            new ErrorDialog(this.shell, "Error", "Error getting list of connections", e2);
        }
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        Label wlUpdates = new Label((Composite)this.shell, 16384);
        wlUpdates.setText(BaseMessages.getString(PKG, (String)"Neo4jConstraintDialog.ConstraintUpdates.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUpdates);
        FormData fdlCypher = new FormData();
        fdlCypher.left = new FormAttachment(0, 0);
        fdlCypher.right = new FormAttachment(100, 0);
        fdlCypher.top = new FormAttachment(this.wConnection, margin);
        wlUpdates.setLayoutData((Object)fdlCypher);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jConstraintDialog.ConstraintUpdates.Column.UpdateType", (String[])new String[0]), 2, UpdateType.getNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jConstraintDialog.ConstraintUpdates.Column.ObjectType", (String[])new String[0]), 2, ObjectType.getNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jConstraintDialog.ConstraintUpdates.Column.ConstraintType", (String[])new String[0]), 2, ConstraintType.getNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jConstraintDialog.ConstraintUpdates.Column.ConstraintName", (String[])new String[0]), 1), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jConstraintDialog.ConstraintUpdates.Column.ObjectName", (String[])new String[0]), 1), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jConstraintDialog.ConstraintUpdates.Column.ObjectProperties", (String[])new String[0]), 1)};
        this.wUpdates = new TableView(this.variables, (Composite)this.shell, 0, columns, this.meta.getConstraintUpdates().size(), false, null, this.props);
        this.props.setLook((Control)this.wUpdates);
        this.wUpdates.addModifyListener(lsMod);
        FormData fdCypher = new FormData();
        fdCypher.left = new FormAttachment(0, 0);
        fdCypher.right = new FormAttachment(100, 0);
        fdCypher.top = new FormAttachment((Control)wlUpdates, margin);
        fdCypher.bottom = new FormAttachment((Control)wOk, -margin * 2);
        this.wUpdates.setLayoutData((Object)fdCypher);
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, this.wCancel}, (int)margin, null);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.meta;
    }

    private void cancel() {
        this.meta.setChanged(this.changed);
        this.meta = null;
        this.dispose();
    }

    private void getData() {
        this.wName.setText(Const.NVL((String)this.meta.getName(), (String)""));
        if (this.meta.getConnection() != null) {
            this.wConnection.setText(Const.NVL((String)this.meta.getConnection().getName(), (String)""));
        }
        for (int i = 0; i < this.meta.getConstraintUpdates().size(); ++i) {
            TableItem item = this.wUpdates.table.getItem(i);
            ConstraintUpdate constraintUpdate = this.meta.getConstraintUpdates().get(i);
            if (constraintUpdate.getUpdateType() != null) {
                item.setText(1, constraintUpdate.getUpdateType().name());
            }
            if (constraintUpdate.getObjectType() != null) {
                item.setText(2, constraintUpdate.getObjectType().name());
            }
            if (constraintUpdate.getConstraintType() != null) {
                item.setText(3, constraintUpdate.getConstraintType().name());
            }
            item.setText(4, Const.NVL((String)constraintUpdate.getConstraintName(), (String)""));
            item.setText(5, Const.NVL((String)constraintUpdate.getObjectName(), (String)""));
            item.setText(6, Const.NVL((String)constraintUpdate.getObjectProperties(), (String)""));
        }
        this.wUpdates.optimizeTableView();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"Neo4jConstraintDialog.MissingName.Warning.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"Neo4jConstraintDialog.MissingName.Warning.Message", (String[])new String[0]));
            mb.open();
            return;
        }
        this.meta.setName(this.wName.getText());
        String connectionName = this.wConnection.getText();
        if (StringUtils.isEmpty((String)connectionName)) {
            this.meta.setConnection(null);
        } else {
            try {
                this.meta.setConnection((NeoConnection)this.metadataProvider.getSerializer(NeoConnection.class).load(connectionName));
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error finding connection " + connectionName, e);
                return;
            }
        }
        List items = this.wUpdates.getNonEmptyItems();
        this.meta.getConstraintUpdates().clear();
        for (TableItem item : items) {
            UpdateType type = UpdateType.getType(item.getText(1));
            ObjectType objectType = ObjectType.getType(item.getText(2));
            ConstraintType constraintType = ConstraintType.getType(item.getText(3));
            String constraintName = item.getText(4);
            String objectName = item.getText(5);
            String objectProperties = item.getText(6);
            this.meta.getConstraintUpdates().add(new ConstraintUpdate(type, objectType, constraintType, constraintName, objectName, objectProperties));
        }
        this.dispose();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }
}

