/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.actions.check;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.w3c.dom.Node;

@Action(id="NEO4J_CHECK_CONNECTIONS", name="Check Neo4j Connections", description="Check to see if we can connect to the listed Neo4j databases", image="neo4j_check.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", documentationUrl="/workflow/actions/neo4j-checkconnections.html")
public class CheckConnections
extends ActionBase
implements IAction {
    private List<String> connectionNames = new ArrayList<String>();

    public CheckConnections() {
    }

    public CheckConnections(String name) {
        this(name, "");
    }

    public CheckConnections(String name, String description) {
        super(name, description);
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder();
        xml.append(super.getXml());
        xml.append(XmlHandler.openTag((String)"connections"));
        for (String connectionName : this.connectionNames) {
            xml.append(XmlHandler.addTagValue((String)"connection", (String)connectionName));
        }
        xml.append(XmlHandler.closeTag((String)"connections"));
        return xml.toString();
    }

    public void loadXml(Node node, IHopMetadataProvider iHopMetadataProvider, IVariables iVariables) throws HopXmlException {
        super.loadXml(node);
        this.connectionNames = new ArrayList<String>();
        Node connectionsNode = XmlHandler.getSubNode((Node)node, (String)"connections");
        List connectionNodes = XmlHandler.getNodes((Node)connectionsNode, (String)"connection");
        for (Node connectionNode : connectionNodes) {
            String connectionName = XmlHandler.getNodeValue((Node)connectionNode);
            this.connectionNames.add(connectionName);
        }
    }

    public Result execute(Result result, int nr) throws HopException {
        IHopMetadataSerializer serializer = this.getMetadataProvider().getSerializer(NeoConnection.class);
        ArrayList<String> realConnectionNames = new ArrayList<String>();
        for (String connectionName : this.connectionNames) {
            realConnectionNames.add(this.resolve(connectionName));
        }
        int testCount = 0;
        for (String connectionName : realConnectionNames) {
            ++testCount;
            try {
                NeoConnection connection = (NeoConnection)serializer.load(connectionName);
                if (connection == null) {
                    throw new HopException("Unable to find connection with name '" + connectionName + "'");
                }
                connection.test((IVariables)this);
            }
            catch (Exception e) {
                result.increaseErrors(1L);
                result.setResult(false);
                this.logError("Error on connection: " + connectionName, e);
            }
        }
        if (result.getNrErrors() == 0L) {
            this.logBasic(testCount + " Neo4j connections tested without error");
        } else {
            this.logBasic(testCount + " Neo4j connections tested with " + result.getNrErrors() + " error(s)");
        }
        return result;
    }

    public String getDialogClassName() {
        return super.getDialogClassName();
    }

    public List<String> getConnectionNames() {
        return this.connectionNames;
    }

    public void setConnectionNames(List<String> connectionNames) {
        this.connectionNames = connectionNames;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }
}

