/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sasinput;

import com.epam.parso.Column;
import com.epam.parso.ColumnFormat;
import com.epam.parso.SasFileProperties;
import com.epam.parso.impl.SasFileReaderImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sasinput.SasInputData;
import org.apache.hop.pipeline.transforms.sasinput.SasInputField;
import org.apache.hop.pipeline.transforms.sasinput.SasInputMeta;

public class SasInput
extends BaseTransform<SasInputMeta, SasInputData>
implements ITransform<SasInputMeta, SasInputData> {
    private static final Class<?> PKG = SasInputMeta.class;

    public SasInput(TransformMeta stepMeta, SasInputMeta meta, SasInputData data, int copyNr, PipelineMeta transMeta, Pipeline pipeline) {
        super(stepMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, transMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] fileRowData = this.getRow();
        if (fileRowData == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            ((SasInputData)this.data).outputRowMeta = new RowMeta();
            int idx = this.getInputRowMeta().indexOfValue(((SasInputMeta)this.meta).getAcceptingField());
            if (idx < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SASInput.Log.Error.UnableToFindFilenameField", (String[])new String[]{((SasInputMeta)this.meta).getAcceptingField()}));
            }
            ((SasInputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((SasInputMeta)this.meta).getFields(((SasInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        }
        String rawFilename = this.getInputRowMeta().getString(fileRowData, ((SasInputMeta)this.meta).getAcceptingField(), null);
        String filename = this.resolve(rawFilename);
        ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)filename), this.getPipelineMeta().getName(), this.getTransformName());
        resultFile.setComment(BaseMessages.getString(PKG, (String)"SASInput.ResultFile.Comment", (String[])new String[0]));
        this.addResultFile(resultFile);
        try (InputStream inputStream = HopVfs.getInputStream((String)filename);){
            Object[] sasRow;
            SasFileReaderImpl sasFileReader = new SasFileReaderImpl(inputStream);
            SasFileProperties sasFileProperties = sasFileReader.getSasFileProperties();
            this.logBasic(BaseMessages.getString(PKG, (String)"SASInput.Log.OpenedSASFile", (String[])new String[0]) + " : [" + filename + "]");
            List columns = sasFileReader.getColumns();
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (SasInputField field : ((SasInputMeta)this.meta).getOutputFields()) {
                int index = -1;
                for (int c = 0; c < columns.size(); ++c) {
                    if (!((Column)columns.get(c)).getName().equalsIgnoreCase(field.getName())) continue;
                    index = c;
                    break;
                }
                if (index < 0) {
                    throw new HopException("Field '" + field.getName() + " could not be found in input file '" + filename);
                }
                indexes.add(index);
            }
            while ((sasRow = sasFileReader.readNext()) != null) {
                Object[] outputRow = RowDataUtil.createResizedCopy((Object[])fileRowData, (int)((SasInputData)this.data).outputRowMeta.size());
                for (int i = 0; i < ((SasInputMeta)this.meta).getOutputFields().size(); ++i) {
                    SasInputField field = ((SasInputMeta)this.meta).getOutputFields().get(i);
                    int index = (Integer)indexes.get(i);
                    Column column = (Column)columns.get(index);
                    ColumnFormat columnFormat = column.getFormat();
                    Object sasValue = sasRow[index];
                    Object value = null;
                    ValueMetaString inputValueMeta = null;
                    String fieldName = Const.NVL((String)field.getRename(), (String)field.getName());
                    int outputIndex = this.getInputRowMeta().size() + i;
                    if (sasValue instanceof byte[]) {
                        inputValueMeta = new ValueMetaString(fieldName);
                        value = sasFileProperties.getEncoding() != null ? new String((byte[])sasValue, sasFileProperties.getEncoding()) : new String((byte[])sasValue);
                    }
                    if (sasValue instanceof String) {
                        inputValueMeta = new ValueMetaString(fieldName);
                        value = sasValue;
                    }
                    if (sasValue instanceof Double) {
                        inputValueMeta = new ValueMetaNumber(fieldName);
                        value = sasValue;
                    }
                    if (sasValue instanceof Float) {
                        inputValueMeta = new ValueMetaNumber(fieldName);
                        value = (double)((Double)sasValue);
                    }
                    if (sasValue instanceof Long) {
                        inputValueMeta = new ValueMetaInteger(fieldName);
                        value = sasValue;
                    }
                    if (sasValue instanceof Integer) {
                        inputValueMeta = new ValueMetaInteger(fieldName);
                        value = (long)((Integer)sasValue).intValue();
                    }
                    if (sasValue instanceof Date) {
                        inputValueMeta = new ValueMetaDate(fieldName);
                        value = sasValue;
                    }
                    if (inputValueMeta == null) continue;
                    inputValueMeta.setLength(field.getLength());
                    inputValueMeta.setPrecision(field.getPrecision());
                    inputValueMeta.setConversionMask(field.getConversionMask());
                    IValueMeta outputValueMeta = ((SasInputData)this.data).outputRowMeta.getValueMeta(outputIndex);
                    outputRow[outputIndex] = outputValueMeta.convertData((IValueMeta)inputValueMeta, value);
                }
                this.putRow(((SasInputData)this.data).outputRowMeta, outputRow);
            }
        }
        catch (Exception e) {
            throw new HopException("Error reading from file " + filename, (Throwable)e);
        }
        return true;
    }
}

