/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class ExecutionOptions {
    public static final ConfigOption<Boolean> SNAPSHOT_COMPRESSION = ConfigOptions.key("execution.checkpointing.snapshot-compression").booleanType().defaultValue(false).withDescription("Tells if we should use compression for the state snapshot data or not");
    public static final ConfigOption<Duration> BUFFER_TIMEOUT = ConfigOptions.key("execution.buffer-timeout").durationType().defaultValue(Duration.ofMillis(100L)).withDescription(Description.builder().text("The maximum time frequency (milliseconds) for the flushing of the output buffers. By default the output buffers flush frequently to provide low latency and to aid smooth developer experience. Setting the parameter can result in three logical modes:").list(TextElement.text("A positive value triggers flushing periodically by that interval"), TextElement.text("0 triggers flushing after every record thus minimizing latency"), TextElement.text("-1 ms triggers flushing only when the output buffer is full thus maximizing throughput")).build());
}

