/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.resources;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class Resource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final BigDecimal value;

    protected Resource(String name, double value) {
        this(name, BigDecimal.valueOf(value));
    }

    protected Resource(String name, BigDecimal value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(value.compareTo(BigDecimal.ZERO) >= 0, "Resource value must be no less than 0");
        this.name = Preconditions.checkNotNull(name);
        this.value = value;
    }

    public Resource merge(Resource other) {
        Preconditions.checkNotNull(other, "Cannot merge with null resources");
        Preconditions.checkArgument(this.getClass() == other.getClass(), "Merge with different resource type");
        Preconditions.checkArgument(this.name.equals(other.name), "Merge with different resource name");
        return this.create(this.value.add(other.value));
    }

    public Resource subtract(Resource other) {
        Preconditions.checkNotNull(other, "Cannot subtract null resources");
        Preconditions.checkArgument(this.getClass() == other.getClass(), "Minus with different resource type");
        Preconditions.checkArgument(this.name.equals(other.name), "Minus with different resource name");
        Preconditions.checkArgument(this.value.compareTo(other.value) >= 0, "Try to subtract a larger resource from this one.");
        return this.create(this.value.subtract(other.value));
    }

    public Resource multiply(BigDecimal multiplier) {
        return this.create(this.value.multiply(multiplier));
    }

    public Resource multiply(int multiplier) {
        return this.multiply(BigDecimal.valueOf(multiplier));
    }

    public Resource divide(BigDecimal by) {
        return this.create(this.value.divide(by, 16, RoundingMode.DOWN));
    }

    public Resource divide(int by) {
        return this.divide(BigDecimal.valueOf(by));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            Resource other = (Resource)o;
            return this.name.equals(other.name) && this.value.compareTo(other.value) == 0;
        }
        return false;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return String.format("Resource(%s: %s)", this.name, this.value);
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    protected abstract Resource create(BigDecimal var1);
}

