/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.functions.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.api.common.accumulators.DoubleCounter;
import org.apache.flink.api.common.accumulators.Histogram;
import org.apache.flink.api.common.accumulators.IntCounter;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.AggregatingState;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.core.fs.Path;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class AbstractRuntimeUDFContext
implements RuntimeContext {
    private final TaskInfo taskInfo;
    private final ClassLoader userCodeClassLoader;
    private final ExecutionConfig executionConfig;
    private final Map<String, Accumulator<?, ?>> accumulators;
    private final DistributedCache distributedCache;
    private final MetricGroup metrics;

    public AbstractRuntimeUDFContext(TaskInfo taskInfo, ClassLoader userCodeClassLoader, ExecutionConfig executionConfig, Map<String, Accumulator<?, ?>> accumulators, Map<String, Future<Path>> cpTasks, MetricGroup metrics) {
        this.taskInfo = Preconditions.checkNotNull(taskInfo);
        this.userCodeClassLoader = userCodeClassLoader;
        this.executionConfig = executionConfig;
        this.distributedCache = new DistributedCache(Preconditions.checkNotNull(cpTasks));
        this.accumulators = Preconditions.checkNotNull(accumulators);
        this.metrics = metrics;
    }

    @Override
    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    @Override
    public String getTaskName() {
        return this.taskInfo.getTaskName();
    }

    @Override
    public int getNumberOfParallelSubtasks() {
        return this.taskInfo.getNumberOfParallelSubtasks();
    }

    @Override
    public int getMaxNumberOfParallelSubtasks() {
        return this.taskInfo.getMaxNumberOfParallelSubtasks();
    }

    @Override
    public int getIndexOfThisSubtask() {
        return this.taskInfo.getIndexOfThisSubtask();
    }

    @Override
    public MetricGroup getMetricGroup() {
        return this.metrics;
    }

    @Override
    public int getAttemptNumber() {
        return this.taskInfo.getAttemptNumber();
    }

    @Override
    public String getTaskNameWithSubtasks() {
        return this.taskInfo.getTaskNameWithSubtasks();
    }

    @Override
    public IntCounter getIntCounter(String name) {
        return (IntCounter)this.getAccumulator(name, IntCounter.class);
    }

    @Override
    public LongCounter getLongCounter(String name) {
        return (LongCounter)this.getAccumulator(name, LongCounter.class);
    }

    @Override
    public Histogram getHistogram(String name) {
        return (Histogram)this.getAccumulator(name, Histogram.class);
    }

    @Override
    public DoubleCounter getDoubleCounter(String name) {
        return (DoubleCounter)this.getAccumulator(name, DoubleCounter.class);
    }

    @Override
    public <V, A extends Serializable> void addAccumulator(String name, Accumulator<V, A> accumulator) {
        if (this.accumulators.containsKey(name)) {
            throw new UnsupportedOperationException("The accumulator '" + name + "' already exists and cannot be added.");
        }
        this.accumulators.put(name, accumulator);
    }

    @Override
    public <V, A extends Serializable> Accumulator<V, A> getAccumulator(String name) {
        return this.accumulators.get(name);
    }

    @Override
    public Map<String, Accumulator<?, ?>> getAllAccumulators() {
        return Collections.unmodifiableMap(this.accumulators);
    }

    @Override
    public ClassLoader getUserCodeClassLoader() {
        return this.userCodeClassLoader;
    }

    @Override
    public DistributedCache getDistributedCache() {
        return this.distributedCache;
    }

    private <V, A extends Serializable> Accumulator<V, A> getAccumulator(String name, Class<? extends Accumulator<V, A>> accumulatorClass) {
        Accumulator<Object, Object> accumulator = this.accumulators.get(name);
        if (accumulator != null) {
            AccumulatorHelper.compareAccumulatorTypes(name, accumulator.getClass(), accumulatorClass);
        } else {
            try {
                accumulator = accumulatorClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create accumulator " + accumulatorClass.getName());
            }
            this.accumulators.put(name, accumulator);
        }
        return accumulator;
    }

    @Override
    @PublicEvolving
    public <T> ValueState<T> getState(ValueStateDescriptor<T> stateProperties) {
        throw new UnsupportedOperationException("This state is only accessible by functions executed on a KeyedStream");
    }

    @Override
    @PublicEvolving
    public <T> ListState<T> getListState(ListStateDescriptor<T> stateProperties) {
        throw new UnsupportedOperationException("This state is only accessible by functions executed on a KeyedStream");
    }

    @Override
    @PublicEvolving
    public <T> ReducingState<T> getReducingState(ReducingStateDescriptor<T> stateProperties) {
        throw new UnsupportedOperationException("This state is only accessible by functions executed on a KeyedStream");
    }

    @Override
    @PublicEvolving
    public <IN, ACC, OUT> AggregatingState<IN, OUT> getAggregatingState(AggregatingStateDescriptor<IN, ACC, OUT> stateProperties) {
        throw new UnsupportedOperationException("This state is only accessible by functions executed on a KeyedStream");
    }

    @Override
    @PublicEvolving
    public <UK, UV> MapState<UK, UV> getMapState(MapStateDescriptor<UK, UV> stateProperties) {
        throw new UnsupportedOperationException("This state is only accessible by functions executed on a KeyedStream");
    }

    @Internal
    @VisibleForTesting
    public String getAllocationIDAsString() {
        return this.taskInfo.getAllocationIDAsString();
    }
}

