/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.addsequence;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.addsequence.AddSequence;
import org.apache.hop.pipeline.transforms.addsequence.AddSequenceData;

@Transform(id="Sequence", image="addsequence.svg", name="i18n::BaseTransform.TypeLongDesc.AddSequence", description="i18n::BaseTransform.TypeTooltipDesc.AddSequence", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", documentationUrl="/pipeline/transforms/addsequence.html", keywords={"id", "unique"})
public class AddSequenceMeta
extends BaseTransformMeta
implements ITransformMeta<AddSequence, AddSequenceData> {
    private static final Class<?> PKG = AddSequenceMeta.class;
    @HopMetadataProperty(key="valuename", injectionKeyDescription="AddSequenceDialog.Valuename.Label")
    private String valueName;
    @HopMetadataProperty(key="use_database", injectionKeyDescription="AddSequenceDialog.UseDatabase.Label")
    private boolean databaseUsed;
    @HopMetadataProperty(key="connection", storeWithName=true, injectionKeyDescription="AddSequenceMeta.Injection.Connection")
    private DatabaseMeta databaseMeta;
    @HopMetadataProperty(key="schema", injectionKeyDescription="AddSequenceMeta.Injection.SchemaName")
    private String schemaName;
    @HopMetadataProperty(key="seqname", injectionKeyDescription="AddSequenceMeta.Injection.SequenceName")
    private String sequenceName;
    @HopMetadataProperty(key="use_counter", injectionKeyDescription="AddSequenceMeta.Injection.UseCounter")
    private boolean counterUsed;
    @HopMetadataProperty(key="counter_name", injectionKeyDescription="AddSequenceMeta.Injection.CounterName")
    private String counterName;
    @HopMetadataProperty(key="start_at", injectionKeyDescription="AddSequenceMeta.Injection.StartAt")
    private String startAt;
    @HopMetadataProperty(key="increment_by", injectionKeyDescription="AddSequenceMeta.Injection.IncrementBy")
    private String incrementBy;
    @HopMetadataProperty(key="max_value", injectionKeyDescription="AddSequenceMeta.Injection.MaxValue")
    private String maxValue;

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta connection) {
        this.databaseMeta = connection;
    }

    public String getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(String incrementBy) {
        this.incrementBy = incrementBy;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = Long.toString(maxValue);
    }

    public void setStartAt(long startAt) {
        this.startAt = Long.toString(startAt);
    }

    public void setIncrementBy(long incrementBy) {
        this.incrementBy = Long.toString(incrementBy);
    }

    public String getStartAt() {
        return this.startAt;
    }

    public void setStartAt(String startAt) {
        this.startAt = startAt;
    }

    public boolean isCounterUsed() {
        return this.counterUsed;
    }

    public void setCounterUsed(boolean counterUsed) {
        this.counterUsed = counterUsed;
    }

    public boolean isDatabaseUsed() {
        return this.databaseUsed;
    }

    public void setDatabaseUsed(boolean databaseUsed) {
        this.databaseUsed = databaseUsed;
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void setDefault() {
        this.valueName = "valuename";
        this.databaseUsed = false;
        this.schemaName = "";
        this.sequenceName = "SEQ_";
        this.databaseMeta = null;
        this.counterUsed = true;
        this.counterName = null;
        this.startAt = "1";
        this.incrementBy = "1";
        this.maxValue = "999999999";
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaInteger v = new ValueMetaInteger(this.valueName);
        v.setOrigin(name);
        row.addValueMeta((IValueMeta)v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (this.databaseUsed) {
            Database db = new Database(loggingObject, variables, this.databaseMeta);
            try {
                db.connect();
                cr = db.checkSequenceExists(variables.resolve(this.schemaName), variables.resolve(this.sequenceName)) ? new CheckResult(1, BaseMessages.getString(PKG, (String)"AddSequenceMeta.CheckResult.SequenceExists.Title", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"AddSequenceMeta.CheckResult.SequenceCouldNotBeFound.Title", (String[])new String[]{this.sequenceName}), (ICheckResultSource)transformMeta);
            }
            catch (HopException e) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AddSequenceMeta.CheckResult.UnableToConnectDB.Title", (String[])new String[0]) + Const.CR + e.getMessage(), (ICheckResultSource)transformMeta);
            }
            finally {
                db.disconnect();
            }
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AddSequenceMeta.CheckResult.TransformIsReceving.Title", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AddSequenceMeta.CheckResult.NoInputReceived.Title", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) {
        SqlStatement retval = new SqlStatement(transformMeta.getName(), this.databaseMeta, null);
        if (this.databaseUsed) {
            if (this.databaseMeta != null) {
                Database db = new Database(loggingObject, variables, this.databaseMeta);
                try {
                    db.connect();
                    if (!db.checkSequenceExists(this.schemaName, this.sequenceName)) {
                        String crTable = db.getCreateSequenceStatement(this.sequenceName, this.startAt, this.incrementBy, this.maxValue, true);
                        retval.setSql(crTable);
                    }
                    retval.setSql(null);
                }
                catch (HopException e) {
                    retval.setError(BaseMessages.getString(PKG, (String)"AddSequenceMeta.ErrorMessage.UnableToConnectDB", (String[])new String[0]) + Const.CR + e.getMessage());
                }
                finally {
                    db.disconnect();
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"AddSequenceMeta.ErrorMessage.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    public AddSequence createTransform(TransformMeta transformMeta, AddSequenceData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new AddSequence(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public AddSequenceData getTransformData() {
        return new AddSequenceData();
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public String getCounterName() {
        return this.counterName;
    }

    public void setCounterName(String counterName) {
        this.counterName = counterName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }
}

