/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.addsequence;

import org.apache.hop.core.Counter;
import org.apache.hop.core.Counters;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.addsequence.AddSequenceData;
import org.apache.hop.pipeline.transforms.addsequence.AddSequenceMeta;

public class AddSequence
extends BaseTransform<AddSequenceMeta, AddSequenceData>
implements ITransform<AddSequenceMeta, AddSequenceData> {
    private static final Class<?> PKG = AddSequence.class;

    public AddSequence(TransformMeta transformMeta, AddSequenceMeta meta, AddSequenceData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public synchronized Object[] addSequence(IRowMeta inputRowMeta, Object[] inputRowData) throws HopException {
        Long next;
        if (((AddSequenceMeta)this.meta).isCounterUsed()) {
            next = ((AddSequenceData)this.data).counter.getAndNext();
        } else if (((AddSequenceMeta)this.meta).isDatabaseUsed()) {
            try {
                next = ((AddSequenceData)this.data).getDb().getNextSequenceValue(((AddSequenceData)this.data).realSchemaName, ((AddSequenceData)this.data).realSequenceName, ((AddSequenceMeta)this.meta).getValueName());
            }
            catch (HopDatabaseException dbe) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"AddSequence.Exception.ErrorReadingSequence", (String[])new String[]{((AddSequenceData)this.data).realSequenceName}), (Throwable)dbe);
            }
        } else {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"AddSequence.Exception.NoSpecifiedMethod", (String[])new String[0]));
        }
        if (next != null) {
            Object[] outputRowData = inputRowData;
            if (inputRowData.length < inputRowMeta.size() + 1) {
                outputRowData = RowDataUtil.resizeArray((Object[])inputRowData, (int)(inputRowMeta.size() + 1));
            }
            outputRowData[inputRowMeta.size()] = next;
            return outputRowData;
        }
        throw new HopTransformException(BaseMessages.getString(PKG, (String)"AddSequence.Exception.CouldNotFindNextValueForSequence", (String[])new String[0]) + ((AddSequenceMeta)this.meta).getValueName());
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((AddSequenceData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((AddSequenceMeta)this.meta).getFields(((AddSequenceData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"AddSequence.Log.ReadRow", (String[])new String[0]) + this.getLinesRead() + " : " + this.getInputRowMeta().getString(r));
        }
        try {
            this.putRow(((AddSequenceData)this.data).outputRowMeta, this.addSequence(this.getInputRowMeta(), r));
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"AddSequence.Log.WriteRow", (String[])new String[0]) + this.getLinesWritten() + " : " + this.getInputRowMeta().getString(r));
            }
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"AddSequence.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
            }
        }
        catch (HopException e) {
            this.logError(BaseMessages.getString(PKG, (String)"AddSequence.Log.ErrorInTransform", (String[])new String[0]) + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        if (super.init()) {
            ((AddSequenceData)this.data).realSchemaName = this.resolve(((AddSequenceMeta)this.meta).getSchemaName());
            ((AddSequenceData)this.data).realSequenceName = this.resolve(((AddSequenceMeta)this.meta).getSequenceName());
            if (((AddSequenceMeta)this.meta).isDatabaseUsed()) {
                Database db = new Database((ILoggingObject)this, (IVariables)this, ((AddSequenceMeta)this.meta).getDatabaseMeta());
                ((AddSequenceData)this.data).setDb(db);
                try {
                    ((AddSequenceData)this.data).getDb().connect();
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"AddSequence.Log.ConnectedDB", (String[])new String[0]));
                    }
                    return true;
                }
                catch (HopDatabaseException dbe) {
                    this.logError(BaseMessages.getString(PKG, (String)"AddSequence.Log.CouldNotConnectToDB", (String[])new String[0]) + dbe.getMessage());
                }
            } else {
                if (((AddSequenceMeta)this.meta).isCounterUsed()) {
                    boolean doAbort = false;
                    try {
                        ((AddSequenceData)this.data).start = Long.parseLong(this.resolve(((AddSequenceMeta)this.meta).getStartAt()));
                    }
                    catch (NumberFormatException ex) {
                        this.logError(BaseMessages.getString(PKG, (String)"AddSequence.Log.CouldNotParseCounterValue", (String[])new String[]{"start", ((AddSequenceMeta)this.meta).getStartAt(), this.resolve(((AddSequenceMeta)this.meta).getStartAt()), ex.getMessage()}));
                        doAbort = true;
                    }
                    try {
                        ((AddSequenceData)this.data).increment = Long.parseLong(this.resolve(((AddSequenceMeta)this.meta).getIncrementBy()));
                    }
                    catch (NumberFormatException ex) {
                        this.logError(BaseMessages.getString(PKG, (String)"AddSequence.Log.CouldNotParseCounterValue", (String[])new String[]{"increment", ((AddSequenceMeta)this.meta).getIncrementBy(), this.resolve(((AddSequenceMeta)this.meta).getIncrementBy()), ex.getMessage()}));
                        doAbort = true;
                    }
                    try {
                        ((AddSequenceData)this.data).maximum = Long.parseLong(this.resolve(((AddSequenceMeta)this.meta).getMaxValue()));
                    }
                    catch (NumberFormatException ex) {
                        this.logError(BaseMessages.getString(PKG, (String)"AddSequence.Log.CouldNotParseCounterValue", (String[])new String[]{"increment", ((AddSequenceMeta)this.meta).getMaxValue(), this.resolve(((AddSequenceMeta)this.meta).getMaxValue()), ex.getMessage()}));
                        doAbort = true;
                    }
                    if (doAbort) {
                        return false;
                    }
                    String realCounterName = this.resolve(((AddSequenceMeta)this.meta).getCounterName());
                    if (!Utils.isEmpty((CharSequence)realCounterName)) {
                        ((AddSequenceData)this.data).setLookup("@@sequence:" + realCounterName);
                    } else {
                        ((AddSequenceData)this.data).setLookup("@@sequence:" + ((AddSequenceMeta)this.meta).getValueName());
                    }
                    IPipelineEngine iPipelineEngine = this.getPipeline();
                    synchronized (iPipelineEngine) {
                        ((AddSequenceData)this.data).counter = Counters.getInstance().getOrUpdateCounter(((AddSequenceData)this.data).getLookup(), new Counter(((AddSequenceData)this.data).start, ((AddSequenceData)this.data).increment, ((AddSequenceData)this.data).maximum));
                    }
                    return true;
                }
                this.logError(BaseMessages.getString(PKG, (String)"AddSequence.Log.PipelineCountersHashtableNotAllocated", (String[])new String[0]));
            }
        } else {
            this.logError(BaseMessages.getString(PKG, (String)"AddSequence.Log.NeedToSelectSequence", (String[])new String[0]));
        }
        return false;
    }

    public void dispose() {
        if (((AddSequenceMeta)this.meta).isCounterUsed()) {
            if (((AddSequenceData)this.data).getLookup() != null) {
                Counters.getInstance().removeCounter(((AddSequenceData)this.data).getLookup());
            }
            ((AddSequenceData)this.data).counter = null;
        }
        if (((AddSequenceMeta)this.meta).isDatabaseUsed() && ((AddSequenceData)this.data).getDb() != null) {
            ((AddSequenceData)this.data).getDb().disconnect();
        }
        super.dispose();
    }

    public void cleanup() {
        super.cleanup();
    }
}

