/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.server;

import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ServerConnectionManager {
    private static final String SSL = "SSL";
    private static final String KEYSTORE_SYSTEM_PROPERTY = "javax.net.ssl.keyStore";
    private static ServerConnectionManager serverConnectionManager;
    private PoolingHttpClientConnectionManager manager;

    private ServerConnectionManager() {
        if (ServerConnectionManager.needToInitializeSSLContext()) {
            try {
                SSLContext context = SSLContext.getInstance(SSL);
                context.init(new KeyManager[0], new X509TrustManager[]{ServerConnectionManager.getDefaultTrustManager()}, new SecureRandom());
                SSLContext.setDefault(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.manager = new PoolingHttpClientConnectionManager();
        this.manager.setDefaultMaxPerRoute(100);
        this.manager.setMaxTotal(200);
    }

    private static boolean needToInitializeSSLContext() {
        return System.getProperty(KEYSTORE_SYSTEM_PROPERTY) == null;
    }

    public static ServerConnectionManager getInstance() {
        if (serverConnectionManager == null) {
            serverConnectionManager = new ServerConnectionManager();
        }
        return serverConnectionManager;
    }

    public HttpClient createHttpClient() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.manager).build();
    }

    public HttpClient createHttpClient(String user, String password) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, password);
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        return HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).setConnectionManager((HttpClientConnectionManager)this.manager).build();
    }

    public HttpClient createHttpClient(String user, String password, String proxyHost, int proxyPort, AuthScope authScope) {
        HttpHost httpHost = new HttpHost(proxyHost, proxyPort);
        RequestConfig requestConfig = RequestConfig.custom().setProxy(httpHost).build();
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, password);
        provider.setCredentials(authScope, (Credentials)credentials);
        return HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)this.manager).build();
    }

    public void shutdown() {
        this.manager.shutdown();
    }

    private static X509TrustManager getDefaultTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String param) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String param) throws CertificateException {
                for (X509Certificate cert : certs) {
                    cert.checkValidity();
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
    }

    static void reset() {
        serverConnectionManager = null;
    }
}

