/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.util;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.json.JsonMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;

public class HopMetadataUtil {
    public static final IHopMetadataProvider getStandardHopMetadataProvider(IVariables variables) {
        String[] folders;
        String foldersValue = variables.getVariable("HOP_METADATA_FOLDER");
        if (StringUtils.isEmpty((String)foldersValue)) {
            String configDirectory = Const.HOP_CONFIG_FOLDER;
            if (!configDirectory.endsWith(Const.FILE_SEPARATOR)) {
                configDirectory = configDirectory + Const.FILE_SEPARATOR;
            }
            folders = new String[]{configDirectory + "metadata"};
        } else {
            folders = foldersValue.split(",");
            for (int i = 0; i < folders.length; ++i) {
                folders[i] = Const.trim(folders[i]);
            }
        }
        if (folders.length == 1) {
            return new JsonMetadataProvider(Encr.getEncoder(), folders[0], variables);
        }
        ArrayList<IHopMetadataProvider> providers = new ArrayList<IHopMetadataProvider>();
        for (String folder : folders) {
            JsonMetadataProvider provider = new JsonMetadataProvider(Encr.getEncoder(), folder, variables);
            providers.add(provider);
        }
        return new MultiMetadataProvider(Encr.getEncoder(), providers, variables);
    }

    public static <T extends IHopMetadata> HopMetadata getHopMetadataAnnotation(Class<T> managedClass) {
        HopMetadata hopMetadata = managedClass.getAnnotation(HopMetadata.class);
        return hopMetadata;
    }
}

