/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.laf;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.hop.laf.IPropertyHandler;

public class OverlayProperties
extends Properties
implements IPropertyHandler {
    private static final long serialVersionUID = 1L;
    private String name = null;

    public OverlayProperties(String file) throws IOException {
        this.load(file);
    }

    @Override
    public boolean exists(String filename) {
        try {
            return this.getURL(filename) != null;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    @Override
    public boolean loadProps(String filename) {
        try {
            return this.load(filename);
        }
        catch (IOException e) {
            return false;
        }
    }

    private URL getURL(String filename) throws MalformedURLException {
        URL url;
        File file = new File(filename);
        if (file.exists()) {
            url = file.toURI().toURL();
        } else {
            ClassLoader classLoader = this.getClass().getClassLoader();
            url = classLoader.getResource(filename);
        }
        return url;
    }

    public boolean load(String filename) throws IOException {
        URL url = this.getURL(filename);
        if (url == null) {
            return false;
        }
        this.clear();
        this.load(url.openStream());
        return true;
    }

    public String getName() {
        return this.name;
    }
}

