/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.DateDetector;
import org.apache.hop.core.util.StringEvaluationResult;

public class StringEvaluator {
    private Set<String> values;
    private List<StringEvaluationResult> evaluationResults;
    private int maxLength;
    private int maxPrecision;
    private int count;
    private boolean tryTrimming;
    private IValueMeta stringMeta;
    private String[] dateFormats;
    private String[] numberFormats;
    private static final String[] DEFAULT_NUMBER_FORMATS = new String[]{"#,###,###.#", "#.#", "#", "#.0", "#.00", "#.000", "#.0000", "#.00000", "#.000000", " #.0#"};
    protected static final Pattern PRECISION_PATTERN = Pattern.compile("[^0-9#]");

    public StringEvaluator() {
        this(true);
    }

    public StringEvaluator(boolean tryTrimming) {
        this(tryTrimming, DEFAULT_NUMBER_FORMATS, Const.getDateFormats());
    }

    public StringEvaluator(boolean tryTrimming, List<String> numberFormats, List<String> dateFormats) {
        this(tryTrimming, numberFormats.toArray(new String[numberFormats.size()]), dateFormats.toArray(new String[dateFormats.size()]));
    }

    public StringEvaluator(boolean tryTrimming, String[] numberFormats, String[] dateFormats) {
        this.tryTrimming = tryTrimming;
        this.values = new HashSet<String>();
        this.evaluationResults = new ArrayList<StringEvaluationResult>();
        this.count = 0;
        this.stringMeta = new ValueMetaString("string");
        this.numberFormats = numberFormats;
        this.dateFormats = dateFormats;
        this.populateConversionMetaList();
    }

    public void evaluateString(String value) {
        ++this.count;
        if (!this.values.contains(value)) {
            this.values.add(value);
            if (value != null) {
                this.evaluateLength(value);
                this.evaluatePrecision(value);
                this.challengeConversions(value);
            }
        }
    }

    private void challengeConversions(String value) {
        ArrayList<StringEvaluationResult> all = new ArrayList<StringEvaluationResult>(this.evaluationResults);
        IValueMeta stringMetaClone = null;
        for (StringEvaluationResult cmm : all) {
            if (cmm.getConversionMeta().isBoolean()) {
                String string = this.tryTrimming ? Const.trim(value) : value;
                if (StringUtils.isEmpty((String)value)) {
                    cmm.incrementNrNull();
                    continue;
                }
                if (!("Y".equalsIgnoreCase(string) || "N".equalsIgnoreCase(string) || "TRUE".equalsIgnoreCase(string) || "FALSE".equalsIgnoreCase(string))) {
                    this.evaluationResults.remove(cmm);
                    continue;
                }
                cmm.incrementSuccesses();
                continue;
            }
            if (cmm.getConversionMeta().isDate()) {
                String dateFormat = cmm.getConversionMeta().getConversionMask();
                if (!DateDetector.isValidDateFormatToStringDate(dateFormat, value, "en_US")) {
                    this.evaluationResults.remove(cmm);
                    continue;
                }
                try {
                    Date object = DateDetector.getDateFromStringByFormat(value, dateFormat);
                    cmm.incrementSuccesses();
                    if (cmm.getMin() == null || cmm.getConversionMeta().compare(cmm.getMin(), object) > 0) {
                        cmm.setMin(object);
                    }
                    if (cmm.getMax() != null && cmm.getConversionMeta().compare(cmm.getMax(), object) >= 0) continue;
                    cmm.setMax(object);
                }
                catch (ParseException e) {
                    this.evaluationResults.remove(cmm);
                }
                catch (HopValueException e) {
                    this.evaluationResults.remove(cmm);
                }
                continue;
            }
            try {
                if (cmm.getConversionMeta().isNumeric()) {
                    boolean stop = false;
                    int nrDots = 0;
                    int nrCommas = 0;
                    int pos = 0;
                    for (char c : value.toCharArray()) {
                        boolean currencySymbolMatch;
                        boolean bl = currencySymbolMatch = !String.valueOf(c).equals(cmm.getConversionMeta().getCurrencySymbol()) && c != '(' && c != ')';
                        if (!(Character.isDigit(c) || c == '.' || c == ',' || Character.isSpaceChar(c) || !currencySymbolMatch || pos <= 0 || c != '+' && c != '-')) {
                            this.evaluationResults.remove(cmm);
                            stop = true;
                            break;
                        }
                        if (c == '.' && cmm.getConversionMeta().isInteger() || c == ',' && cmm.getConversionMeta().isInteger()) {
                            this.evaluationResults.remove(cmm);
                            stop = true;
                            break;
                        }
                        if (c == '.') {
                            ++nrDots;
                        }
                        if (c == ',') {
                            ++nrCommas;
                        }
                        ++pos;
                    }
                    if (nrDots > 1 && nrCommas > 1) {
                        this.evaluationResults.remove(cmm);
                        stop = true;
                    }
                    if (stop) continue;
                }
                if (stringMetaClone == null) {
                    stringMetaClone = this.stringMeta.clone();
                }
                stringMetaClone.setConversionMetadata(cmm.getConversionMeta());
                stringMetaClone.setTrimType(cmm.getConversionMeta().getTrimType());
                Object object = stringMetaClone.convertDataUsingConversionMetaData(value);
                if (cmm.getConversionMeta().isNull(object)) {
                    cmm.incrementNrNull();
                } else {
                    cmm.incrementSuccesses();
                }
                if (cmm.getMin() == null || cmm.getConversionMeta().compare(cmm.getMin(), object) > 0) {
                    cmm.setMin(object);
                }
                if (cmm.getMax() != null && cmm.getConversionMeta().compare(cmm.getMax(), object) >= 0) continue;
                cmm.setMax(object);
            }
            catch (HopValueException e) {
                this.evaluationResults.remove(cmm);
            }
        }
    }

    private void evaluateLength(String value) {
        if (value.length() > this.maxLength) {
            this.maxLength = value.length();
        }
    }

    private void evaluatePrecision(String value) {
        int p = StringEvaluator.determinePrecision(value);
        if (p > this.maxPrecision) {
            this.maxPrecision = p;
        }
    }

    private boolean containsInteger() {
        for (StringEvaluationResult result : this.evaluationResults) {
            if (!result.getConversionMeta().isInteger() || result.getNrSuccesses() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean containsNumber() {
        for (StringEvaluationResult result : this.evaluationResults) {
            if (!result.getConversionMeta().isNumber() || result.getNrSuccesses() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean containsDate() {
        for (StringEvaluationResult result : this.evaluationResults) {
            if (!result.getConversionMeta().isDate() || result.getNrSuccesses() <= 0) continue;
            return true;
        }
        return false;
    }

    public StringEvaluationResult getAdvicedResult() {
        StringEvaluationResult result;
        Iterator<StringEvaluationResult> iterator;
        if (this.evaluationResults.isEmpty()) {
            ValueMetaString adviced = new ValueMetaString("adviced");
            adviced.setLength(this.maxLength);
            int nrNulls = 0;
            String min = null;
            String max = null;
            for (String string : this.values) {
                if (string != null) {
                    if (min == null || min.compareTo(string) > 0) {
                        min = string;
                    }
                    if (max != null && max.compareTo(string) >= 0) continue;
                    max = string;
                    continue;
                }
                ++nrNulls;
            }
            StringEvaluationResult result2 = new StringEvaluationResult(adviced);
            result2.setNrNull(nrNulls);
            result2.setMin(min);
            result2.setMax(max);
            return result2;
        }
        if (this.containsInteger() && this.containsNumber()) {
            iterator = this.evaluationResults.iterator();
            while (iterator.hasNext()) {
                result = iterator.next();
                if (this.maxPrecision == 0 && result.getConversionMeta().isNumber()) {
                    iterator.remove();
                    continue;
                }
                if (this.maxPrecision <= 0 || !result.getConversionMeta().isInteger()) continue;
                iterator.remove();
            }
        }
        if (this.containsInteger() && this.containsDate()) {
            iterator = this.evaluationResults.iterator();
            while (iterator.hasNext()) {
                result = iterator.next();
                if (!result.getConversionMeta().isInteger()) continue;
                iterator.remove();
            }
        }
        Comparator compare = null;
        compare = this.containsDate() ? (r1, r2) -> {
            Integer length1 = r1.getConversionMeta().getConversionMask() == null ? 0 : r1.getConversionMeta().getConversionMask().length();
            Integer length2 = r2.getConversionMeta().getConversionMask() == null ? 0 : r2.getConversionMeta().getConversionMask().length();
            return length2.compareTo(length1);
        } : (r1, r2) -> {
            Integer length1 = r1.getConversionMeta().getConversionMask() == null ? 0 : r1.getConversionMeta().getConversionMask().length();
            Integer length2 = r2.getConversionMeta().getConversionMask() == null ? 0 : r2.getConversionMeta().getConversionMask().length();
            return length1.compareTo(length2);
        };
        Collections.sort(this.evaluationResults, compare);
        result = this.evaluationResults.get(0);
        IValueMeta conversionMeta = result.getConversionMeta();
        if (conversionMeta.isNumber() && conversionMeta.getCurrencySymbol() == null) {
            conversionMeta.setPrecision(this.maxPrecision);
            if (this.maxPrecision > 0 && this.maxLength > 0) {
                conversionMeta.setLength(this.maxLength);
            }
        }
        return result;
    }

    public String[] getDateFormats() {
        return this.dateFormats;
    }

    public String[] getNumberFormats() {
        return this.numberFormats;
    }

    private void populateConversionMetaList() {
        int[] trimTypes = this.tryTrimming ? new int[]{0, 3} : new int[]{0};
        for (int trimType : trimTypes) {
            for (String format : this.getDateFormats()) {
                ValueMetaDate conversionMeta = new ValueMetaDate("date");
                conversionMeta.setConversionMask(format);
                conversionMeta.setTrimType(trimType);
                conversionMeta.setDateFormatLenient(false);
                this.evaluationResults.add(new StringEvaluationResult(conversionMeta));
            }
            EvalResultBuilder numberUsBuilder = new EvalResultBuilder("number-us", 1, 15, trimType, ".", ",");
            EvalResultBuilder numberEuBuilder = new EvalResultBuilder("number-eu", 1, 15, trimType, ",", ".");
            for (String format : this.getNumberFormats()) {
                if (format.equals("#") || format.equals("0")) continue;
                int precision = StringEvaluator.determinePrecision(format);
                this.evaluationResults.add(numberUsBuilder.format(format, precision).build());
                this.evaluationResults.add(numberEuBuilder.format(format, precision).build());
            }
            DecimalFormat currencyFormat = (DecimalFormat)NumberFormat.getCurrencyInstance();
            ValueMetaBase conversionMeta = new ValueMetaNumber("number-currency");
            String currencyMask = currencyFormat.toLocalizedPattern().replace("\u00a4", currencyFormat.getCurrency().getSymbol());
            conversionMeta.setConversionMask(currencyMask);
            conversionMeta.setTrimType(trimType);
            conversionMeta.setDecimalSymbol(String.valueOf(currencyFormat.getDecimalFormatSymbols().getDecimalSeparator()));
            conversionMeta.setGroupingSymbol(String.valueOf(currencyFormat.getDecimalFormatSymbols().getGroupingSeparator()));
            conversionMeta.setCurrencySymbol(currencyFormat.getCurrency().getSymbol());
            conversionMeta.setLength(15);
            int currencyPrecision = currencyFormat.getCurrency().getDefaultFractionDigits();
            conversionMeta.setPrecision(currencyPrecision);
            this.evaluationResults.add(new StringEvaluationResult(conversionMeta));
            String currencyMaskAsNumeric = currencyMask.replaceAll(Pattern.quote(currencyFormat.getCurrency().getSymbol()), "");
            this.evaluationResults.add(numberUsBuilder.format(currencyMaskAsNumeric, currencyPrecision).build());
            this.evaluationResults.add(numberEuBuilder.format(currencyMaskAsNumeric, currencyPrecision).build());
            conversionMeta = new ValueMetaInteger("integer");
            conversionMeta.setConversionMask("#");
            conversionMeta.setLength(15);
            this.evaluationResults.add(new StringEvaluationResult(conversionMeta));
            conversionMeta = new ValueMetaInteger("integer");
            conversionMeta.setConversionMask(" #");
            conversionMeta.setLength(15);
            this.evaluationResults.add(new StringEvaluationResult(conversionMeta));
            for (int i = 1; i <= 15; ++i) {
                int x;
                String mask = " ";
                for (x = 0; x < i; ++x) {
                    mask = mask + "0";
                }
                mask = mask + ";-";
                for (x = 0; x < i; ++x) {
                    mask = mask + "0";
                }
                conversionMeta = new ValueMetaInteger("integer-zero-padded-" + i);
                conversionMeta.setConversionMask(mask);
                conversionMeta.setLength(i);
                this.evaluationResults.add(new StringEvaluationResult(conversionMeta));
            }
            conversionMeta = new ValueMetaBoolean("boolean");
            this.evaluationResults.add(new StringEvaluationResult(conversionMeta));
        }
    }

    protected static int determinePrecision(String numericFormat) {
        if (numericFormat != null) {
            char decimalSymbol = ((DecimalFormat)NumberFormat.getInstance()).getDecimalFormatSymbols().getDecimalSeparator();
            int loc = numericFormat.lastIndexOf(decimalSymbol);
            if (loc >= 0 && loc < numericFormat.length()) {
                Matcher m = PRECISION_PATTERN.matcher(numericFormat.substring(loc + 1));
                int nonDigitLoc = numericFormat.length();
                if (m.find()) {
                    nonDigitLoc = loc + 1 + m.start();
                }
                return numericFormat.substring(loc + 1, nonDigitLoc).length();
            }
            return 0;
        }
        return 0;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public List<StringEvaluationResult> getStringEvaluationResults() {
        ArrayList<StringEvaluationResult> result = new ArrayList<StringEvaluationResult>();
        for (StringEvaluationResult ev : this.evaluationResults) {
            if (ev.getNrSuccesses() <= 0) continue;
            result.add(ev);
        }
        return result;
    }

    public int getCount() {
        return this.count;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    private static class EvalResultBuilder {
        private final String name;
        private final int type;
        private final int length;
        private final int trimType;
        private final String decimalSymbol;
        private final String groupingSymbol;
        private String format;
        private int precision;

        public StringEvaluationResult build() {
            try {
                IValueMeta meta = ValueMetaFactory.createValueMeta(this.name, this.type);
                meta.setConversionMask(this.format);
                meta.setTrimType(this.trimType);
                meta.setDecimalSymbol(this.decimalSymbol);
                meta.setGroupingSymbol(this.groupingSymbol);
                meta.setLength(this.length);
                meta.setPrecision(this.precision);
                return new StringEvaluationResult(meta);
            }
            catch (HopPluginException e) {
                throw new RuntimeException("Unable to create a new value '" + this.name + "' of type '" + this.type + "'", e);
            }
        }

        public EvalResultBuilder(String name, int type, int length, int trimType, String decimalSymbol, String groupingSymbol) {
            this.name = name;
            this.type = type;
            this.length = length;
            this.trimType = trimType;
            this.decimalSymbol = decimalSymbol;
            this.groupingSymbol = groupingSymbol;
        }

        public EvalResultBuilder format(String format, int precision) {
            this.format = format;
            this.precision = precision;
            return this;
        }
    }
}

