/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpClientManager {
    private static final int CONNECTIONS_PER_ROUTE = 100;
    private static final int TOTAL_CONNECTIONS = 200;
    private static HttpClientManager httpClientManager;
    private static PoolingHttpClientConnectionManager manager;

    private HttpClientManager() {
        manager = new PoolingHttpClientConnectionManager();
        manager.setDefaultMaxPerRoute(100);
        manager.setMaxTotal(200);
    }

    public static HttpClientManager getInstance() {
        if (httpClientManager == null) {
            httpClientManager = new HttpClientManager();
        }
        return httpClientManager;
    }

    public CloseableHttpClient createDefaultClient() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).build();
    }

    public HttpClientBuilderFacade createBuilder() {
        return new HttpClientBuilderFacade();
    }

    public class HttpClientBuilderFacade {
        private RedirectStrategy redirectStrategy;
        private CredentialsProvider provider;
        private int connectionTimeout;
        private int socketTimeout;
        private HttpHost proxy;

        public HttpClientBuilderFacade setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public HttpClientBuilderFacade setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public HttpClientBuilderFacade setCredentials(String user, String password, AuthScope authScope) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, password);
            provider.setCredentials(authScope, (Credentials)credentials);
            this.provider = provider;
            return this;
        }

        public HttpClientBuilderFacade setCredentials(String user, String password) {
            return this.setCredentials(user, password, AuthScope.ANY);
        }

        public HttpClientBuilderFacade setProxy(String proxyHost, int proxyPort) {
            this.setProxy(proxyHost, proxyPort, "http");
            return this;
        }

        public HttpClientBuilderFacade setProxy(String proxyHost, int proxyPort, String scheme) {
            this.proxy = new HttpHost(proxyHost, proxyPort, scheme);
            return this;
        }

        public HttpClientBuilderFacade setRedirect(RedirectStrategy redirectStrategy) {
            this.redirectStrategy = redirectStrategy;
            return this;
        }

        public CloseableHttpClient build() {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)manager);
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            if (this.socketTimeout > 0) {
                requestConfigBuilder.setSocketTimeout(this.socketTimeout);
            }
            if (this.connectionTimeout > 0) {
                requestConfigBuilder.setConnectTimeout(this.socketTimeout);
            }
            if (this.proxy != null) {
                requestConfigBuilder.setProxy(this.proxy);
            }
            httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            if (this.provider != null) {
                httpClientBuilder.setDefaultCredentialsProvider(this.provider);
            }
            if (this.redirectStrategy != null) {
                httpClientBuilder.setRedirectStrategy(this.redirectStrategy);
            }
            return httpClientBuilder.build();
        }
    }
}

