/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class RowBuffer {
    public static final String XML_TAG = "row-buffer";
    private IRowMeta rowMeta;
    private List<Object[]> buffer;

    public RowBuffer() {
        this.rowMeta = new RowMeta();
        this.buffer = new ArrayList<Object[]>();
    }

    public RowBuffer(IRowMeta rowMeta, List<Object[]> buffer) {
        this.rowMeta = rowMeta;
        this.buffer = buffer;
    }

    public RowBuffer(IRowMeta rowMeta) {
        this(rowMeta, new ArrayList<Object[]>());
    }

    public String getXml() throws IOException {
        String xml = XmlHandler.openTag(XML_TAG);
        xml = xml + this.rowMeta.getMetaXml();
        for (Object[] row : this.buffer) {
            xml = xml + this.rowMeta.getDataXml(row);
        }
        xml = xml + XmlHandler.closeTag(XML_TAG);
        return xml;
    }

    public RowBuffer(Node node) throws HopException {
        this();
        Node rowMetaNode = XmlHandler.getSubNode(node, "row-meta");
        this.rowMeta = new RowMeta(rowMetaNode);
        List<Node> dataNodes = XmlHandler.getNodes(node, "row-data");
        for (Node dataNode : dataNodes) {
            this.buffer.add(this.rowMeta.getRow(dataNode));
        }
    }

    public int size() {
        return this.buffer.size();
    }

    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public void addRow(Object[] row) {
        this.buffer.add(row);
    }

    public void addRow(int index, Object[] row) {
        this.buffer.add(index, row);
    }

    public Object[] removeRow(int index) {
        return this.buffer.remove(index);
    }

    public void setRow(int index, Object[] row) {
        this.buffer.set(index, row);
    }

    public IRowMeta getRowMeta() {
        return this.rowMeta;
    }

    public void setRowMeta(IRowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public List<Object[]> getBuffer() {
        return this.buffer;
    }

    public void setBuffer(List<Object[]> buffer) {
        this.buffer = buffer;
    }
}

