/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;

public class HopURLClassLoader
extends URLClassLoader {
    private static final Class<?> PKG = HopURLClassLoader.class;
    private String name;

    public HopURLClassLoader(URL[] url, ClassLoader classLoader) {
        super(url, classLoader);
    }

    public HopURLClassLoader(URL[] url, ClassLoader classLoader, String name) {
        this(url, classLoader);
        this.name = name;
    }

    @Override
    protected void addURL(URL url) {
        super.addURL(url);
    }

    public String toString() {
        return super.toString() + " : " + this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected Class<?> loadClassFromThisLoader(String arg0, boolean arg1) throws ClassNotFoundException {
        Class<?> clz = this.findLoadedClass(arg0);
        if (clz != null) {
            if (arg1) {
                this.resolveClass(clz);
            }
            return clz;
        }
        clz = this.findClass(arg0);
        if (clz != null) {
            if (arg1) {
                this.resolveClass(clz);
            }
            return clz;
        }
        return clz;
    }

    protected Class<?> loadClassFromParent(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clz = this.getParent().loadClass(name);
        if (clz != null) {
            if (resolve) {
                this.resolveClass(clz);
            }
            return clz;
        }
        throw new ClassNotFoundException("Could not find :" + name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Throwable thisLoaderException = null;
        try {
            return this.loadClassFromThisLoader(name, resolve);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            thisLoaderException = e;
        }
        catch (SecurityException e) {
            thisLoaderException = e;
        }
        try {
            return this.loadClassFromParent(name, resolve);
        }
        catch (Exception e) {
            if (thisLoaderException != null) {
                throw new ClassNotFoundException("Unable to load class '" + name + "' in this classloader or in the parent", thisLoaderException);
            }
            throw e;
        }
    }

    public Class<?> loadClass(String name, ProtectionDomain protectionDomain) {
        Class<?> loaded = this.findLoadedClass(name);
        if (loaded == null) {
            String newName = name.replace('.', '/');
            InputStream is = this.getResourceAsStream(newName);
            byte[] driverBytes = this.toBytes(is);
            loaded = super.defineClass(name, driverBytes, 0, driverBytes.length, protectionDomain);
        }
        return loaded;
    }

    private byte[] toBytes(InputStream is) {
        byte[] retval = new byte[]{};
        try {
            int a = is.available();
            while (a > 0) {
                int i;
                byte[] buffer = new byte[a];
                is.read(buffer);
                byte[] newretval = new byte[retval.length + a];
                for (i = 0; i < retval.length; ++i) {
                    newretval[i] = retval[i];
                }
                for (i = 0; i < a; ++i) {
                    newretval[retval.length + i] = buffer[i];
                }
                retval = newretval;
                a = is.available();
            }
            return retval;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getFieldObject(Class<?> clazz, String name, Object obj) throws Exception {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return field.get(obj);
    }

    public void closeClassLoader() {
        block30: {
            HashSet<String> closedFiles = new HashSet<String>();
            try {
                Object obj = HopURLClassLoader.getFieldObject(URLClassLoader.class, "ucp", this);
                ArrayList loaders = (ArrayList)HopURLClassLoader.getFieldObject(obj.getClass(), "loaders", obj);
                Iterator iterator = loaders.iterator();
                while (iterator.hasNext()) {
                    Object ldr = iterator.next();
                    try {
                        JarFile file = (JarFile)HopURLClassLoader.getFieldObject(ldr.getClass(), "jar", ldr);
                        closedFiles.add(file.getName());
                        file.close();
                    }
                    catch (Exception file) {}
                }
            }
            catch (Exception obj) {
                // empty catch block
            }
            try {
                Vector nativeLibArr = (Vector)HopURLClassLoader.getFieldObject(ClassLoader.class, "nativeLibraries", this);
                for (Object lib : nativeLibArr) {
                    try {
                        Method fMethod = lib.getClass().getDeclaredMethod("finalize", new Class[0]);
                        fMethod.setAccessible(true);
                        fMethod.invoke(lib, new Object[0]);
                    }
                    catch (Exception fMethod) {}
                }
            }
            catch (Exception nativeLibArr) {
                // empty catch block
            }
            HashMap uCache = null;
            HashMap fCache = null;
            try {
                Class<?> jarUrlConnClass = null;
                try {
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    jarUrlConnClass = contextClassLoader.loadClass("sun.net.www.protocol.jar.JarURLConnection");
                }
                catch (Throwable contextClassLoader) {
                    // empty catch block
                }
                if (jarUrlConnClass == null) {
                    jarUrlConnClass = Class.forName("sun.net.www.protocol.jar.JarURLConnection");
                }
                Class<?> factory = HopURLClassLoader.getFieldObject(jarUrlConnClass, "factory", null).getClass();
                try {
                    fCache = (HashMap)HopURLClassLoader.getFieldObject(factory, "fileCache", null);
                }
                catch (Exception file) {
                    // empty catch block
                }
                try {
                    uCache = (HashMap)HopURLClassLoader.getFieldObject(factory, "urlCache", null);
                }
                catch (Exception file) {
                    // empty catch block
                }
                if (uCache != null) {
                    Set set = null;
                    while (set == null) {
                        try {
                            set = ((HashMap)uCache.clone()).keySet();
                        }
                        catch (ConcurrentModificationException concurrentModificationException) {}
                    }
                    for (Object file : set) {
                        JarFile jar;
                        if (!(file instanceof JarFile) || !closedFiles.contains((jar = (JarFile)file).getName())) continue;
                        try {
                            jar.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (fCache != null) {
                            fCache.remove(uCache.get(jar));
                        }
                        uCache.remove(jar);
                    }
                    break block30;
                }
                if (fCache == null) break block30;
                for (Object key : ((HashMap)fCache.clone()).keySet()) {
                    JarFile jar;
                    Object file = fCache.get(key);
                    if (!(file instanceof JarFile) || !closedFiles.contains((jar = (JarFile)file).getName())) continue;
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    fCache.remove(key);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null && this.getParent() != null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }
}

