/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui.plugin.menu;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.hop.core.gui.plugin.BaseGuiElements;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElement;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElementType;

public class GuiMenuItem
extends BaseGuiElements
implements Comparable<GuiMenuItem> {
    private String root;
    private String id;
    private String parentId;
    private String label;
    private String toolTip;
    private GuiMenuElementType type;
    private String image;
    private String disabledImage;
    private boolean ignored;
    private boolean addingSeparator;
    private ClassLoader classLoader;
    private boolean singleTon;
    private String listenerClassName;
    private String listenerMethod;

    public GuiMenuItem() {
    }

    public GuiMenuItem(GuiMenuElement guiElement, Method guiPluginMethod, String guiPluginClassName, ClassLoader classLoader) {
        this();
        this.root = guiElement.root();
        this.id = guiElement.id();
        this.type = guiElement.type();
        this.parentId = guiElement.parentId();
        this.image = guiElement.image();
        this.ignored = guiElement.ignored();
        this.addingSeparator = guiElement.separator();
        this.listenerMethod = guiPluginMethod.getName();
        this.listenerClassName = guiPluginClassName;
        this.singleTon = true;
        this.label = this.getTranslation(guiElement.label(), guiPluginMethod.getDeclaringClass().getPackage().getName(), guiPluginMethod.getDeclaringClass());
        this.toolTip = this.getTranslation(guiElement.toolTip(), guiPluginMethod.getDeclaringClass().getPackage().getName(), guiPluginMethod.getDeclaringClass());
        this.classLoader = classLoader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuiMenuItem that = (GuiMenuItem)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public int compareTo(GuiMenuItem o) {
        return this.id.compareTo(o.id);
    }

    public String toString() {
        return "GuiMenuItem{id='" + this.id + '\'' + '}';
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public GuiMenuElementType getType() {
        return this.type;
    }

    public void setType(GuiMenuElementType type) {
        this.type = type;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getDisabledImage() {
        return this.disabledImage;
    }

    public void setDisabledImage(String disabledImage) {
        this.disabledImage = disabledImage;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public boolean isAddingSeparator() {
        return this.addingSeparator;
    }

    public void setAddingSeparator(boolean addingSeparator) {
        this.addingSeparator = addingSeparator;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isSingleTon() {
        return this.singleTon;
    }

    public void setSingleTon(boolean singleTon) {
        this.singleTon = singleTon;
    }

    public String getListenerClassName() {
        return this.listenerClassName;
    }

    public void setListenerClassName(String listenerClassName) {
        this.listenerClassName = listenerClassName;
    }

    public String getListenerMethod() {
        return this.listenerMethod;
    }

    public void setListenerMethod(String listenerMethod) {
        this.listenerMethod = listenerMethod;
    }
}

