/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui.plugin;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.action.GuiContextAction;
import org.apache.hop.core.gui.plugin.GuiElements;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.gui.plugin.action.GuiAction;
import org.apache.hop.core.gui.plugin.callback.GuiCallback;
import org.apache.hop.core.gui.plugin.callback.GuiCallbackMethod;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.KeyboardShortcut;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElement;
import org.apache.hop.core.gui.plugin.menu.GuiMenuItem;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarItem;
import org.apache.hop.core.util.TranslateUtil;

public class GuiRegistry {
    private static GuiRegistry guiRegistry;
    private Map<String, Map<String, GuiMenuItem>> guiMenuMap = new HashMap<String, Map<String, GuiMenuItem>>();
    private Map<String, Map<String, GuiToolbarItem>> guiToolbarMap = new HashMap<String, Map<String, GuiToolbarItem>>();
    private Map<String, Map<String, GuiElements>> dataElementsMap = new HashMap<String, Map<String, GuiElements>>();
    private Map<String, List<KeyboardShortcut>> shortCutsMap = new HashMap<String, List<KeyboardShortcut>>();
    private Map<String, List<GuiAction>> contextActionsMap = new HashMap<String, List<GuiAction>>();
    private Map<String, List<GuiCallbackMethod>> callbackMethodsMap;
    private Map<String, Map<String, Map<String, Object>>> guiPluginObjectsMap = new HashMap<String, Map<String, Map<String, Object>>>();

    private GuiRegistry() {
        this.callbackMethodsMap = new HashMap<String, List<GuiCallbackMethod>>();
    }

    public static final GuiRegistry getInstance() {
        if (guiRegistry == null) {
            guiRegistry = new GuiRegistry();
        }
        return guiRegistry;
    }

    public void addGuiMenuItem(String root, GuiMenuItem guiMenuItem) {
        Map<String, GuiMenuItem> menuMap = this.guiMenuMap.get(root);
        if (menuMap == null) {
            menuMap = new HashMap<String, GuiMenuItem>();
            this.guiMenuMap.put(root, menuMap);
        }
        menuMap.put(guiMenuItem.getId(), guiMenuItem);
    }

    public GuiMenuItem findGuiMenuItem(String root, String id) {
        Map<String, GuiMenuItem> menuMap = this.guiMenuMap.get(root);
        if (menuMap == null) {
            return null;
        }
        return menuMap.get(id);
    }

    public List<GuiMenuItem> findChildGuiMenuItems(String root, String parentId) {
        Map<String, GuiMenuItem> menuMap = this.guiMenuMap.get(root);
        if (menuMap == null) {
            return Collections.emptyList();
        }
        ArrayList<GuiMenuItem> items = new ArrayList<GuiMenuItem>();
        for (GuiMenuItem item : menuMap.values()) {
            if (!item.getParentId().equals(parentId)) continue;
            items.add(item);
        }
        return items;
    }

    public void addGuiToolbarItem(String root, GuiToolbarItem guiToolbarItem) {
        Map<String, GuiToolbarItem> toolbarMap = this.guiToolbarMap.get(root);
        if (toolbarMap == null) {
            toolbarMap = new HashMap<String, GuiToolbarItem>();
            this.guiToolbarMap.put(root, toolbarMap);
        }
        toolbarMap.put(guiToolbarItem.getId(), guiToolbarItem);
    }

    public GuiToolbarItem findGuiToolbarItem(String root, String id) {
        Map<String, GuiToolbarItem> toolbarMap = this.guiToolbarMap.get(root);
        if (toolbarMap == null) {
            return null;
        }
        return toolbarMap.get(id);
    }

    public List<GuiToolbarItem> findGuiToolbarItems(String root) {
        Map<String, GuiToolbarItem> menuMap = this.guiToolbarMap.get(root);
        if (menuMap == null) {
            return Collections.emptyList();
        }
        ArrayList<GuiToolbarItem> items = new ArrayList<GuiToolbarItem>();
        for (GuiToolbarItem item : menuMap.values()) {
            items.add(item);
        }
        return items;
    }

    public void putGuiElements(String dataClassName, String parentGuiElementId, GuiElements guiElements) {
        Map<String, GuiElements> elementsMap = this.dataElementsMap.get(dataClassName);
        if (elementsMap == null) {
            elementsMap = new HashMap<String, GuiElements>();
            this.dataElementsMap.put(dataClassName, elementsMap);
        }
        elementsMap.put(parentGuiElementId, guiElements);
    }

    public GuiElements findGuiElements(String dataClassName, String parentGuiElementId) {
        Map<String, GuiElements> elementsMap = this.dataElementsMap.get(dataClassName);
        if (elementsMap == null) {
            return null;
        }
        GuiElements guiElements = elementsMap.get(parentGuiElementId);
        if (guiElements == null) {
            for (GuiElements elements : elementsMap.values()) {
                GuiElements found = this.findChildGuiElementsById(elements, parentGuiElementId);
                if (found == null) continue;
                return found;
            }
        }
        return guiElements;
    }

    public GuiElements findChildGuiElementsById(GuiElements guiElements, String id) {
        if (guiElements.getId() != null && guiElements.getId().equals(id)) {
            return guiElements;
        }
        for (GuiElements child : guiElements.getChildren()) {
            GuiElements found = this.findChildGuiElementsById(child, id);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public void addGuiWidgetElement(String dataClassName, GuiWidgetElement guiElement, Field field) {
        GuiElements guiElements = this.findGuiElements(dataClassName, guiElement.parentId());
        if (guiElements == null) {
            guiElements = new GuiElements();
            this.putGuiElements(dataClassName, guiElement.parentId(), guiElements);
        }
        GuiElements child = new GuiElements(guiElement, field);
        GuiElements existing = guiElements.findChild(guiElement.id());
        if (existing != null && existing.isIgnored()) {
            return;
        }
        if (existing != null && child.isIgnored()) {
            existing.setIgnored(true);
            return;
        }
        guiElements.getChildren().add(child);
    }

    public void addGuiWidgetElement(String guiPluginClassName, GuiMenuElement guiElement, Method guiPluginClassMethod, ClassLoader classLoader) {
        GuiMenuItem guiMenuItem = new GuiMenuItem(guiElement, guiPluginClassMethod, guiPluginClassName, classLoader);
        this.addGuiMenuItem(guiElement.root(), guiMenuItem);
    }

    public void addGuiToolbarElement(String guiPluginClassName, GuiToolbarElement toolbarElement, Method method, ClassLoader classLoader) {
        GuiToolbarItem toolbarItem = new GuiToolbarItem(toolbarElement, guiPluginClassName, method, classLoader);
        this.addGuiToolbarItem(toolbarElement.root(), toolbarItem);
    }

    public void sortAllElements() {
        Set<String> dataClassNames = this.dataElementsMap.keySet();
        for (String dataClassName : dataClassNames) {
            Map<String, GuiElements> guiElementsMap = this.dataElementsMap.get(dataClassName);
            Set<String> parentIds = guiElementsMap.keySet();
            for (String parentId : parentIds) {
                GuiElements guiElements = guiElementsMap.get(parentId);
                guiElements.sortChildren();
            }
        }
    }

    public void addKeyboardShortcut(String guiPluginClassName, Method method, GuiKeyboardShortcut shortcut) {
        List shortcuts = this.shortCutsMap.computeIfAbsent(guiPluginClassName, k -> new ArrayList());
        KeyboardShortcut keyboardShortCut = new KeyboardShortcut(shortcut, method);
        shortcuts.add(keyboardShortCut);
    }

    public void addKeyboardShortcut(String parentClassName, Method parentMethod, GuiOsxKeyboardShortcut shortcut) {
        List shortcuts = this.shortCutsMap.computeIfAbsent(parentClassName, k -> new ArrayList());
        shortcuts.add(new KeyboardShortcut(shortcut, parentMethod));
    }

    public List<KeyboardShortcut> getKeyboardShortcuts(String parentClassName) {
        return this.shortCutsMap.get(parentClassName);
    }

    public KeyboardShortcut findKeyboardShortcut(String parentClassName, String methodName, boolean osx) {
        List<KeyboardShortcut> shortcuts = this.getKeyboardShortcuts(parentClassName);
        if (shortcuts != null) {
            for (KeyboardShortcut shortcut : shortcuts) {
                if (!shortcut.getParentMethodName().equals(methodName) || shortcut.isOsx() != osx) continue;
                return shortcut;
            }
        }
        return null;
    }

    public void addGuiContextAction(String guiPluginClassName, Method method, GuiContextAction ca, ClassLoader classLoader) {
        String name = TranslateUtil.translate(ca.name(), method.getDeclaringClass());
        String category = TranslateUtil.translate(ca.category(), method.getDeclaringClass());
        String tooltip = TranslateUtil.translate(ca.tooltip(), method.getDeclaringClass());
        GuiAction action = new GuiAction(ca.id(), ca.type(), name, tooltip, ca.image(), guiPluginClassName, method.getName());
        action.setCategory(StringUtils.isEmpty((String)category) ? null : category);
        action.setCategoryOrder(StringUtils.isEmpty((String)ca.categoryOrder()) ? null : ca.categoryOrder());
        action.setKeywords(Arrays.asList(ca.keywords()));
        action.setClassLoader(classLoader);
        List actions = this.contextActionsMap.computeIfAbsent(ca.parentId(), k -> new ArrayList());
        actions.add(action);
    }

    public List<GuiAction> getGuiContextActions(String parentContextId) {
        return this.contextActionsMap.get(parentContextId);
    }

    public void registerGuiCallback(Class<?> singletonGuiClass, Method method, GuiCallback guiCallback) {
        String callbackId = guiCallback.callbackId();
        GuiCallbackMethod callbackMethod = new GuiCallbackMethod(callbackId, singletonGuiClass, method);
        this.callbackMethodsMap.computeIfAbsent(callbackId, k -> new ArrayList()).add(callbackMethod);
    }

    public void executeCallbackMethods(String callbackId) {
        List<GuiCallbackMethod> methods = this.callbackMethodsMap.get(callbackId);
        if (methods == null) {
            return;
        }
        for (GuiCallbackMethod method : methods) {
            method.execute();
        }
    }

    public void registerGuiPluginObject(String hopGuiId, String guiPluginClassname, String instanceId, Object guiPluginObject) {
        Map instanceObjectsMap = this.guiPluginObjectsMap.computeIfAbsent(hopGuiId, k -> new HashMap());
        Map objectsMap = instanceObjectsMap.computeIfAbsent(instanceId, k -> new HashMap());
        objectsMap.put(guiPluginClassname, guiPluginObject);
    }

    public Object findGuiPluginObject(String hopGuiId, String guiPluginClassname, String instanceId) {
        Map<String, Map<String, Object>> instanceObjectsMap = this.guiPluginObjectsMap.get(hopGuiId);
        if (instanceObjectsMap == null) {
            return null;
        }
        Map<String, Object> objectsMap = instanceObjectsMap.get(instanceId);
        if (objectsMap == null) {
            return null;
        }
        return objectsMap.get(guiPluginClassname);
    }

    public void removeGuiPluginObject(String hopGuiId, String guiPluginClassname, String instanceId) {
        Map<String, Map<String, Object>> instanceObjectsMap = this.guiPluginObjectsMap.get(hopGuiId);
        if (instanceObjectsMap == null) {
            return;
        }
        Map<String, Object> objectsMap = instanceObjectsMap.get(instanceId);
        if (objectsMap == null) {
            return;
        }
        objectsMap.remove(guiPluginClassname);
    }

    public void removeGuiPluginObjects(String hopGuiId, String instanceId) {
        Map<String, Map<String, Object>> instanceObjectsMap = this.guiPluginObjectsMap.get(hopGuiId);
        if (instanceObjectsMap == null) {
            return;
        }
        instanceObjectsMap.remove(instanceId);
    }

    public Map<String, Map<String, GuiElements>> getDataElementsMap() {
        return this.dataElementsMap;
    }

    public void setDataElementsMap(Map<String, Map<String, GuiElements>> dataElementsMap) {
        this.dataElementsMap = dataElementsMap;
    }

    public Map<String, List<KeyboardShortcut>> getShortCutsMap() {
        return this.shortCutsMap;
    }

    public void setShortCutsMap(Map<String, List<KeyboardShortcut>> shortCutsMap) {
        this.shortCutsMap = shortCutsMap;
    }

    public Map<String, List<GuiAction>> getContextActionsMap() {
        return this.contextActionsMap;
    }

    public void setContextActionsMap(Map<String, List<GuiAction>> contextActionsMap) {
        this.contextActionsMap = contextActionsMap;
    }

    public Map<String, Map<String, GuiMenuItem>> getGuiMenuMap() {
        return this.guiMenuMap;
    }

    public void setGuiMenuMap(Map<String, Map<String, GuiMenuItem>> guiMenuMap) {
        this.guiMenuMap = guiMenuMap;
    }

    public Map<String, Map<String, GuiToolbarItem>> getGuiToolbarMap() {
        return this.guiToolbarMap;
    }

    public void setGuiToolbarMap(Map<String, Map<String, GuiToolbarItem>> guiToolbarMap) {
        this.guiToolbarMap = guiToolbarMap;
    }

    public Map<String, Map<String, Map<String, Object>>> getGuiPluginObjectsMap() {
        return this.guiPluginObjectsMap;
    }

    public void setGuiPluginObjectsMap(Map<String, Map<String, Map<String, Object>>> guiPluginObjectsMap) {
        this.guiPluginObjectsMap = guiPluginObjectsMap;
    }
}

