/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.extension;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointPluginType;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.IPluginTypeListener;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.IVariables;

public class ExtensionPointMap {
    private static ILogChannel log = new LogChannel("ExtensionPointMap");
    private static ExtensionPointMap INSTANCE = new ExtensionPointMap(PluginRegistry.getInstance());
    private final PluginRegistry registry;
    private Table<String, String, Supplier<IExtensionPoint>> extensionPointPluginMap;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private ExtensionPointMap(PluginRegistry pluginRegistry) {
        this.registry = pluginRegistry;
        this.extensionPointPluginMap = HashBasedTable.create();
        this.registry.addPluginListener(ExtensionPointPluginType.class, new IPluginTypeListener(){

            @Override
            public void pluginAdded(Object serviceObject) {
                ExtensionPointMap.this.addExtensionPoint((IPlugin)serviceObject);
            }

            @Override
            public void pluginRemoved(Object serviceObject) {
                ExtensionPointMap.this.removeExtensionPoint((IPlugin)serviceObject);
            }

            @Override
            public void pluginChanged(Object serviceObject) {
                ExtensionPointMap.this.removeExtensionPoint((IPlugin)serviceObject);
                ExtensionPointMap.this.addExtensionPoint((IPlugin)serviceObject);
            }
        });
        List extensionPointPlugins = this.registry.getPlugins(ExtensionPointPluginType.class);
        for (IPlugin extensionPointPlugin : extensionPointPlugins) {
            this.addExtensionPoint(extensionPointPlugin);
        }
    }

    public static ExtensionPointMap getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtensionPoint(IPlugin extensionPointPlugin) {
        this.lock.writeLock().lock();
        try {
            for (String id : extensionPointPlugin.getIds()) {
                this.extensionPointPluginMap.put((Object)extensionPointPlugin.getName(), (Object)id, this.createLazyLoader(extensionPointPlugin));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtensionPoint(IPlugin extensionPointPlugin) {
        this.lock.writeLock().lock();
        try {
            for (String id : extensionPointPlugin.getIds()) {
                this.extensionPointPluginMap.remove((Object)extensionPointPlugin.getName(), (Object)id);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reInitialize() {
        this.lock.writeLock().lock();
        try {
            this.extensionPointPluginMap = HashBasedTable.create();
            PluginRegistry registry = PluginRegistry.getInstance();
            List extensionPointPlugins = registry.getPlugins(ExtensionPointPluginType.class);
            for (IPlugin extensionPointPlugin : extensionPointPlugins) {
                this.addExtensionPoint(extensionPointPlugin);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    Supplier<IExtensionPoint> createLazyLoader(IPlugin extensionPointPlugin) {
        return Suppliers.memoize((Supplier)new ExtensionPointLoader(extensionPointPlugin));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callExtensionPoint(ILogChannel log, IVariables variables, String id, Object object) throws HopException {
        this.lock.readLock().lock();
        try {
            if (this.extensionPointPluginMap.containsRow((Object)id) && !((Map)this.extensionPointPluginMap.rowMap().get(id)).values().isEmpty()) {
                for (Supplier extensionPoint : this.extensionPointPluginMap.row((Object)id).values()) {
                    ((IExtensionPoint)extensionPoint.get()).callExtensionPoint(log, variables, object);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IExtensionPoint getTableValue(String rowId, String columnId) {
        this.lock.readLock().lock();
        try {
            IExtensionPoint iExtensionPoint = this.extensionPointPluginMap.contains((Object)rowId, (Object)columnId) ? (IExtensionPoint)((Supplier)this.extensionPointPluginMap.get((Object)rowId, (Object)columnId)).get() : null;
            return iExtensionPoint;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    int getNumberOfRows() {
        this.lock.readLock().lock();
        try {
            int n = this.extensionPointPluginMap.rowMap().size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static ILogChannel getLog() {
        if (log == null) {
            log = new LogChannel("ExtensionPointMap");
        }
        return log;
    }

    public void reset() {
        this.lock.writeLock().lock();
        try {
            this.extensionPointPluginMap.clear();
            this.registry.addPluginListener(ExtensionPointPluginType.class, new IPluginTypeListener(){

                @Override
                public void pluginAdded(Object serviceObject) {
                    ExtensionPointMap.this.addExtensionPoint((IPlugin)serviceObject);
                }

                @Override
                public void pluginRemoved(Object serviceObject) {
                    ExtensionPointMap.this.removeExtensionPoint((IPlugin)serviceObject);
                }

                @Override
                public void pluginChanged(Object serviceObject) {
                    ExtensionPointMap.this.removeExtensionPoint((IPlugin)serviceObject);
                    ExtensionPointMap.this.addExtensionPoint((IPlugin)serviceObject);
                }
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private class ExtensionPointLoader
    implements Supplier<IExtensionPoint> {
        private final IPlugin extensionPointPlugin;

        private ExtensionPointLoader(IPlugin extensionPointPlugin) {
            this.extensionPointPlugin = extensionPointPlugin;
        }

        public IExtensionPoint get() {
            try {
                return ExtensionPointMap.this.registry.loadClass(this.extensionPointPlugin, IExtensionPoint.class);
            }
            catch (Exception e) {
                ExtensionPointMap.getLog().logError("Unable to load extension point for name = [" + (this.extensionPointPlugin != null ? this.extensionPointPlugin.getName() : "null") + "]", e);
                return null;
            }
        }
    }
}

