/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.encryption;

import com.google.common.annotations.VisibleForTesting;
import java.math.BigInteger;
import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.ITwoWayPasswordEncoder;
import org.apache.hop.core.encryption.TwoWayPasswordEncoderPlugin;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.StringUtil;

@TwoWayPasswordEncoderPlugin(id="Hop", name="Hop Password Encoder", description="Hop Password Encoder")
public class HopTwoWayPasswordEncoder
implements ITwoWayPasswordEncoder {
    private static final int RADIX = 16;
    private String Seed;
    public static final String PASSWORD_ENCRYPTED_PREFIX = "Encrypted ";

    public HopTwoWayPasswordEncoder() {
        String envSeed;
        this.Seed = envSeed = Const.NVL(EnvUtil.getSystemProperty("HOP_TWO_WAY_PASSWORD_ENCODER_SEED"), "0933910847463829827159347601486730416058");
    }

    @Override
    public void init() throws HopException {
    }

    @Override
    public String encode(String rawPassword) {
        return this.encode(rawPassword, true);
    }

    @Override
    public String encode(String rawPassword, boolean includePrefix) {
        if (includePrefix) {
            return this.encryptPasswordIfNotUsingVariablesInternal(rawPassword);
        }
        return this.encryptPasswordInternal(rawPassword);
    }

    @Override
    public String decode(String encodedPassword) {
        if (encodedPassword != null && encodedPassword.startsWith(PASSWORD_ENCRYPTED_PREFIX)) {
            encodedPassword = encodedPassword.substring(PASSWORD_ENCRYPTED_PREFIX.length());
        }
        return this.decryptPasswordInternal(encodedPassword);
    }

    @Override
    public String decode(String encodedPassword, boolean optionallyEncrypted) {
        if (encodedPassword == null) {
            return null;
        }
        if (optionallyEncrypted) {
            if (encodedPassword.startsWith(PASSWORD_ENCRYPTED_PREFIX)) {
                encodedPassword = encodedPassword.substring(PASSWORD_ENCRYPTED_PREFIX.length());
                return this.decryptPasswordInternal(encodedPassword);
            }
            return encodedPassword;
        }
        return this.decryptPasswordInternal(encodedPassword);
    }

    @VisibleForTesting
    protected String encryptPasswordInternal(String password) {
        if (password == null) {
            return "";
        }
        if (password.length() == 0) {
            return "";
        }
        BigInteger biPasswd = new BigInteger(password.getBytes());
        BigInteger biR0 = new BigInteger(this.getSeed());
        BigInteger biR1 = biR0.xor(biPasswd);
        return biR1.toString(16);
    }

    @VisibleForTesting
    protected String decryptPasswordInternal(String encrypted) {
        if (encrypted == null) {
            return "";
        }
        if (encrypted.length() == 0) {
            return "";
        }
        BigInteger biConfuse = new BigInteger(this.getSeed());
        try {
            BigInteger biR1 = new BigInteger(encrypted, 16);
            BigInteger biR0 = biR1.xor(biConfuse);
            return new String(biR0.toByteArray());
        }
        catch (Exception e) {
            return "";
        }
    }

    @VisibleForTesting
    protected String getSeed() {
        return this.Seed;
    }

    @Override
    public String[] getPrefixes() {
        return new String[]{PASSWORD_ENCRYPTED_PREFIX};
    }

    protected final String encryptPasswordIfNotUsingVariablesInternal(String password) {
        String encryptedPassword = "";
        ArrayList<String> varList = new ArrayList<String>();
        StringUtil.getUsedVariables(password, varList, true);
        encryptedPassword = varList.isEmpty() ? PASSWORD_ENCRYPTED_PREFIX + this.encryptPasswordInternal(password) : password;
        return encryptedPassword;
    }
}

