/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.database.map;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.util.Utils;

public class DatabaseConnectionMap {
    private final ConcurrentMap<String, Database> map = new ConcurrentHashMap<String, Database>();
    private static final DatabaseConnectionMap connectionMap = new DatabaseConnectionMap();

    public static synchronized DatabaseConnectionMap getInstance() {
        return connectionMap;
    }

    private DatabaseConnectionMap() {
    }

    public Database getOrStoreIfAbsent(String connectionGroup, String partitionID, Database database) {
        String key = DatabaseConnectionMap.createEntryKey(connectionGroup, partitionID, database);
        return this.map.putIfAbsent(key, database);
    }

    public void removeConnection(String connectionGroup, String partitionID, Database database) {
        String key = DatabaseConnectionMap.createEntryKey(connectionGroup, partitionID, database);
        this.map.remove(key);
    }

    public static String createEntryKey(String connectionGroup, String partitionID, Database database) {
        StringBuilder key = new StringBuilder(connectionGroup);
        key.append(':').append(database.getDatabaseMeta().getName());
        if (!Utils.isEmpty(partitionID)) {
            key.append(':').append(partitionID);
        }
        return key.toString();
    }

    public Map<String, Database> getMap() {
        return this.map;
    }

    public List<Database> getDatabases(String group) {
        ArrayList<Database> databases = new ArrayList<Database>();
        for (Database database : this.map.values()) {
            if (!database.getConnectionGroup().equals(group)) continue;
            databases.add(database);
        }
        return databases;
    }
}

