/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.database;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaObjectFactory;
import org.apache.hop.core.database.SqlScriptParser;
import org.apache.hop.core.database.SqlScriptStatement;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataObject;

@HopMetadataObject(objectFactory=DatabaseMetaObjectFactory.class)
public interface IDatabase
extends Cloneable {
    public String getPluginId();

    public void setPluginId(String var1);

    public String getPluginName();

    public void setPluginName(String var1);

    public int getAccessType();

    public void setAccessType(int var1);

    public boolean isChanged();

    public void setChanged(boolean var1);

    public String getDatabaseName();

    public void setDatabaseName(String var1);

    public String getHostname();

    public void setHostname(String var1);

    public String getUsername();

    public void setUsername(String var1);

    public String getPassword();

    public void setPassword(String var1);

    public String getServername();

    public void setServername(String var1);

    public String getDataTablespace();

    public void setDataTablespace(String var1);

    public String getIndexTablespace();

    public void setIndexTablespace(String var1);

    public Map<String, String> getAttributes();

    public void setAttributes(Map<String, String> var1);

    default public void addAttribute(String attributeId, String value) {
    }

    default public String getAttribute(String attributeId, String defaultValue) {
        return "";
    }

    public boolean supportsSetCharacterStream();

    public boolean supportsAutoInc();

    public String getFieldDefinition(IValueMeta var1, String var2, String var3, boolean var4, boolean var5, boolean var6);

    public int[] getAccessTypeList();

    public int getDefaultDatabasePort();

    public Map<String, String> getDefaultOptions();

    public String getLimitClause(int var1);

    public String getSqlQueryFields(String var1);

    public int getNotFoundTK(boolean var1);

    public String getDriverClass();

    public String getURL(String var1, String var2, String var3) throws HopDatabaseException;

    public boolean supportsSequences();

    public String getSqlNextSequenceValue(String var1);

    public String getSqlCurrentSequenceValue(String var1);

    public String getSqlSequenceExists(String var1);

    public boolean isFetchSizeSupported();

    public boolean supportsTransactions();

    public boolean supportsBitmapIndex();

    public boolean supportsSetLong();

    public boolean supportsSchemas();

    public boolean supportsCatalogs();

    public boolean supportsEmptyTransactions();

    public boolean needsPlaceHolder();

    public String getFunctionSum();

    public String getFunctionAverage();

    public String getFunctionMinimum();

    public String getFunctionMaximum();

    public String getFunctionCount();

    public String getSchemaTableCombination(String var1, String var2);

    public int getMaxTextFieldLength();

    public int getMaxVARCHARLength();

    public String getAddColumnStatement(String var1, IValueMeta var2, String var3, boolean var4, String var5, boolean var6);

    public String getDropColumnStatement(String var1, IValueMeta var2, String var3, boolean var4, String var5, boolean var6);

    public String getModifyColumnStatement(String var1, IValueMeta var2, String var3, boolean var4, String var5, boolean var6);

    public Object clone();

    public String[] getReservedWords();

    public boolean quoteReservedWords();

    public String getStartQuote();

    public String getEndQuote();

    public String[] getTableTypes();

    public String[] getViewTypes();

    public String[] getSynonymTypes();

    public boolean useSchemaNameForTableList();

    public boolean supportsViews();

    public boolean supportsSynonyms();

    public String getSqlListOfProcedures();

    public String getTruncateTableStatement(String var1);

    public boolean supportsFloatRoundingOnUpdate();

    public String getSqlLockTables(String[] var1);

    public String getSqlUnlockTables(String[] var1);

    public boolean supportsTimeStampToDateConversion();

    public boolean supportsBatchUpdates();

    public boolean supportsBooleanDataType();

    public void setSupportsBooleanDataType(boolean var1);

    public boolean preserveReservedCase();

    public void setPreserveReservedCase(boolean var1);

    public boolean isDefaultingToUppercase();

    public Map<String, String> getExtraOptions();

    public void addExtraOption(String var1, String var2, String var3);

    public String getExtraOptionSeparator();

    public String getExtraOptionValueSeparator();

    public String getExtraOptionIndicator();

    public boolean supportsOptionsInURL();

    public String getExtraOptionsHelpText();

    public boolean supportsGetBlob();

    public String getConnectSql();

    public void setConnectSql(String var1);

    public boolean supportsSetMaxRows();

    public String getSqlTableExists(String var1);

    public String getSqlColumnExists(String var1, String var2);

    public boolean isStreamingResults();

    public void setStreamingResults(boolean var1);

    public boolean isQuoteAllFields();

    public void setQuoteAllFields(boolean var1);

    public boolean isForcingIdentifiersToLowerCase();

    public void setForcingIdentifiersToLowerCase(boolean var1);

    public boolean isForcingIdentifiersToUpperCase();

    public void setForcingIdentifiersToUpperCase(boolean var1);

    public boolean isUsingDoubleDecimalAsSchemaTableSeparator();

    public void setUsingDoubleDecimalAsSchemaTableSeparator(boolean var1);

    public boolean isRequiringTransactionsOnQueries();

    public boolean isStrictBigNumberInterpretation();

    public String getDatabaseFactoryName();

    public String getPreferredSchemaName();

    public void setPreferredSchemaName(String var1);

    public boolean checkIndexExists(Database var1, String var2, String var3, String[] var4) throws HopDatabaseException;

    public boolean supportsSequenceNoMaxValueOption();

    public boolean requiresCreateTablePrimaryKeyAppend();

    public boolean requiresCastToVariousForIsNull();

    public boolean isDisplaySizeTwiceThePrecision();

    public boolean supportsPreparedStatementMetadataRetrieval();

    public boolean isSystemTable(String var1);

    public boolean supportsNewLinesInSql();

    public String getSqlListOfSchemas();

    public int getMaxColumnsInIndex();

    public boolean supportsErrorHandlingOnBatchUpdates();

    public String getSqlInsertAutoIncUnknownDimensionRow(String var1, String var2, String var3);

    public boolean isExplorable();

    public String getSqlListOfSequences();

    public String quoteSqlString(String var1);

    public String getSelectCountStatement(String var1);

    public String generateColumnAlias(int var1, String var2);

    public List<String> parseStatements(String var1);

    public List<SqlScriptStatement> getSqlScriptStatements(String var1);

    public boolean isMySqlVariant();

    public boolean isPostgresVariant();

    public boolean isSybaseVariant();

    public boolean isSybaseIQVariant();

    public boolean isNeoviewVariant();

    public boolean isExasolVariant();

    public boolean isInformixVariant();

    public boolean isMsSqlServerNativeVariant();

    public boolean isMsSqlServerVariant();

    public boolean isOracleVariant();

    public boolean isNetezzaVariant();

    public boolean isSqliteVariant();

    public boolean isTeradataVariant();

    public boolean releaseSavepoint();

    public String getDataTablespaceDDL(IVariables var1, DatabaseMeta var2);

    public String getIndexTablespaceDDL(IVariables var1, DatabaseMeta var2);

    public Object getValueFromResultSet(ResultSet var1, IValueMeta var2, int var3) throws HopDatabaseException;

    public boolean useSafePoints();

    public boolean supportsErrorHandling();

    public String getSqlValue(IValueMeta var1, Object var2, String var3) throws HopValueException;

    public boolean supportsResultSetMetadataRetrievalOnly();

    public boolean supportsTimestampDataType();

    public void setSupportsTimestampDataType(boolean var1);

    public String getSafeFieldname(String var1);

    public String getSequenceNoMaxValueOption();

    public boolean supportsAutoGeneratedKeys();

    public IValueMeta customizeValueFromSqlType(IValueMeta var1, ResultSetMetaData var2, int var3) throws SQLException;

    public String getCreateTableStatement();

    default public void addDefaultOptions() {
    }

    default public SqlScriptParser createSqlScriptParser() {
        return new SqlScriptParser(true);
    }

    default public boolean supportsStandardTableOutput() {
        return true;
    }

    default public String getUnsupportedTableOutputMessage() {
        return "";
    }

    default public String getLegacyColumnName(DatabaseMetaData dbMetaData, ResultSetMetaData rsMetaData, int index) throws HopDatabaseException {
        return "";
    }

    public String getDropTableIfExistsStatement(String var1);

    public boolean fullExceptionLog(Exception var1);

    public String getPort();

    public void setPort(String var1);

    public String getManualUrl();

    public void setManualUrl(String var1);

    public boolean requiresName();
}

