/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.database;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.database.Catalog;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.Schema;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;

public class DatabaseMetaInformation {
    private static final Class<?> PKG = Database.class;
    private String[] tables;
    private Map<String, Collection<String>> tableMap;
    private String[] views;
    private Map<String, Collection<String>> viewMap;
    private String[] synonyms;
    private Map<String, Collection<String>> synonymMap;
    private Catalog[] catalogs;
    private Schema[] schemas;
    private String[] procedures;
    private IVariables variables;
    private DatabaseMeta databaseMeta;
    public static final String FILTER_CATALOG_LIST = "FILTER_CATALOG_LIST";
    public static final String FILTER_SCHEMA_LIST = "FILTER_SCHEMA_LIST";

    public DatabaseMetaInformation(IVariables variables, DatabaseMeta databaseMeta) {
        this.variables = variables;
        this.databaseMeta = databaseMeta;
    }

    public void getData(ILoggingObject parentLoggingObject, IProgressMonitor monitor) throws HopDatabaseException {
        if (monitor != null) {
            monitor.beginTask(BaseMessages.getString(PKG, "DatabaseMeta.Info.GettingInfoFromDb", new String[0]), 8);
        }
        Database db = new Database(parentLoggingObject, this.variables, this.databaseMeta);
        try {
            String tableName;
            int i;
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, "DatabaseMeta.Info.ConnectingDb", new String[0]));
            }
            db.connect();
            if (monitor != null) {
                monitor.worked(1);
            }
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, "DatabaseMeta.Info.GettingMetaData", new String[0]));
            }
            DatabaseMetaData dbmd = db.getDatabaseMetaData();
            if (monitor != null) {
                monitor.worked(1);
            }
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, "DatabaseMeta.Info.GettingInfo", new String[0]));
            }
            Map<String, String> connectionExtraOptions = this.databaseMeta.getExtraOptions();
            if (this.databaseMeta.supportsCatalogs() && dbmd.supportsCatalogsInTableDefinitions()) {
                ArrayList<Catalog> catalogList = new ArrayList<Catalog>();
                String catalogFilterKey = this.databaseMeta.getPluginId() + "." + FILTER_CATALOG_LIST;
                if (connectionExtraOptions != null && connectionExtraOptions.containsKey(catalogFilterKey)) {
                    String catsFilterCommaList = connectionExtraOptions.get(catalogFilterKey);
                    String[] catsFilterArray = catsFilterCommaList.split(",");
                    for (i = 0; i < catsFilterArray.length; ++i) {
                        catalogList.add(new Catalog(catsFilterArray[i].trim()));
                    }
                }
                if (catalogList.isEmpty()) {
                    ResultSet catalogResultSet = dbmd.getCatalogs();
                    while (catalogResultSet != null && catalogResultSet.next()) {
                        String catalogName = catalogResultSet.getString(1);
                        catalogList.add(new Catalog(catalogName));
                    }
                    catalogResultSet.close();
                }
                for (Catalog catalog : catalogList) {
                    ArrayList<String> catalogTables = new ArrayList<String>();
                    try {
                        ResultSet catalogTablesResultSet = dbmd.getTables(catalog.getCatalogName(), null, null, null);
                        while (catalogTablesResultSet.next()) {
                            tableName = catalogTablesResultSet.getString(3);
                            if (db.isSystemTable(tableName)) continue;
                            catalogTables.add(tableName);
                        }
                        catalogTablesResultSet.close();
                        Collections.sort(catalogTables);
                    }
                    catch (Exception catalogTablesResultSet) {
                        // empty catch block
                    }
                    catalog.setItems(catalogTables.toArray(new String[catalogTables.size()]));
                }
                this.setCatalogs(catalogList.toArray(new Catalog[catalogList.size()]));
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, "DatabaseMeta.Info.GettingSchemaInfo", new String[0]));
            }
            if (this.databaseMeta.supportsSchemas() && dbmd.supportsSchemasInTableDefinitions()) {
                ArrayList<Schema> schemaList = new ArrayList<Schema>();
                try {
                    String schemaFilterKey = this.databaseMeta.getPluginId() + "." + FILTER_SCHEMA_LIST;
                    if (connectionExtraOptions != null && connectionExtraOptions.containsKey(schemaFilterKey)) {
                        String schemasFilterCommaList = connectionExtraOptions.get(schemaFilterKey);
                        String[] schemasFilterArray = schemasFilterCommaList.split(",");
                        for (i = 0; i < schemasFilterArray.length; ++i) {
                            schemaList.add(new Schema(schemasFilterArray[i].trim()));
                        }
                    }
                    if (schemaList.isEmpty()) {
                        String sql = this.databaseMeta.getSqlListOfSchemas();
                        if (!Utils.isEmpty(sql)) {
                            Statement schemaStatement = db.getConnection().createStatement();
                            ResultSet schemaResultSet = schemaStatement.executeQuery(sql);
                            while (schemaResultSet != null && schemaResultSet.next()) {
                                String schemaName = schemaResultSet.getString("name");
                                schemaList.add(new Schema(schemaName));
                            }
                            schemaResultSet.close();
                            schemaStatement.close();
                        } else {
                            ResultSet schemaResultSet = dbmd.getSchemas();
                            while (schemaResultSet != null && schemaResultSet.next()) {
                                String schemaName = schemaResultSet.getString(1);
                                schemaList.add(new Schema(schemaName));
                            }
                            schemaResultSet.close();
                        }
                    }
                    for (Schema schema : schemaList) {
                        ArrayList<String> schemaTables = new ArrayList<String>();
                        try {
                            ResultSet schemaTablesResultSet = dbmd.getTables(null, schema.getSchemaName(), null, null);
                            while (schemaTablesResultSet.next()) {
                                tableName = schemaTablesResultSet.getString(3);
                                if (db.isSystemTable(tableName)) continue;
                                schemaTables.add(tableName);
                            }
                            schemaTablesResultSet.close();
                            Collections.sort(schemaTables);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        schema.setItems(schemaTables.toArray(new String[schemaTables.size()]));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setSchemas(schemaList.toArray(new Schema[schemaList.size()]));
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, "DatabaseMeta.Info.GettingTables", new String[0]));
            }
            this.setTables(db.getTablenames(this.databaseMeta.supportsSchemas()));
            this.setTableMap(db.getTableMap());
            if (monitor != null) {
                monitor.worked(1);
            }
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, "DatabaseMeta.Info.GettingViews", new String[0]));
            }
            if (this.databaseMeta.supportsViews()) {
                this.setViews(db.getViews(this.databaseMeta.supportsSchemas()));
                this.setViewMap(db.getViewMap());
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, "DatabaseMeta.Info.GettingSynonyms", new String[0]));
            }
            if (this.databaseMeta.supportsSynonyms()) {
                this.setSynonyms(db.getSynonyms(this.databaseMeta.supportsSchemas()));
                this.setSynonymMap(db.getSynonymMap());
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, "DatabaseMeta.Info.GettingProcedures", new String[0]));
            }
            this.setProcedures(db.getProcedures());
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        catch (Exception e) {
            throw new HopDatabaseException(BaseMessages.getString(PKG, "DatabaseMeta.Error.UnableRetrieveDbInfo", new String[0]), e);
        }
        finally {
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, "DatabaseMeta.Info.ClosingDbConnection", new String[0]));
            }
            db.disconnect();
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    public String[] getTables() {
        return this.tables;
    }

    public void setTables(String[] tables) {
        this.tables = tables;
    }

    public Map<String, Collection<String>> getTableMap() {
        return this.tableMap;
    }

    public void setTableMap(Map<String, Collection<String>> tableMap) {
        this.tableMap = tableMap;
    }

    public String[] getViews() {
        return this.views;
    }

    public void setViews(String[] views) {
        this.views = views;
    }

    public Map<String, Collection<String>> getViewMap() {
        return this.viewMap;
    }

    public void setViewMap(Map<String, Collection<String>> viewMap) {
        this.viewMap = viewMap;
    }

    public String[] getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(String[] synonyms) {
        this.synonyms = synonyms;
    }

    public Map<String, Collection<String>> getSynonymMap() {
        return this.synonymMap;
    }

    public void setSynonymMap(Map<String, Collection<String>> synonymMap) {
        this.synonymMap = synonymMap;
    }

    public Catalog[] getCatalogs() {
        return this.catalogs;
    }

    public void setCatalogs(Catalog[] catalogs) {
        this.catalogs = catalogs;
    }

    public Schema[] getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Schema[] schemas) {
        this.schemas = schemas;
    }

    public String[] getProcedures() {
        return this.procedures;
    }

    public void setProcedures(String[] procedures) {
        this.procedures = procedures;
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }
}

