/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.config.plugin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.config.ConfigFileSerializer;
import org.apache.hop.core.config.ConfigNoFileSerializer;
import org.apache.hop.core.config.DescribedVariable;
import org.apache.hop.core.config.IConfigFile;
import org.apache.hop.core.config.IHopConfigSerializer;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;

public abstract class ConfigFile
implements IConfigFile {
    public static final String HOP_VARIABLES_KEY = "variables";
    public static final String HOP_CONFIG_KEY = "config";
    @JsonProperty(value="config")
    protected Map<String, Object> configMap = new HashMap<String, Object>();
    @JsonIgnore
    protected IHopConfigSerializer serializer = new ConfigNoFileSerializer();

    public ConfigFile() {
    }

    public void readFromFile() throws HopException {
        try {
            if (new File(this.getConfigFilename()).exists()) {
                this.serializer = new ConfigFileSerializer();
            } else {
                boolean createWhenMissing = "Y".equalsIgnoreCase(System.getProperty("HOP_AUTO_CREATE_CONFIG", "N"));
                if (createWhenMissing) {
                    System.out.println("Creating new default Hop configuration file: " + this.getConfigFilename());
                    this.serializer = new ConfigFileSerializer();
                } else {
                    System.out.println("Hop configuration file not found, not serializing: " + this.getConfigFilename());
                    this.serializer = new ConfigNoFileSerializer();
                }
            }
            this.configMap = this.serializer.readFromFile(this.getConfigFilename());
        }
        catch (Exception e) {
            throw new HopException("Unable to read config file '" + this.getConfigFilename() + "'", e);
        }
    }

    public void saveToFile() throws HopException {
        try {
            this.serializer.writeToFile(this.getConfigFilename(), this.configMap);
        }
        catch (Exception e) {
            throw new HopException("Error saving configuration file '" + this.getConfigFilename() + "'", e);
        }
    }

    public ConfigFile(String filename, List<DescribedVariable> describedVariables) {
        this();
        this.setConfigFilename(filename);
        this.configMap.put(HOP_VARIABLES_KEY, describedVariables);
    }

    @Override
    @JsonIgnore
    public List<DescribedVariable> getDescribedVariables() {
        Object variablesObject;
        ArrayList<DescribedVariable> variables = new ArrayList<DescribedVariable>();
        Map configObj = (Map)this.configMap.get(HOP_CONFIG_KEY);
        if (configObj != null) {
            this.configMap = configObj;
        }
        if ((variablesObject = this.configMap.get(HOP_VARIABLES_KEY)) != null) {
            try {
                for (Object dvObject : (List)variablesObject) {
                    String dvJson = new Gson().toJson(dvObject);
                    DescribedVariable describedVariable = (DescribedVariable)new ObjectMapper().readValue(dvJson, DescribedVariable.class);
                    variables.add(describedVariable);
                }
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error parsing described variables from configuration file '" + this.getConfigFilename() + "'", e);
                variables = new ArrayList();
            }
        }
        this.configMap.put(HOP_VARIABLES_KEY, variables);
        return variables;
    }

    @Override
    public DescribedVariable findDescribedVariable(String name) {
        for (DescribedVariable describedVariable : this.getDescribedVariables()) {
            if (!describedVariable.getName().equals(name)) continue;
            return describedVariable;
        }
        return null;
    }

    @Override
    public void setDescribedVariable(DescribedVariable variable) {
        for (DescribedVariable describedVariable : this.getDescribedVariables()) {
            if (!describedVariable.getName().equals(variable.getName())) continue;
            describedVariable.setValue(variable.getValue());
            describedVariable.setDescription(variable.getDescription());
            return;
        }
        this.getDescribedVariables().add(variable);
    }

    @Override
    public String findDescribedVariableValue(String name) {
        DescribedVariable describedVariable = this.findDescribedVariable(name);
        if (describedVariable == null) {
            return null;
        }
        return describedVariable.getValue();
    }

    @Override
    public void setDescribedVariables(List<DescribedVariable> describedVariables) {
        this.configMap.put(HOP_VARIABLES_KEY, describedVariables);
    }

    @Override
    public abstract String getConfigFilename();

    @Override
    public abstract void setConfigFilename(String var1);

    public Map<String, Object> getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map<String, Object> configMap) {
        this.configMap = configMap;
    }

    public IHopConfigSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(IHopConfigSerializer serializer) {
        this.serializer = serializer;
    }
}

