/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.config.IHopConfigSerializer;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.vfs.HopVfs;

public class ConfigFileSerializer
implements IHopConfigSerializer {
    @Override
    public void writeToFile(String filename, Map<String, Object> configMap) throws HopException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String niceJson = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(configMap);
            FileObject newFile = HopVfs.getFileObject(filename + ".new");
            if (newFile.exists() && !newFile.delete()) {
                throw new HopException("Unable to delete new config file " + newFile.getName().getURI());
            }
            OutputStream outputStream = HopVfs.getOutputStream(newFile, false);
            outputStream.write(niceJson.getBytes(StandardCharsets.UTF_8));
            outputStream.close();
            FileObject oldFile = HopVfs.getFileObject(filename + ".old");
            if (oldFile.exists() && !oldFile.delete()) {
                throw new HopException("Unable to delete old config file " + oldFile.getName().getURI());
            }
            FileObject file = HopVfs.getFileObject(filename);
            if (file.exists() && !file.canRenameTo(oldFile)) {
                throw new HopException("Unable to rename config file to .old : " + file.getName().getURI());
            }
            newFile.moveTo(file);
        }
        catch (Exception e) {
            throw new HopException("Error writing to Hop configuration file : " + filename, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> readFromFile(String filename) throws HopException {
        try {
            FileObject file = HopVfs.getFileObject(filename);
            if (!file.exists()) {
                return new HashMap<String, Object>();
            }
            ObjectMapper objectMapper = new ObjectMapper();
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            try (InputStream inputStream = HopVfs.getInputStream(file);){
                HashMap configMap;
                HashMap hashMap = configMap = (HashMap)objectMapper.readValue(inputStream, (TypeReference)typeRef);
                return hashMap;
            }
        }
        catch (Exception e) {
            throw new HopException("Error reading Hop configuration file " + filename, e);
        }
    }
}

