/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.util.Date;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.w3c.dom.Node;

public class ResultFile
implements Cloneable {
    private static final Class<?> PKG = Const.class;
    public static final int FILE_TYPE_GENERAL = 0;
    public static final int FILE_TYPE_LOG = 1;
    public static final int FILE_TYPE_ERRORLINE = 2;
    public static final int FILE_TYPE_ERROR = 3;
    public static final int FILE_TYPE_WARNING = 4;
    public static final String[] fileTypeCode = new String[]{"GENERAL", "LOG", "ERRORLINE", "ERROR", "WARNING"};
    public static final String[] fileTypeDesc = new String[]{BaseMessages.getString(PKG, "ResultFile.FileType.General", new String[0]), BaseMessages.getString(PKG, "ResultFile.FileType.Log", new String[0]), BaseMessages.getString(PKG, "ResultFile.FileType.ErrorLine", new String[0]), BaseMessages.getString(PKG, "ResultFile.FileType.Error", new String[0]), BaseMessages.getString(PKG, "ResultFile.FileType.Warning", new String[0])};
    private static final String XML_TAG = "result-file";
    private int type;
    private FileObject file;
    private String originParent;
    private String origin;
    private String comment;
    private Date timestamp;

    public ResultFile(int type, FileObject file, String originParent, String origin) {
        this.type = type;
        this.file = file;
        this.originParent = originParent;
        this.origin = origin;
        this.timestamp = new Date();
    }

    public String toString() {
        return this.file.toString() + " - " + this.getTypeDesc() + " - " + XmlHandler.date2string(this.timestamp) + (this.origin == null ? "" : " - " + this.origin) + (this.originParent == null ? "" : " - " + this.originParent);
    }

    protected ResultFile clone() throws CloneNotSupportedException {
        return (ResultFile)super.clone();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public FileObject getFile() {
        return this.file;
    }

    public void setFile(FileObject file) {
        this.file = file;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getOriginParent() {
        return this.originParent;
    }

    public void setOriginParent(String originParent) {
        this.originParent = originParent;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getTypeDesc() {
        return fileTypeDesc[this.type];
    }

    public String getTypeCode() {
        return fileTypeCode[this.type];
    }

    public static final int getType(String typeString) {
        int idx = Const.indexOfString(typeString, fileTypeDesc);
        if (idx >= 0) {
            return idx;
        }
        idx = Const.indexOfString(typeString, fileTypeCode);
        if (idx >= 0) {
            return idx;
        }
        return 0;
    }

    public static final String getTypeCode(int fileType) {
        return fileTypeCode[fileType];
    }

    public static final String getTypeDesc(int fileType) {
        return fileTypeDesc[fileType];
    }

    public static final String[] getAllTypeDesc() {
        return fileTypeDesc;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public RowMetaAndData getRow() {
        RowMetaAndData row = new RowMetaAndData();
        row.addValue(new ValueMetaString("type"), this.getTypeDesc());
        row.addValue(new ValueMetaString("filename"), this.file.getName().getBaseName());
        row.addValue(new ValueMetaString("path"), this.file.getName().getURI());
        row.addValue(new ValueMetaString("parentorigin"), this.originParent);
        row.addValue(new ValueMetaString("origin"), this.origin);
        row.addValue(new ValueMetaString("comment"), this.comment);
        row.addValue(new ValueMetaDate("timestamp"), this.timestamp);
        return row;
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.openTag(XML_TAG));
        xml.append(XmlHandler.addTagValue("type", this.getTypeCode()));
        xml.append(XmlHandler.addTagValue("file", this.file.getName().toString()));
        xml.append(XmlHandler.addTagValue("parentorigin", this.originParent));
        xml.append(XmlHandler.addTagValue("origin", this.origin));
        xml.append(XmlHandler.addTagValue("comment", this.comment));
        xml.append(XmlHandler.addTagValue("timestamp", this.timestamp));
        xml.append(XmlHandler.closeTag(XML_TAG));
        return xml.toString();
    }

    public ResultFile(Node node) throws HopFileException {
        try {
            this.type = ResultFile.getType(XmlHandler.getTagValue(node, "type"));
            this.file = HopVfs.getFileObject(XmlHandler.getTagValue(node, "file"));
            this.originParent = XmlHandler.getTagValue(node, "parentorigin");
            this.origin = XmlHandler.getTagValue(node, "origin");
            this.comment = XmlHandler.getTagValue(node, "comment");
            this.timestamp = XmlHandler.stringToDate(XmlHandler.getTagValue(node, "timestamp"));
        }
        catch (Exception e) {
            throw new HopFileException(e);
        }
    }
}

