/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCacheEntry;
import org.apache.hop.core.exception.HopEofException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;

public class DbCache {
    private static DbCache dbCache;
    private Hashtable<DbCacheEntry, IRowMeta> cache;
    private boolean usecache;
    private ILogChannel log;

    public void setActive() {
        this.setActive(true);
    }

    public void setInactive() {
        this.setActive(false);
    }

    public void setActive(boolean act) {
        this.usecache = act;
    }

    public boolean isActive() {
        return this.usecache;
    }

    public void put(DbCacheEntry entry, IRowMeta fields) {
        if (!this.usecache) {
            return;
        }
        IRowMeta copy = fields.clone();
        this.cache.put(entry, copy);
    }

    public IRowMeta get(DbCacheEntry entry) {
        if (!this.usecache) {
            return null;
        }
        IRowMeta fields = this.cache.get(entry);
        if (fields != null) {
            fields = fields.clone();
        }
        return fields;
    }

    public int size() {
        return this.cache.size();
    }

    public void clear(String dbname) {
        if (dbname == null) {
            this.cache = new Hashtable();
            this.setActive();
        } else {
            Enumeration<DbCacheEntry> keys = this.cache.keys();
            while (keys.hasMoreElements()) {
                DbCacheEntry entry = keys.nextElement();
                if (!entry.sameDB(dbname)) continue;
                this.cache.remove(entry);
            }
        }
    }

    public String getFilename() {
        return Const.HOP_AUDIT_FOLDER + Const.FILE_SEPARATOR + "db.cache";
    }

    private DbCache() throws HopFileException {
        block34: {
            try {
                this.clear(null);
                this.log = new LogChannel("DbCache");
                String filename = this.getFilename();
                File file = new File(filename);
                if (file.canRead()) {
                    this.log.logDetailed("Loading database cache from file: [" + filename + "]");
                    try (FileInputStream fis = new FileInputStream(file);){
                        DataInputStream dis = new DataInputStream(fis);
                        Throwable throwable = null;
                        try {
                            int counter = 0;
                            try {
                                while (true) {
                                    DbCacheEntry entry = new DbCacheEntry(dis);
                                    RowMeta row = new RowMeta(dis);
                                    this.cache.put(entry, row);
                                    ++counter;
                                }
                            }
                            catch (HopEofException eof) {
                                this.log.logDetailed("We read " + counter + " cached rows from the database cache!");
                                if (dis != null) {
                                    if (throwable != null) {
                                        try {
                                            dis.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    } else {
                                        dis.close();
                                    }
                                }
                                break block34;
                            }
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (dis != null) {
                                    if (throwable != null) {
                                        try {
                                            dis.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        dis.close();
                                    }
                                }
                                throw throwable4;
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new Exception(e);
                    }
                }
                this.log.logDetailed("The database cache doesn't exist yet.");
            }
            catch (Exception e) {
                throw new HopFileException("Couldn't read the database cache", e);
            }
        }
    }

    public void saveCache() throws HopFileException {
        block31: {
            try {
                String filename = this.getFilename();
                File file = new File(filename);
                if (!file.exists() || file.canWrite()) {
                    try (FileOutputStream fos = new FileOutputStream(file);
                         DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(fos, 10000));){
                        int counter = 0;
                        Enumeration<DbCacheEntry> keys = this.cache.keys();
                        while (keys.hasMoreElements()) {
                            DbCacheEntry entry = keys.nextElement();
                            entry.write(dos);
                            IRowMeta rowMeta = this.get(entry);
                            if (rowMeta != null) {
                                rowMeta.writeMeta(dos);
                                ++counter;
                                continue;
                            }
                            throw new HopFileException("The database cache contains an empty row. We can't save this!");
                        }
                        this.log.logDetailed("We wrote " + counter + " cached rows to the database cache!");
                        break block31;
                    }
                    catch (Exception e) {
                        throw new Exception(e);
                    }
                }
                throw new HopFileException("We can't write to the cache file: " + filename);
            }
            catch (Exception e) {
                throw new HopFileException("Couldn't write to the database cache", e);
            }
        }
    }

    public static final DbCache getInstance() {
        if (dbCache != null) {
            return dbCache;
        }
        try {
            dbCache = new DbCache();
        }
        catch (HopFileException kfe) {
            throw new RuntimeException("Unable to create the database cache: " + kfe.getMessage());
        }
        return dbCache;
    }
}

