/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.RJob;
import com.ibm.as400.resource.RJobLog;
import com.ibm.as400.resource.RQueuedMessage;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.ResourceProperties;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VJobLogMessage;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VResourcePropertiesPane;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VJob
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static String description_ = ResourceLoader.getText("JOB_DESCRIPTION");
    private static Icon icon16_ = ResourceLoader.getIcon("VJob16.gif", description_);
    private static Icon icon32_ = ResourceLoader.getIcon("VJob32.gif", description_);
    private static String dateColumnHeader_ = ResourceLoader.getText("MESSAGE_DATE");
    private static String fromProgramColumnHeader_ = ResourceLoader.getText("MESSAGE_FROM_PROGRAM");
    private static String nameColumnHeader_ = ResourceLoader.getText("MESSAGE_ID");
    private static String textColumnHeader_ = ResourceLoader.getText("MESSAGE_TEXT");
    private static String typeColumnHeader_ = ResourceLoader.getText("MESSAGE_TYPE");
    private static String severityColumnHeader_ = ResourceLoader.getText("MESSAGE_SEVERITY");
    private VNode parent_ = null;
    private RJob job_ = null;
    private RJobLog jobLog_ = null;
    private transient VAction[] actions_;
    private static TableColumnModel detailsColumnModel_ = null;
    private transient VObject[] detailsChildren_;
    private transient boolean loaded_;
    private transient VPropertiesPane propertiesPane_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;
    public static final Object BREAK_MESSAGE_HANDLING_PROPERTY = "BreakMessageHandling";
    public static final Object CCSID_PROPERTY = "CCSID";
    public static final Object COMPLETION_STATUS_PROPERTY = "CompletionStatus";
    public static final Object COUNTRY_ID_PROPERTY = "CountryID";
    public static final Object CPUUSED_PROPERTY = "CPUUsed";
    public static final Object CURRENT_LIBRARY_EXISTENCE_PROPERTY = "CurrentLibraryExistence";
    public static final Object CURRENT_LIBRARY_PROPERTY = "CurrentLibrary";
    public static final Object DATE_FORMAT_PROPERTY = "DateFormat";
    public static final Object DATE_JOB_BECAME_ACTIVE_PROPERTY = "DateJobBecomeActive";
    public static final Object DATE_JOB_ENTERED_SYSTEM_PROPERTY = "DateJobEnterSystem";
    public static final Object DATE_JOB_SCHEDULE_TO_RUN_PROPERTY = "DateScheduleRun";
    public static final Object DATE_PROPERTY = "Date";
    public static final Object DATE_PUT_ON_JOB_QUEUE_PROPERTY = "DatePutOnJobQueue";
    public static final Object DATE_SEPARATOR_PROPERTY = "DateSeparator";
    public static final Object DDM_CONVERSATION_HANDLING_PROPERTY = "DDMConversationHandling";
    public static final Object DECIMAL_FORMAT_PROPERTY = "DecimalFormat";
    public static final Object DEFAULT_CCSID_PROPERTY = "DefaultCCSID";
    public static final Object DEVICE_RECOVERY_ACTION_PROPERTY = "DeviceRecoveryAction";
    public static final Object END_SEVERITY_PROPERTY = "EndSeverity";
    public static final Object FUNCTION_PROPERTY = "Function";
    public static final Object INQUIRY_MESSAGE_REPLY_PROPERTY = "InquiryMessageReply";
    public static final Object JOB_ACCOUNTING_CODE_PROPERTY = "JobAccountingCode";
    public static final Object JOB_DATE_PROPERTY = "JobDate";
    public static final Object JOB_DESCRIPTION_PROPERTY = "JobDescription";
    public static final Object JOB_MESSAGE_QUEUE_FULL_ACTION_PROPERTY = "JobMessageQueueFullAction";
    public static final Object JOB_MESSAGE_QUEUE_MAXIMUM_SIZE_PROPERTY = "JobMessageQueueMaximumSize";
    public static final Object JOB_QUEUE_PRIORITY_PROPERTY = "JobQueuePriority";
    public static final Object JOB_QUEUE_PROPERTY = "JobQueue";
    public static final Object JOB_SWITCHES_PROPERTY = "JobSwitches";
    public static final Object LANGUAGE_ID_PROPERTY = "LanguageID";
    public static final Object LOGGING_CL_PROGRAMS_PROPERTY = "LoggingCLPrograms";
    public static final Object LOGGING_LEVEL_PROPERTY = "LoggingLevel";
    public static final Object LOGGING_SEVERITY_PROPERTY = "LoggingSeverity";
    public static final Object LOGGING_TEXT_PROPERTY = "LoggingText";
    public static final Object MODE_NAME_PROPERTY = "ModeName";
    public static final Object NUMBER_PROPERTY = "Number";
    public static final Object NUMBER_OF_LIBRARIES_IN_SYSLIBL_PROPERTY = "NumberOfLibrariesInSYSLIBL";
    public static final Object NUMBER_OF_LIBRARIES_IN_USRLIBL_PROPERTY = "NumberOfLibrariesInUSRLIBL";
    public static final Object NUMBER_OF_PRODUCT_LIBRARIES_PROPERTY = "NumberOfProductLibraries";
    public static final Object OUTPUT_QUEUE_PRIORITY_PROPERTY = "OutputQueue";
    public static final Object OUTPUT_QUEUE_PROPERTY = "OutputQueue";
    public static final Object PRINT_KEY_FORMAT_PROPERTY = "PrintKeyFormat";
    public static final Object PRINT_TEXT_PROPERTY = "PrintText";
    public static final Object PRINTER_DEVICE_NAME_PROPERTY = "PrinterDeviceName";
    public static final Object PRODUCT_LIBRARIES_PROPERTY = "ProductLibraries";
    public static final Object ROUTING_DATA_PROPERTY = "RoutingData";
    public static final Object SIGNED_ON_JOB_PROPERTY = "SignedOnJob";
    public static final Object SORT_SEQUENCE_TABLE_PROPERTY = "SortSequenceTable";
    public static final Object STATUS_OF_JOB_ON_JOB_QUEUE_PROPERTY = "StatusOfJobOnJobQueue";
    public static final Object STATUS_MESSAGE_HANDLING_PROPERTY = "StatusMessageHandling";
    public static final Object STATUS_PROPERTY = "Status";
    public static final Object SUBSYSTEM_PROPERTY = "Subsystem";
    public static final Object SUBTYPE_PROPERTY = "Subtype";
    public static final Object SYSTEM_LIBRARY_LIST_PROPERTY = "SystemLibraryList";
    public static final Object TIME_SEPARATOR_PROPERTY = "TimeSeparator";
    public static final Object TYPE_PROPERTY = "Type";
    public static final Object WORK_ID_UNIT_PROPERTY = "WorkIDUnit";
    public static final Object USER_LIBRARY_LIST_PROPERTY = "UserLibraryList";
    public static final Object USER_PROPERTY = "User";
    private static final Hashtable map_ = new Hashtable();
    private static ResourceProperties properties_;

    public VJob() {
        this.job_ = new RJob();
        this.jobLog_ = new RJobLog();
        this.initializeTransient();
    }

    public VJob(AS400 aS400, Job job) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (job == null) {
            throw new NullPointerException("job");
        }
        this.job_ = new RJob(aS400, job.getName(), job.getUser(), job.getNumber());
        this.jobLog_ = new RJobLog(aS400);
        try {
            this.jobLog_.setName(job.getName());
            this.jobLog_.setNumber(job.getNumber());
            this.jobLog_.setUser(job.getUser());
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "VJob constructor : " + propertyVetoException);
        }
        this.initializeTransient();
    }

    public VJob(AS400 aS400, RJob rJob) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (rJob == null) {
            throw new NullPointerException("job");
        }
        this.job_ = rJob;
        this.jobLog_ = new RJobLog(aS400);
        try {
            this.jobLog_.setName(rJob.getName());
            this.jobLog_.setNumber(rJob.getNumber());
            this.jobLog_.setUser(rJob.getUser());
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "VJob constructor : " + propertyVetoException);
        }
        this.initializeTransient();
    }

    public VJob(VNode vNode, AS400 aS400, Job job) {
        if (vNode == null) {
            throw new NullPointerException("parent");
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (job == null) {
            throw new NullPointerException("job");
        }
        this.parent_ = vNode;
        this.job_ = new RJob(aS400, job.getName(), job.getUser(), job.getNumber());
        this.jobLog_ = new RJobLog(aS400);
        try {
            this.jobLog_.setName(job.getName());
            this.jobLog_.setNumber(job.getNumber());
            this.jobLog_.setUser(job.getUser());
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "VJob constructor : " + propertyVetoException);
        }
        this.initializeTransient();
    }

    public VJob(VNode vNode, AS400 aS400, RJob rJob) {
        if (vNode == null) {
            throw new NullPointerException("parent");
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (rJob == null) {
            throw new NullPointerException("job");
        }
        this.parent_ = vNode;
        this.job_ = rJob;
        this.jobLog_ = new RJobLog(aS400);
        try {
            this.jobLog_.setName(rJob.getName());
            this.jobLog_.setNumber(rJob.getNumber());
            this.jobLog_.setUser(rJob.getUser());
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "VJob constructor : " + propertyVetoException);
        }
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        if (errorListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        if (vObjectListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        if (workingListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        return this.actions_;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int n) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public VObject getDetailsChildAt(int n) {
        if (!this.loaded_) {
            return null;
        }
        if (this.detailsChildren_ == null) {
            this.loadFirst();
        }
        if (n < 0 || n >= this.detailsChildren_.length) {
            return null;
        }
        if (this.detailsChildren_[n] == null) {
            this.loadSingle(n);
        }
        return this.detailsChildren_[n];
    }

    public int getDetailsChildCount() {
        if (!this.loaded_) {
            return 0;
        }
        if (this.detailsChildren_ == null) {
            this.loadFirst();
        }
        return this.detailsChildren_.length;
    }

    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    public int getDetailsIndex(VObject vObject) {
        if (this.detailsChildren_ == null) {
            this.loadFirst();
        }
        if (vObject == null) {
            return -1;
        }
        for (int i = 0; i < this.detailsChildren_.length; ++i) {
            if (this.detailsChildren_[i] != vObject) continue;
            return i;
        }
        return -1;
    }

    public Icon getIcon(int n, boolean bl) {
        if (n == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public int getIndex(TreeNode treeNode) {
        return -1;
    }

    public Job getJob() {
        Job job = new Job();
        try {
            if (this.job_.getSystem() != null) {
                job.setSystem(this.job_.getSystem());
            }
            if (this.job_.getName() != null) {
                job.setName(this.job_.getName());
            }
            if (this.job_.getUser() != null) {
                job.setUser(this.job_.getUser());
            }
            if (this.job_.getNumber() != null) {
                job.setNumber(this.job_.getNumber());
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return job;
    }

    public RJob getRJob() {
        return this.job_;
    }

    private String getJobType(char c, char c2) {
        switch (c) {
            case 'A': {
                switch (c2) {
                    case ' ': {
                        return "ASJ";
                    }
                }
                break;
            }
            case 'B': {
                switch (c2) {
                    case ' ': {
                        return "BCH";
                    }
                    case 'D': {
                        return "BCI";
                    }
                    case 'E': {
                        return "EVK";
                    }
                    case 'F': {
                        return "M36";
                    }
                    case 'T': {
                        return "MRT";
                    }
                    case 'J': {
                        return "PJ";
                    }
                    case 'U': {
                        return "";
                    }
                }
                break;
            }
            case 'I': {
                switch (c2) {
                    case ' ': {
                        return "INT";
                    }
                }
                break;
            }
            case 'W': {
                switch (c2) {
                    case ' ': {
                        return "WTR";
                    }
                    case 'P': {
                        return "PDJ";
                    }
                }
                break;
            }
            case 'R': {
                switch (c2) {
                    case ' ': {
                        return "RDR";
                    }
                }
                break;
            }
            case 'M': {
                switch (c2) {
                    case ' ': {
                        return "SBS";
                    }
                }
                break;
            }
            case 'S': 
            case 'X': {
                switch (c2) {
                    case ' ': {
                        return "SYS";
                    }
                }
                break;
            }
        }
        return "";
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object object) {
        if (object == VObject.NAME_PROPERTY) {
            return this;
        }
        if (object == VObject.DESCRIPTION_PROPERTY) {
            return description_;
        }
        if (this.job_ == null) {
            return "";
        }
        if (object == FUNCTION_PROPERTY) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.job_.getAttributeValue("FUNCTION_TYPE"));
                stringBuffer.append('-');
                stringBuffer.append(this.job_.getAttributeValue("FUNCTION_NAME"));
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                this.errorEventSupport_.fireError(exception);
                return "";
            }
        }
        if (object == TYPE_PROPERTY) {
            int n;
            char c;
            try {
                String string = ((String)this.job_.getAttributeValue("JOB_TYPE")).trim().toUpperCase();
                c = string.length() != 0 ? string.charAt(0) : (char)' ';
                String string2 = ((String)this.job_.getAttributeValue("JOB_SUBTYPE")).trim().toUpperCase();
                n = string2.length() != 0 ? (int)string2.charAt(0) : 32;
            }
            catch (Exception exception) {
                this.errorEventSupport_.fireError(exception);
                c = ' ';
                n = 32;
            }
            return this.getJobType(c, (char)n);
        }
        if (object == null) {
            return null;
        }
        Object v = map_.get(object);
        if (v == null) {
            return null;
        }
        try {
            return this.job_.getAttributeValue(v);
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
            return "";
        }
    }

    public AS400 getSystem() {
        return this.jobLog_.getSystem();
    }

    private String getQueueName(String string) {
        if (string.trim().equals("/")) {
            return "";
        }
        int n = string.indexOf(47);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public String getText() {
        if (this.job_ != null) {
            return this.job_.getName();
        }
        return "";
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.detailsChildren_ = new VObject[0];
        this.loaded_ = false;
        this.propertiesPane_ = new VResourcePropertiesPane(this, this.job_, properties_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isSortable() {
        return false;
    }

    public void load() {
        if (this.detailsChildren_ != null) {
            for (int i = 0; i < this.detailsChildren_.length; ++i) {
                if (this.detailsChildren_[i] == null) continue;
                this.detailsChildren_[i].removeErrorListener(this.errorEventSupport_);
                this.detailsChildren_[i].removeVObjectListener(this.objectEventSupport_);
                this.detailsChildren_[i].removeWorkingListener(this.workingEventSupport_);
            }
        }
        this.detailsChildren_ = null;
        this.loaded_ = true;
    }

    private void loadFirst() {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.jobLog_.open();
            this.jobLog_.waitForComplete();
            this.detailsChildren_ = new VJobLogMessage[(int)this.jobLog_.getListLength()];
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
            this.detailsChildren_ = new VJobLogMessage[0];
        }
        this.workingEventSupport_.fireStopWorking();
    }

    private void loadSingle(int n) {
        this.workingEventSupport_.fireStartWorking();
        try {
            RQueuedMessage rQueuedMessage = (RQueuedMessage)this.jobLog_.resourceAt(n);
            this.detailsChildren_[n] = new VJobLogMessage(rQueuedMessage);
            this.detailsChildren_[n].addErrorListener(this.errorEventSupport_);
            this.detailsChildren_[n].addVObjectListener(this.objectEventSupport_);
            this.detailsChildren_[n].addWorkingListener(this.workingEventSupport_);
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        if (errorListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        if (vObjectListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        if (workingListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setJob(Job job) throws PropertyVetoException {
        if (job == null) {
            throw new NullPointerException("job");
        }
        Job job2 = this.getJob();
        Job job3 = job;
        this.vetoableChangeSupport_.fireVetoableChange("job", job2, job3);
        if (job2 != job3) {
            this.job_ = new RJob(job.getSystem(), job.getName(), job.getUser(), job.getNumber());
            this.jobLog_ = new RJobLog(job.getSystem(), job.getName(), job.getUser(), job.getNumber());
        }
        this.propertyChangeSupport_.firePropertyChange("job", job2, job3);
    }

    public void setRJob(RJob rJob) throws PropertyVetoException {
        if (rJob == null) {
            throw new NullPointerException("job");
        }
        RJob rJob2 = this.job_;
        RJob rJob3 = rJob;
        this.vetoableChangeSupport_.fireVetoableChange("job", rJob2, rJob3);
        if (rJob2 != rJob3) {
            this.job_ = rJob;
            try {
                this.jobLog_.setName(rJob.getName());
                this.jobLog_.setNumber(rJob.getNumber());
                this.jobLog_.setUser(rJob.getUser());
            }
            catch (PropertyVetoException propertyVetoException) {
                Trace.log(2, "VJob setJob : " + propertyVetoException);
            }
        }
        this.propertyChangeSupport_.firePropertyChange("job", rJob2, rJob3);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        AS400 aS4002 = this.jobLog_.getSystem();
        AS400 aS4003 = aS400;
        this.vetoableChangeSupport_.fireVetoableChange("system", aS4002, aS4003);
        if (aS4002 != aS4003) {
            try {
                this.jobLog_.setSystem(aS400);
            }
            catch (PropertyVetoException propertyVetoException) {
                Trace.log(2, "VJob setSystem : " + propertyVetoException);
            }
        }
        this.propertyChangeSupport_.firePropertyChange("system", aS4002, aS4003);
    }

    public void sortDetailsChildren(Object[] objectArray, boolean[] blArray) {
    }

    public String toString() {
        return this.getText();
    }

    static {
        map_.put(BREAK_MESSAGE_HANDLING_PROPERTY, "BREAK_MESSAGE_HANDLING");
        map_.put(CCSID_PROPERTY, "CCSID");
        map_.put(COMPLETION_STATUS_PROPERTY, "COMPLETION_STATUS");
        map_.put(COUNTRY_ID_PROPERTY, "COUNTRY_ID");
        map_.put(CPUUSED_PROPERTY, "CPU_TIME_USED");
        map_.put(CURRENT_LIBRARY_EXISTENCE_PROPERTY, "CURRENT_LIBRARY_EXISTENCE");
        map_.put(CURRENT_LIBRARY_PROPERTY, "CURRENT_LIBRARY");
        map_.put(DATE_FORMAT_PROPERTY, "DATE_FORMAT");
        map_.put(DATE_JOB_BECAME_ACTIVE_PROPERTY, "DATE_STARTED");
        map_.put(DATE_JOB_ENTERED_SYSTEM_PROPERTY, "DATE_ENTERED_SYSTEM");
        map_.put(DATE_JOB_SCHEDULE_TO_RUN_PROPERTY, "SCHEDULE_DATE");
        map_.put(DATE_PROPERTY, "DATE_ENTERED_SYSTEM");
        map_.put(DATE_PUT_ON_JOB_QUEUE_PROPERTY, "JOB_QUEUE_DATE");
        map_.put(DATE_SEPARATOR_PROPERTY, "DATE_SEPARATOR");
        map_.put(DDM_CONVERSATION_HANDLING_PROPERTY, "KEEP_DDM_CONNECTIONS_ACTIVE");
        map_.put(DECIMAL_FORMAT_PROPERTY, "DECIMAL_FORMAT");
        map_.put(DEFAULT_CCSID_PROPERTY, "DEFAULT_CCSID");
        map_.put(DEVICE_RECOVERY_ACTION_PROPERTY, "DEVICE_RECOVERY_ACTION");
        map_.put(END_SEVERITY_PROPERTY, "END_SEVERITY");
        map_.put(FUNCTION_PROPERTY, "FUNCTION_NAME");
        map_.put(INQUIRY_MESSAGE_REPLY_PROPERTY, "INQUIRY_MESSAGE_REPLY");
        map_.put(JOB_ACCOUNTING_CODE_PROPERTY, "ACCOUNTING_CODE");
        map_.put(JOB_DATE_PROPERTY, "JOB_DATE");
        map_.put(JOB_DESCRIPTION_PROPERTY, "JOB_DESCRIPTION");
        map_.put(JOB_MESSAGE_QUEUE_FULL_ACTION_PROPERTY, "MESSAGE_QUEUE_ACTION");
        map_.put(JOB_MESSAGE_QUEUE_MAXIMUM_SIZE_PROPERTY, "MESSAGE_QUEUE_MAX_SIZE");
        map_.put(JOB_QUEUE_PRIORITY_PROPERTY, "JOB_QUEUE_PRIORITY");
        map_.put(JOB_QUEUE_PROPERTY, "JOB_QUEUE");
        map_.put(JOB_SWITCHES_PROPERTY, "JOB_SWITCHES");
        map_.put(LANGUAGE_ID_PROPERTY, "LANGUAGE_ID");
        map_.put(LOGGING_CL_PROGRAMS_PROPERTY, "LOG_CL_PROGRAMS");
        map_.put(LOGGING_LEVEL_PROPERTY, "LOGGING_LEVEL");
        map_.put(LOGGING_SEVERITY_PROPERTY, "LOGGING_SEVERITY");
        map_.put(LOGGING_TEXT_PROPERTY, "LOGGING_TEXT");
        map_.put(MODE_NAME_PROPERTY, "MODE");
        map_.put(NUMBER_PROPERTY, "JOB_NUMBER");
        map_.put(NUMBER_OF_LIBRARIES_IN_SYSLIBL_PROPERTY, "SYSTEM_LIBRARY_LIST");
        map_.put(NUMBER_OF_LIBRARIES_IN_USRLIBL_PROPERTY, "USER_LIBRARY_LIST");
        map_.put(NUMBER_OF_PRODUCT_LIBRARIES_PROPERTY, "PRODUCT_LIBRARIES");
        map_.put(OUTPUT_QUEUE_PRIORITY_PROPERTY, "OUTPUT_QUEUE_PRIORITY");
        map_.put(OUTPUT_QUEUE_PROPERTY, "OUTPUT_QUEUE");
        map_.put(PRINT_KEY_FORMAT_PROPERTY, "PRINT_KEY_FORMAT");
        map_.put(PRINT_TEXT_PROPERTY, "PRINT_TEXT");
        map_.put(PRINTER_DEVICE_NAME_PROPERTY, "PRINTER_DEVICE_NAME");
        map_.put(PRODUCT_LIBRARIES_PROPERTY, "PRODUCT_LIBRARIES");
        map_.put(ROUTING_DATA_PROPERTY, "ROUTING_DATA");
        map_.put(SIGNED_ON_JOB_PROPERTY, "SIGNED_ON_JOB");
        map_.put(SORT_SEQUENCE_TABLE_PROPERTY, "SORT_SEQUENCE_TABLE");
        map_.put(STATUS_OF_JOB_ON_JOB_QUEUE_PROPERTY, "JOB_QUEUE_STATUS");
        map_.put(STATUS_MESSAGE_HANDLING_PROPERTY, "STATUS_MESSAGE_HANDLING");
        map_.put(STATUS_PROPERTY, "JOB_STATUS");
        map_.put(SUBSYSTEM_PROPERTY, "SUBSYSTEM");
        map_.put(SUBTYPE_PROPERTY, "JOB_SUBTYPE");
        map_.put(SYSTEM_LIBRARY_LIST_PROPERTY, "SYSTEM_LIBRARY_LIST");
        map_.put(TIME_SEPARATOR_PROPERTY, "TIME_SEPARATOR");
        map_.put(TYPE_PROPERTY, "JOB_TYPE");
        map_.put(WORK_ID_UNIT_PROPERTY, "LOCATION_NAME");
        map_.put(USER_LIBRARY_LIST_PROPERTY, "USER_LIBRARY_LIST");
        map_.put(USER_PROPERTY, "USER_NAME");
        detailsColumnModel_ = new DefaultTableColumnModel();
        int n = 0;
        VTableColumn vTableColumn = new VTableColumn(n++, VObject.NAME_PROPERTY);
        vTableColumn.setCellRenderer(new VObjectCellRenderer());
        vTableColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn.setHeaderValue(nameColumnHeader_);
        vTableColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTableColumn);
        VTableColumn vTableColumn2 = new VTableColumn(n++, VJobLogMessage.TEXT_PROPERTY);
        vTableColumn2.setCellRenderer(new VObjectCellRenderer());
        vTableColumn2.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn2.setHeaderValue(textColumnHeader_);
        vTableColumn2.setPreferredCharWidth(80);
        detailsColumnModel_.addColumn(vTableColumn2);
        VTableColumn vTableColumn3 = new VTableColumn(n++, VJobLogMessage.SEVERITY_PROPERTY);
        vTableColumn3.setCellRenderer(new VObjectCellRenderer(4));
        vTableColumn3.setHeaderRenderer(new VObjectHeaderRenderer(4));
        vTableColumn3.setHeaderValue(severityColumnHeader_);
        vTableColumn3.setPreferredCharWidth(8);
        detailsColumnModel_.addColumn(vTableColumn3);
        VTableColumn vTableColumn4 = new VTableColumn(n++, VJobLogMessage.TYPE_PROPERTY);
        vTableColumn4.setCellRenderer(new VObjectCellRenderer());
        vTableColumn4.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn4.setHeaderValue(typeColumnHeader_);
        vTableColumn4.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(vTableColumn4);
        VTableColumn vTableColumn5 = new VTableColumn(n++, VJobLogMessage.DATE_PROPERTY);
        vTableColumn5.setCellRenderer(new VObjectCellRenderer());
        vTableColumn5.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn5.setHeaderValue(dateColumnHeader_);
        vTableColumn5.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(vTableColumn5);
        VTableColumn vTableColumn6 = new VTableColumn(n++, VJobLogMessage.FROM_PROGRAM_PROPERTY);
        vTableColumn6.setCellRenderer(new VObjectCellRenderer());
        vTableColumn6.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn6.setHeaderValue(fromProgramColumnHeader_);
        vTableColumn6.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTableColumn6);
        properties_ = null;
        properties_ = new ResourceProperties();
        properties_.addProperties(new Object[]{"JOB_TYPE", "JOB_SUBTYPE", "JOB_STATUS", "DATE_ENTERED_SYSTEM", "JOB_DATE", "JOB_DESCRIPTION", "JOB_QUEUE", "JOB_QUEUE_PRIORITY", "JOB_QUEUE_STATUS"});
        properties_.addProperties(properties_.addTab(ResourceLoader.getText("TAB_PRINTER_OUTPUT")), new Object[]{"OUTPUT_QUEUE", "OUTPUT_QUEUE_PRIORITY", "PRINTER_DEVICE_NAME", "PRINT_KEY_FORMAT", "PRINT_TEXT"});
        properties_.addProperties(properties_.addTab(ResourceLoader.getText("TAB_ACTIVE")), new Object[]{"RUN_PRIORITY", "SUBSYSTEM", "SYSTEM_POOL_ID", "AUXILIARY_IO_REQUESTS", "INTERACTIVE_TRANSACTIONS", "TOTAL_RESPONSE_TIME", "DEFAULT_WAIT_TIME", "ELIGIBLE_FOR_PURGE", "JOB_SWITCHES", "TIME_SLICE", "TIME_SLICE_END_POOL"});
        properties_.addProperties(properties_.addTab(ResourceLoader.getText("TAB_MESSAGE")), new Object[]{"INQUIRY_MESSAGE_REPLY", "BREAK_MESSAGE_HANDLING", "STATUS_MESSAGE_HANDLING", "LOG_CL_PROGRAMS", "LOGGING_SEVERITY", "LOGGING_LEVEL", "LOGGING_TEXT", "MESSAGE_QUEUE_ACTION"});
        properties_.addProperties(properties_.addTab(ResourceLoader.getText("TAB_DATETIME")), new Object[]{"JOB_QUEUE_DATE", "DATE_ENTERED_SYSTEM", "DATE_FORMAT", "DATE_SEPARATOR", "TIME_SEPARATOR", "SCHEDULE_DATE"});
        properties_.addProperties(properties_.addTab(ResourceLoader.getText("TAB_LANGUAGE")), new Object[]{"CCSID", "DEFAULT_CCSID", "COUNTRY_ID", "LANGUAGE_ID", "SORT_SEQUENCE_TABLE"});
        properties_.addProperties(properties_.addTab(ResourceLoader.getText("TAB_LIBRARY_LIST")), new Object[]{"SYSTEM_LIBRARY_LIST", "USER_LIBRARY_LIST", "PRODUCT_LIBRARIES", "CURRENT_LIBRARY"});
        properties_.addProperties(properties_.addTab(ResourceLoader.getText("TAB_OTHER")), new Object[]{"LOCATION_NAME", "MODE", "DEVICE_RECOVERY_ACTION", "KEEP_DDM_CONNECTIONS_ACTIVE", "COMPLETION_STATUS", "ROUTING_DATA", "DECIMAL_FORMAT", "ACCOUNTING_CODE", "FUNCTION_NAME", "FUNCTION_TYPE", "SIGNED_ON_JOB"});
    }
}

