/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400Time;
import com.ibm.as400.access.DateFieldDescription;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.Trace;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class TimeFieldDescription
extends FieldDescription
implements Serializable {
    static final long serialVersionUID = 4L;
    private String timeFormat_ = null;
    private String timeSeparator_ = null;

    public TimeFieldDescription() {
    }

    public TimeFieldDescription(AS400Text aS400Text, String string) {
        super(aS400Text, string);
    }

    public TimeFieldDescription(AS400Text aS400Text, String string, String string2) {
        super(aS400Text, string, string2);
    }

    public TimeFieldDescription(AS400Time aS400Time, String string) {
        super(aS400Time, string);
    }

    public TimeFieldDescription(AS400Time aS400Time, String string, String string2) {
        super(aS400Time, string, string2);
    }

    String[] getDDSDescription() {
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer(this.ddsName_);
        while (stringBuffer.length() < 10) {
            stringBuffer.append(" ");
        }
        if (!this.refFld_.equals("")) {
            stringBuffer.append("R");
        } else {
            stringBuffer.append(" ");
        }
        stringBuffer.append("     ");
        stringBuffer.append("T");
        stringBuffer.append("  ");
        stringBuffer.append("       ");
        vector.addElement(stringBuffer.toString());
        String[] stringArray = super.getFieldFunctions();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(stringArray[i]);
            }
        }
        if (this.timeFormat_ != null) {
            vector.addElement("TIMFMT(" + this.timeFormat_ + ") ");
        }
        if (this.timeSeparator_ != null) {
            if (!TimeFieldDescription.formatHasFixedSeparator(this.timeFormat_)) {
                vector.addElement("TIMSEP('" + this.timeSeparator_ + "') ");
            } else if (Trace.traceOn_) {
                Trace.log(1, "DDS time format " + this.timeFormat_ + " has a fixed separator.");
            }
        }
        if (this.defaultValue_ != null) {
            vector.addElement("DFT('" + this.defaultValue_.toString() + "') ");
        } else if (this.isDFTNull_) {
            vector.addElement("DFT(*NULL) ");
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static boolean formatHasFixedSeparator(String string) {
        return DateFieldDescription.formatHasFixedSeparator(string);
    }

    public String getTIMFMT() {
        return this.timeFormat_ == null ? "" : this.timeFormat_;
    }

    public String getTIMSEP() {
        return this.timeSeparator_ == null ? "" : this.timeSeparator_;
    }

    public void setDataType(AS400Text aS400Text) {
        if (aS400Text == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = aS400Text;
        this.length_ = aS400Text.getByteLength();
    }

    public void setDataType(AS400Time aS400Time) {
        if (aS400Time == null) {
            throw new NullPointerException("dataType");
        }
        this.dataType_ = aS400Time;
        this.length_ = aS400Time.getByteLength();
    }

    public void setDFT(String string) {
        if (string == null) {
            throw new NullPointerException("defaultValue");
        }
        this.defaultValue_ = string;
        this.isDFTNull_ = false;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setDFTCurrent() {
        this.isDFTCurrent_ = true;
        this.isDFTNull_ = false;
        this.defaultValue_ = null;
        this.DFTCurrentValue_ = new SimpleDateFormat("HH.mm.ss").format(new Date());
    }

    public void setDFTNull() {
        this.isDFTNull_ = true;
        this.defaultValue_ = null;
        this.isDFTCurrent_ = false;
        this.DFTCurrentValue_ = null;
    }

    public void setTIMFMT(String string) {
        if (string == null) {
            throw new NullPointerException("timeFormat");
        }
        this.timeFormat_ = string.startsWith("*") ? string.toUpperCase() : "*" + string.toUpperCase();
        if (this.dataType_ instanceof AS400Time) {
            ((AS400Time)this.dataType_).setFormat(string);
        }
    }

    public void setTIMSEP(String string) {
        if (this.dataType_ instanceof AS400Time) {
            if (string != null && string.length() > 1) {
                throw new ExtendedIllegalArgumentException("separator (" + string + ")", 1);
            }
            Character c = string == null ? null : new Character(string.charAt(0));
            ((AS400Time)this.dataType_).setSeparator(c);
        }
        this.timeSeparator_ = string;
    }
}

