/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class AS400Message
implements Serializable {
    static final long serialVersionUID = 4L;
    static final int EXTENSION_VERSION = 5;
    static final int EXTENSION_VERSION_FIRST = 5;
    static final byte[] EXTENSION = new byte[]{74, 84, 79, 80, 69, 78, 69, 88, 84};
    public static final int COMPLETION = 1;
    public static final int DIAGNOSTIC = 2;
    public static final int INFORMATIONAL = 4;
    public static final int INQUIRY = 5;
    public static final int SENDERS_COPY = 6;
    public static final int REQUEST = 8;
    public static final int REQUEST_WITH_PROMPTING = 10;
    public static final int NOTIFY = 14;
    public static final int ESCAPE = 15;
    public static final int NOTIFY_NOT_HANDLED = 16;
    public static final int ESCAPE_NOT_HANDLED = 17;
    public static final int REPLY_NOT_VALIDITY_CHECKED = 21;
    public static final int REPLY_VALIDITY_CHECKED = 22;
    public static final int REPLY_MESSAGE_DEFAULT_USED = 23;
    public static final int REPLY_SYSTEM_DEFAULT_USED = 24;
    public static final int REPLY_FROM_SYSTEM_REPLY_LIST = 25;
    public static final int MESSAGE_OPTION_UP_TO_10 = 0;
    public static final int MESSAGE_OPTION_NONE = 1;
    public static final int MESSAGE_OPTION_ALL = 2;
    private Calendar date_;
    private String dateSent_;
    private String timeSent_;
    private String fileName_;
    private String id_;
    private String libraryName_;
    private String defaultReply_;
    private int severity_ = -1;
    private byte[] substitutionData_;
    private String text_;
    private int type_ = -1;
    private String help_;
    private int textCcsid_ = -1;
    private int substitutionDataCcsid_ = -1;
    private transient AS400 system_;
    private transient boolean messageLoaded_ = false;
    private Date createDate_ = null;
    private Date modificationDate_ = null;
    private transient byte[] key_ = null;
    private transient String messageFileLibrarySpecified_ = null;
    private transient String sendingProgramName_ = null;
    private transient String sendingProgramInstructionNumber_ = null;
    private transient String receivingProgramName_ = null;
    private transient String receivingProgramInstructionNumber_ = null;
    private transient String sendingType_ = null;
    private transient String receivingType_ = null;
    private transient int textCcsidConversionStatusIndicator_ = 0;
    private transient int dataCcsidConversionStatusIndicator_ = 0;
    private transient String alertOption_ = null;

    AS400Message() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400Message object.");
        }
    }

    AS400Message(String string, String string2) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing AS400Message object, ID: " + string + " text: " + string2);
        }
        this.id_ = string;
        this.text_ = string2;
    }

    AS400Message(String string, String string2, String string3, String string4, int n, int n2, byte[] byArray, String string5) {
        this.id_ = string;
        this.text_ = string2;
        this.fileName_ = string3;
        this.libraryName_ = string4;
        this.severity_ = n;
        this.type_ = n2;
        this.substitutionData_ = byArray;
        this.help_ = string5;
    }

    AS400Message(String string, String string2, String string3, String string4, int n, int n2, byte[] byArray, String string5, String string6, String string7, String string8) {
        this.id_ = string;
        this.text_ = string2;
        this.fileName_ = string3;
        this.libraryName_ = string4;
        this.severity_ = n;
        this.type_ = n2;
        this.substitutionData_ = byArray;
        this.help_ = string5;
        this.setDate(string6, string7);
        this.defaultReply_ = string8;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = false;
        byte[] byArray = this.substitutionData_;
        if (this.key_ != null || this.messageFileLibrarySpecified_ != null || this.sendingProgramName_ != null || this.sendingProgramInstructionNumber_ != null || this.receivingProgramName_ != null || this.receivingProgramInstructionNumber_ != null || this.sendingType_ != null || this.receivingType_ != null || this.textCcsidConversionStatusIndicator_ != 0 || this.dataCcsidConversionStatusIndicator_ != 0 || this.alertOption_ != null) {
            if (byArray == null) {
                bl = true;
                byArray = new byte[]{};
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream2.writeInt(5);
            objectOutputStream2.writeBoolean(bl);
            objectOutputStream2.writeObject(this.key_);
            objectOutputStream2.writeObject(this.messageFileLibrarySpecified_);
            objectOutputStream2.writeObject(this.sendingProgramName_);
            objectOutputStream2.writeObject(this.sendingProgramInstructionNumber_);
            objectOutputStream2.writeObject(this.receivingProgramName_);
            objectOutputStream2.writeObject(this.receivingProgramInstructionNumber_);
            objectOutputStream2.writeObject(this.sendingType_);
            objectOutputStream2.writeObject(this.receivingType_);
            objectOutputStream2.writeInt(this.textCcsidConversionStatusIndicator_);
            objectOutputStream2.writeInt(this.dataCcsidConversionStatusIndicator_);
            objectOutputStream2.writeObject(this.alertOption_);
            objectOutputStream2.flush();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            this.substitutionData_ = new byte[byArray.length + EXTENSION.length + byArray2.length + 4 + EXTENSION.length];
            int n = 0;
            System.arraycopy(byArray, 0, this.substitutionData_, n, byArray.length);
            System.arraycopy(EXTENSION, 0, this.substitutionData_, n += byArray.length, EXTENSION.length);
            System.arraycopy(byArray2, 0, this.substitutionData_, n += EXTENSION.length, byArray2.length);
            this.substitutionData_[n += byArray2.length] = (byte)(byArray.length >> 24 & 0xFF);
            this.substitutionData_[++n] = (byte)(byArray.length >> 16 & 0xFF);
            this.substitutionData_[++n] = (byte)(byArray.length >> 8 & 0xFF);
            this.substitutionData_[++n] = (byte)(byArray.length & 0xFF);
            System.arraycopy(EXTENSION, 0, this.substitutionData_, ++n, EXTENSION.length);
        }
        objectOutputStream.defaultWriteObject();
        this.substitutionData_ = (byte[])(bl ? null : byArray);
    }

    private static boolean arrayEndsWith(byte[] byArray, byte[] byArray2) {
        if (byArray.length < byArray2.length) {
            return false;
        }
        int n = byArray.length - byArray2.length;
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.substitutionData_ != null && this.substitutionData_.length > 2 * EXTENSION.length && AS400Message.arrayEndsWith(this.substitutionData_, EXTENSION)) {
            int n = this.substitutionData_.length - EXTENSION.length - 4;
            int n2 = 0;
            n2 += (0xFF & this.substitutionData_[n]) << 24;
            n2 += (0xFF & this.substitutionData_[++n]) << 16;
            n2 += (0xFF & this.substitutionData_[++n]) << 8;
            byte[] byArray = new byte[n2 += 0xFF & this.substitutionData_[++n]];
            System.arraycopy(this.substitutionData_, 0, byArray, 0, n2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.substitutionData_, n2 + EXTENSION.length, this.substitutionData_.length - n2 - EXTENSION.length);
            ObjectInputStream objectInputStream2 = new ObjectInputStream(byteArrayInputStream);
            int n3 = objectInputStream2.readInt();
            boolean bl = false;
            if (n3 >= 5) {
                bl = objectInputStream2.readBoolean();
                this.key_ = (byte[])objectInputStream2.readObject();
                this.messageFileLibrarySpecified_ = (String)objectInputStream2.readObject();
                this.sendingProgramName_ = (String)objectInputStream2.readObject();
                this.sendingProgramInstructionNumber_ = (String)objectInputStream2.readObject();
                this.receivingProgramName_ = (String)objectInputStream2.readObject();
                this.receivingProgramInstructionNumber_ = (String)objectInputStream2.readObject();
                this.sendingType_ = (String)objectInputStream2.readObject();
                this.receivingType_ = (String)objectInputStream2.readObject();
                this.textCcsidConversionStatusIndicator_ = objectInputStream2.readInt();
                this.dataCcsidConversionStatusIndicator_ = objectInputStream2.readInt();
                this.alertOption_ = (String)objectInputStream2.readObject();
            }
            this.substitutionData_ = (byte[])(bl ? null : byArray);
        }
    }

    public Calendar getDate() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting date: " + this.date_);
        }
        if (this.date_ == null && (this.dateSent_ != null || this.timeSent_ != null)) {
            this.setDate();
        }
        return this.date_;
    }

    public String getDefaultReply() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting default reply: " + this.defaultReply_);
        }
        return this.defaultReply_;
    }

    public String getFileName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message file name: " + this.fileName_);
        }
        return this.fileName_;
    }

    public String getHelp() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message help: " + this.help_);
        }
        return this.help_;
    }

    public String getID() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message ID: " + this.id_);
        }
        return this.id_;
    }

    public String getLibraryName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message file library: " + this.libraryName_);
        }
        return this.libraryName_;
    }

    public String getPath() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message file path, file name: " + this.fileName_ + " library: " + this.libraryName_);
        }
        if (this.fileName_ == null || this.libraryName_ == null || this.fileName_.length() == 0 || this.libraryName_.length() == 0) {
            return null;
        }
        return QSYSObjectPathName.toPath(this.libraryName_, this.fileName_, "MSGF");
    }

    public int getSeverity() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message severity:", this.severity_);
        }
        return this.severity_;
    }

    public byte[] getSubstitutionData() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message substitution data:", this.substitutionData_);
        }
        return this.substitutionData_;
    }

    public String getText() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message text: " + this.text_);
        }
        if (!(this.messageLoaded_ || this.substitutionData_ == null || this.substitutionData_.length == 0 || this.text_ != null && this.text_.trim().length() != 0)) {
            try {
                int n;
                Trace.log(1, "The 'text' field of the message is blank. Copying substitution data to message text.");
                if (this.substitutionDataCcsid_ == -1) {
                    Trace.log(1, "Assuming CCSID of substitution data is 37.");
                    n = 37;
                } else {
                    n = this.substitutionDataCcsid_;
                }
                this.text_ = CharConverter.byteArrayToString(n, this.substitutionData_);
            }
            catch (Exception exception) {
                Trace.log(2, exception);
            }
        }
        return this.text_;
    }

    public int getType() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message type:", this.type_);
        }
        return this.type_;
    }

    public void load() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        this.load(0);
    }

    public void load(int n) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Loading additional message information.");
        }
        if (this.messageLoaded_) {
            if (Trace.traceOn_) {
                Trace.log(1, "Repeat message load not necessary.");
            }
            return;
        }
        if (this.libraryName_ == null || this.fileName_ == null || this.libraryName_.trim().length() == 0 || this.fileName_.trim().length() == 0) {
            if (Trace.traceOn_) {
                Trace.log(1, "No message file associated with this message: " + this.toString());
            }
            return;
        }
        if (this.system_ == null) {
            if (Trace.traceOn_) {
                Trace.log(1, "Unable to load message file, because system was not specified when AS400Message was created.");
            }
            return;
        }
        MessageFile messageFile = new MessageFile(this.system_, QSYSObjectPathName.toPath(this.libraryName_, this.fileName_, "MSGF"));
        try {
            messageFile.setHelpTextFormatting(n);
            AS400Message aS400Message = messageFile.getMessage(this.id_, this.substitutionData_);
            if (this.defaultReply_ == null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Setting default reply: " + aS400Message.defaultReply_);
                }
                this.defaultReply_ = aS400Message.defaultReply_;
            }
            if (this.severity_ == -1) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Setting message severity:", aS400Message.severity_);
                }
                this.severity_ = aS400Message.severity_;
            }
            if (this.text_ == null) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Setting message text: " + aS400Message.text_);
                }
                this.text_ = aS400Message.text_;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Setting message help: " + aS400Message.help_);
            }
            this.help_ = aS400Message.help_;
            this.messageLoaded_ = true;
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
            throw new InternalErrorException(10);
        }
    }

    private void setDate() {
        if (this.dateSent_ == null && this.timeSent_ == null) {
            return;
        }
        if (this.dateSent_ != null && this.dateSent_.trim().length() == 0 && this.timeSent_ != null && this.timeSent_.trim().length() == 0) {
            this.dateSent_ = null;
            this.timeSent_ = null;
            return;
        }
        this.date_ = AS400Calendar.getGregorianInstance();
        this.date_.clear();
        if (this.dateSent_ != null && this.dateSent_.trim().length() > 0) {
            this.date_.set(1, Integer.parseInt(this.dateSent_.substring(0, 3)) + 1900);
            this.date_.set(2, Integer.parseInt(this.dateSent_.substring(3, 5)) - 1);
            this.date_.set(5, Integer.parseInt(this.dateSent_.substring(5, 7)));
        }
        if (this.timeSent_ != null && this.timeSent_.trim().length() > 0) {
            this.date_.set(10, Integer.parseInt(this.timeSent_.substring(0, 2)));
            this.date_.set(12, Integer.parseInt(this.timeSent_.substring(2, 4)));
            this.date_.set(13, Integer.parseInt(this.timeSent_.substring(4, 6)));
        }
        this.dateSent_ = null;
        this.timeSent_ = null;
        if (Trace.traceOn_) {
            Trace.log(1, "Date: " + this.date_);
        }
    }

    void setDate(String string, String string2) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting date, date: " + string + " time: " + string2);
        }
        this.dateSent_ = string;
        this.timeSent_ = string2;
    }

    void setDefaultReply(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting default reply: " + string);
        }
        this.defaultReply_ = string;
    }

    void setFileName(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message file name: " + string);
        }
        this.fileName_ = string;
    }

    void setHelp(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message help: " + string);
        }
        this.help_ = string;
    }

    void setID(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message ID: " + string);
        }
        this.id_ = string;
    }

    void setLibraryName(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message file library: " + string);
        }
        this.libraryName_ = string;
    }

    void setSeverity(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message severity:", n);
        }
        this.severity_ = n;
    }

    void setSubstitutionData(byte[] byArray) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message substitution data:", byArray);
        }
        this.substitutionData_ = byArray;
    }

    void setSystem(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message file system: " + aS400);
        }
        this.system_ = aS400;
    }

    void setText(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message text: " + string);
        }
        this.text_ = string;
    }

    void setTextCcsid(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message text CCSID: " + n);
        }
        this.textCcsid_ = n;
    }

    void setSubstitutionDataCcsid(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message substitution data CCSID: " + n);
        }
        this.substitutionDataCcsid_ = n;
    }

    void setType(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message type:", n);
        }
        this.type_ = n;
    }

    public String toString() {
        return "AS400Message (ID: " + this.id_ + " text: " + this.text_ + "):" + super.toString();
    }

    String toStringM2() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getID();
        String string2 = this.getText();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString().trim();
    }

    public Date getCreateDate() {
        return this.createDate_;
    }

    public void setCreateDate(Date date) {
        this.createDate_ = date;
    }

    public Date getModificationDate() {
        return this.modificationDate_;
    }

    public void setModificationDate(Date date) {
        this.modificationDate_ = date;
    }

    public void setKey(byte[] byArray) {
        this.key_ = byArray;
    }

    public byte[] getKey() {
        return this.key_;
    }

    public void setMessageFileLibrarySpecified(String string) {
        this.messageFileLibrarySpecified_ = string;
    }

    public String getMessageFileLibrarySpecified() {
        return this.messageFileLibrarySpecified_;
    }

    public void setSendingProgramName(String string) {
        this.sendingProgramName_ = string;
    }

    public String getSendingProgramName() {
        return this.sendingProgramName_;
    }

    public void setSendingProgramInstructionNumber(String string) {
        this.sendingProgramInstructionNumber_ = string;
    }

    public String getSendingProgramInstructionNumber() {
        return this.sendingProgramInstructionNumber_;
    }

    public void setReceivingProgramName(String string) {
        this.receivingProgramName_ = string;
    }

    public String getReceivingProgramName() {
        return this.receivingProgramName_;
    }

    public void setReceivingProgramInstructionNumber(String string) {
        this.receivingProgramInstructionNumber_ = string;
    }

    public String getReceivingProgramInstructionNumber() {
        return this.receivingProgramInstructionNumber_;
    }

    public void setSendingType(String string) {
        this.sendingType_ = string;
    }

    public String getSendingType() {
        return this.sendingType_;
    }

    public void setReceivingType(String string) {
        this.receivingType_ = string;
    }

    public String getReceivingType() {
        return this.receivingType_;
    }

    public void setTextCcsidConversionStatusIndicator(int n) {
        this.textCcsidConversionStatusIndicator_ = n;
    }

    public int getTextCcsidConversionStatusIndicator() {
        return this.textCcsidConversionStatusIndicator_;
    }

    public void setDataCcsidConversionStatusIndicator(int n) {
        this.dataCcsidConversionStatusIndicator_ = n;
    }

    public int getDataCcsidConversionStatusIndicator() {
        return this.dataCcsidConversionStatusIndicator_;
    }

    public void setAlertOption(String string) {
        this.alertOption_ = string;
    }

    public String getAlertOption() {
        return this.alertOption_;
    }

    private boolean checkObject(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public boolean equals(Object object) {
        if (object instanceof AS400Message) {
            AS400Message aS400Message = (AS400Message)object;
            if (!this.checkObject(this.date_, aS400Message.date_)) {
                return false;
            }
            if (!this.checkObject(this.dateSent_, aS400Message.dateSent_)) {
                return false;
            }
            if (!this.checkObject(this.timeSent_, aS400Message.timeSent_)) {
                return false;
            }
            if (!this.checkObject(this.fileName_, aS400Message.fileName_)) {
                return false;
            }
            if (!this.checkObject(this.id_, aS400Message.id_)) {
                return false;
            }
            if (!this.checkObject(this.libraryName_, aS400Message.libraryName_)) {
                return false;
            }
            if (!this.checkObject(this.defaultReply_, aS400Message.defaultReply_)) {
                return false;
            }
            if (this.severity_ != aS400Message.severity_) {
                return false;
            }
            if (!this.checkByteArray(this.substitutionData_, aS400Message.substitutionData_)) {
                return false;
            }
            if (!this.checkObject(this.text_, aS400Message.text_)) {
                return false;
            }
            if (this.type_ != aS400Message.type_) {
                return false;
            }
            if (!this.checkObject(this.help_, aS400Message.help_)) {
                return false;
            }
            if (this.textCcsid_ != aS400Message.textCcsid_) {
                return false;
            }
            if (this.substitutionDataCcsid_ != aS400Message.substitutionDataCcsid_) {
                return false;
            }
            if (!this.checkObject(this.createDate_, aS400Message.createDate_)) {
                return false;
            }
            if (!this.checkObject(this.modificationDate_, aS400Message.modificationDate_)) {
                return false;
            }
            if (!this.checkByteArray(this.key_, aS400Message.key_)) {
                return false;
            }
            if (!this.checkObject(this.messageFileLibrarySpecified_, aS400Message.messageFileLibrarySpecified_)) {
                return false;
            }
            if (!this.checkObject(this.sendingProgramName_, aS400Message.sendingProgramName_)) {
                return false;
            }
            if (!this.checkObject(this.sendingProgramInstructionNumber_, aS400Message.sendingProgramInstructionNumber_)) {
                return false;
            }
            if (!this.checkObject(this.receivingProgramName_, aS400Message.receivingProgramName_)) {
                return false;
            }
            if (!this.checkObject(this.receivingProgramInstructionNumber_, aS400Message.receivingProgramInstructionNumber_)) {
                return false;
            }
            if (!this.checkObject(this.sendingType_, aS400Message.sendingType_)) {
                return false;
            }
            if (!this.checkObject(this.receivingType_, aS400Message.receivingType_)) {
                return false;
            }
            if (this.textCcsidConversionStatusIndicator_ != aS400Message.textCcsidConversionStatusIndicator_) {
                return false;
            }
            if (this.dataCcsidConversionStatusIndicator_ != aS400Message.dataCcsidConversionStatusIndicator_) {
                return false;
            }
            return this.checkObject(this.alertOption_, aS400Message.alertOption_);
        }
        return false;
    }

    private boolean checkByteArray(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2 == null;
        }
        if (byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

