/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.setvariable;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.setvariable.SetVariableData;
import org.apache.hop.pipeline.transforms.setvariable.SetVariableMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;

public class SetVariable
extends BaseTransform<SetVariableMeta, SetVariableData>
implements ITransform<SetVariableMeta, SetVariableData> {
    private static final Class<?> PKG = SetVariableMeta.class;

    public SetVariable(TransformMeta transformMeta, SetVariableMeta meta, SetVariableData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] rowData = this.getRow();
        if (rowData == null) {
            if (this.first) {
                this.logBasic(BaseMessages.getString(PKG, (String)"SetVariable.Log.NoInputRowSetDefault", (String[])new String[0]));
                for (int i = 0; i < ((SetVariableMeta)this.meta).getFieldName().length; ++i) {
                    if (Utils.isEmpty((CharSequence)((SetVariableMeta)this.meta).getDefaultValue()[i])) continue;
                    this.setValue(rowData, i, true);
                }
            }
            this.logBasic("Finished after " + this.getLinesWritten() + " rows.");
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((SetVariableData)this.data).outputMeta = this.getInputRowMeta().clone();
            this.logBasic(BaseMessages.getString(PKG, (String)"SetVariable.Log.SettingVar", (String[])new String[0]));
            for (int i = 0; i < ((SetVariableMeta)this.meta).getFieldName().length; ++i) {
                this.setValue(rowData, i, false);
            }
            this.putRow(((SetVariableData)this.data).outputMeta, rowData);
            return true;
        }
        throw new HopTransformException(BaseMessages.getString(PKG, (String)"SetVariable.RuntimeError.MoreThanOneRowReceived.SETVARIABLE0007", (String[])new String[0]));
    }

    private void setValue(Object[] rowData, int i, boolean usedefault) throws HopException {
        String varname;
        String value = null;
        if (usedefault) {
            value = this.resolve(((SetVariableMeta)this.meta).getDefaultValue()[i]);
        } else {
            int index = ((SetVariableData)this.data).outputMeta.indexOfValue(((SetVariableMeta)this.meta).getFieldName()[i]);
            if (index < 0) {
                throw new HopException("Unable to find field [" + ((SetVariableMeta)this.meta).getFieldName()[i] + "] in input row");
            }
            IValueMeta valueMeta = ((SetVariableData)this.data).outputMeta.getValueMeta(index);
            Object valueData = rowData[index];
            value = ((SetVariableMeta)this.meta).isUsingFormatting() ? valueMeta.getString(valueData) : valueMeta.getCompatibleString(valueData);
        }
        if (value == null) {
            value = "";
        }
        if (Utils.isEmpty((CharSequence)(varname = ((SetVariableMeta)this.meta).getVariableName()[i]))) {
            if (Utils.isEmpty((CharSequence)value)) {
                throw new HopException("Variable name nor value was specified on line #" + (i + 1));
            }
            throw new HopException("There was no variable name specified for value [" + value + "]");
        }
        this.setVariable(varname, value);
        IPipelineEngine pipeline = this.getPipeline();
        pipeline.setVariable(varname, value);
        while (pipeline.getParentPipeline() != null) {
            pipeline = pipeline.getParentPipeline();
            pipeline.setVariable(varname, value);
        }
        switch (((SetVariableMeta)this.meta).getVariableType()[i]) {
            case 0: {
                IWorkflowEngine parentWorkflow;
                System.setProperty(varname, value);
                for (parentWorkflow = pipeline.getParentWorkflow(); parentWorkflow != null; parentWorkflow = parentWorkflow.getParentWorkflow()) {
                    parentWorkflow.setVariable(varname, value);
                }
                break;
            }
            case 3: {
                IWorkflowEngine parentWorkflow;
                for (parentWorkflow = pipeline.getParentWorkflow(); parentWorkflow != null; parentWorkflow = parentWorkflow.getParentWorkflow()) {
                    parentWorkflow.setVariable(varname, value);
                }
                break;
            }
            case 2: {
                IWorkflowEngine parentWorkflow = pipeline.getParentWorkflow();
                if (parentWorkflow != null) {
                    parentWorkflow.setVariable(varname, value);
                } else {
                    this.log.logBasic("WARNING: Can't set variable [" + varname + "] on parent workflow: the parent workflow is not available");
                }
                IWorkflowEngine gpJob = pipeline.getParentWorkflow().getParentWorkflow();
                if (gpJob != null) {
                    gpJob.setVariable(varname, value);
                    break;
                }
                this.log.logBasic("WARNING: Can't set variable [" + varname + "] on grand parent workflow: the grand parent workflow is not available");
                break;
            }
            case 1: {
                IWorkflowEngine parentWorkflow = pipeline.getParentWorkflow();
                if (parentWorkflow != null) {
                    parentWorkflow.setVariable(varname, value);
                    break;
                }
                this.log.logBasic("WARNING: Can't set variable [" + varname + "] on parent workflow: the parent workflow is not available");
                break;
            }
        }
        this.logBasic(BaseMessages.getString(PKG, (String)"SetVariable.Log.SetVariableToValue", (String[])new String[]{((SetVariableMeta)this.meta).getVariableName()[i], value}));
    }
}

