/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ifnull;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.ifnull.IfNull;
import org.apache.hop.pipeline.transforms.ifnull.IfNullData;
import org.w3c.dom.Node;

@Transform(id="IfNull", image="IfNull.svg", name="i18n::IfNull.Name", description="i18n::IfNull.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Flow", documentationUrl="/pipeline/transforms/ifnull.html")
@InjectionSupported(localizationPrefix="IfNull.Injection.", groups={"FIELDS", "VALUE_TYPES"})
public class IfNullMeta
extends BaseTransformMeta
implements ITransformMeta<IfNull, IfNullData> {
    private static final Class<?> PKG = IfNullMeta.class;
    @InjectionDeep
    private Fields[] fields;
    @InjectionDeep
    private ValueTypes[] valueTypes;
    @Injection(name="SELECT_FIELDS")
    private boolean selectFields;
    @Injection(name="SELECT_VALUES_TYPE")
    private boolean selectValuesType;
    @Injection(name="REPLACE_ALL_BY_VALUE")
    private String replaceAllByValue;
    @Injection(name="REPLACE_ALL_MASK")
    private String replaceAllMask;
    @Injection(name="SET_EMPTY_STRING_ALL")
    private boolean setEmptyStringAll;

    public IfNull createTransform(TransformMeta transformMeta, IfNullData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new IfNull(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public boolean isSetEmptyStringAll() {
        return this.setEmptyStringAll;
    }

    public void setEmptyStringAll(boolean setEmptyStringAll) {
        this.setEmptyStringAll = setEmptyStringAll;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public Object clone() {
        int i;
        IfNullMeta retval = (IfNullMeta)((Object)super.clone());
        int nrTypes = this.valueTypes.length;
        int nrFields = this.fields.length;
        retval.allocate(nrTypes, nrFields);
        for (i = 0; i < nrTypes; ++i) {
            retval.getValueTypes()[i] = this.valueTypes[i].clone();
        }
        for (i = 0; i < nrFields; ++i) {
            retval.getFields()[i] = this.fields[i].clone();
        }
        return retval;
    }

    public void allocate(int nrtypes, int nrFields) {
        int i;
        this.valueTypes = new ValueTypes[nrtypes];
        for (i = 0; i < nrtypes; ++i) {
            this.valueTypes[i] = new ValueTypes();
        }
        this.fields = new Fields[nrFields];
        for (i = 0; i < nrFields; ++i) {
            this.fields[i] = new Fields();
        }
    }

    public boolean isSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(boolean selectFields) {
        this.selectFields = selectFields;
    }

    public void setSelectValuesType(boolean selectValuesType) {
        this.selectValuesType = selectValuesType;
    }

    public boolean isSelectValuesType() {
        return this.selectValuesType;
    }

    public void setReplaceAllByValue(String replaceValue) {
        this.replaceAllByValue = replaceValue;
    }

    public String getReplaceAllByValue() {
        return this.replaceAllByValue;
    }

    public void setReplaceAllMask(String replaceAllMask) {
        this.replaceAllMask = replaceAllMask;
    }

    public String getReplaceAllMask() {
        return this.replaceAllMask;
    }

    public Fields[] getFields() {
        return this.fields;
    }

    public void setFields(Fields[] fields) {
        this.fields = fields;
    }

    public ValueTypes[] getValueTypes() {
        return this.valueTypes;
    }

    public void setValueTypes(ValueTypes[] valueTypes) {
        this.valueTypes = valueTypes;
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            int i;
            this.selectFields = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"selectFields"));
            this.selectValuesType = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"selectValuesType"));
            this.replaceAllByValue = XmlHandler.getTagValue((Node)transformNode, (String)"replaceAllByValue");
            this.replaceAllMask = XmlHandler.getTagValue((Node)transformNode, (String)"replaceAllMask");
            String setEmptyStringAllString = XmlHandler.getTagValue((Node)transformNode, (String)"setEmptyStringAll");
            this.setEmptyStringAll = !Utils.isEmpty((CharSequence)setEmptyStringAllString) && "Y".equalsIgnoreCase(setEmptyStringAllString);
            Node types = XmlHandler.getSubNode((Node)transformNode, (String)"valuetypes");
            int nrtypes = XmlHandler.countNodes((Node)types, (String)"valuetype");
            Node fieldNodes = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fieldNodes, (String)"field");
            this.allocate(nrtypes, nrFields);
            for (i = 0; i < nrtypes; ++i) {
                Node tnode = XmlHandler.getSubNodeByNr((Node)types, (String)"valuetype", (int)i);
                this.valueTypes[i].setTypeName(XmlHandler.getTagValue((Node)tnode, (String)"name"));
                this.valueTypes[i].setTypereplaceValue(XmlHandler.getTagValue((Node)tnode, (String)"value"));
                this.valueTypes[i].setTypereplaceMask(XmlHandler.getTagValue((Node)tnode, (String)"mask"));
                String typeemptyString = XmlHandler.getTagValue((Node)tnode, (String)"set_type_empty_string");
                this.valueTypes[i].setTypeEmptyString(!Utils.isEmpty((CharSequence)typeemptyString) && "Y".equalsIgnoreCase(typeemptyString));
            }
            for (i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fieldNodes, (String)"field", (int)i);
                this.fields[i].setFieldName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                this.fields[i].setReplaceValue(XmlHandler.getTagValue((Node)fnode, (String)"value"));
                this.fields[i].setReplaceMask(XmlHandler.getTagValue((Node)fnode, (String)"mask"));
                String emptyString = XmlHandler.getTagValue((Node)fnode, (String)"set_empty_string");
                this.fields[i].setEmptyString(!Utils.isEmpty((CharSequence)emptyString) && "Y".equalsIgnoreCase(emptyString));
            }
        }
        catch (Exception e) {
            throw new HopXmlException("It was not possibke to load the IfNull metadata from XML", (Throwable)e);
        }
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder();
        retval.append("      " + XmlHandler.addTagValue((String)"replaceAllByValue", (String)this.replaceAllByValue));
        retval.append("      " + XmlHandler.addTagValue((String)"replaceAllMask", (String)this.replaceAllMask));
        retval.append("      " + XmlHandler.addTagValue((String)"selectFields", (boolean)this.selectFields));
        retval.append("      " + XmlHandler.addTagValue((String)"selectValuesType", (boolean)this.selectValuesType));
        retval.append("      " + XmlHandler.addTagValue((String)"setEmptyStringAll", (boolean)this.setEmptyStringAll));
        retval.append("    <valuetypes>" + Const.CR);
        for (i = 0; i < this.valueTypes.length; ++i) {
            retval.append("      <valuetype>" + Const.CR);
            retval.append("        " + XmlHandler.addTagValue((String)"name", (String)this.valueTypes[i].getTypeName()));
            retval.append("        " + XmlHandler.addTagValue((String)"value", (String)this.valueTypes[i].getTypereplaceValue()));
            retval.append("        " + XmlHandler.addTagValue((String)"mask", (String)this.valueTypes[i].getTypereplaceMask()));
            retval.append("        " + XmlHandler.addTagValue((String)"set_type_empty_string", (boolean)this.valueTypes[i].isSetTypeEmptyString()));
            retval.append("        </valuetype>" + Const.CR);
        }
        retval.append("      </valuetypes>" + Const.CR);
        retval.append("    <fields>" + Const.CR);
        for (i = 0; i < this.fields.length; ++i) {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XmlHandler.addTagValue((String)"name", (String)this.fields[i].getFieldName()));
            retval.append("        " + XmlHandler.addTagValue((String)"value", (String)this.fields[i].getReplaceValue()));
            retval.append("        " + XmlHandler.addTagValue((String)"mask", (String)this.fields[i].getReplaceMask()));
            retval.append("        " + XmlHandler.addTagValue((String)"set_empty_string", (boolean)this.fields[i].isSetEmptyString()));
            retval.append("        </field>" + Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    public void setDefault() {
        this.replaceAllByValue = null;
        this.replaceAllMask = null;
        this.selectFields = false;
        this.selectValuesType = false;
        this.setEmptyStringAll = false;
        int nrFields = 0;
        int nrtypes = 0;
        this.allocate(nrtypes, nrFields);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.TransformRecevingData", (String[])new String[]{prev.size() + ""}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            String errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.fields.length; ++i) {
                int idx = prev.indexOfValue(this.fields[i].getFieldName());
                if (idx >= 0) continue;
                errorMessage = errorMessage + "\t\t" + this.fields[i].getFieldName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.FieldsFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else if (this.fields.length > 0) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.NoFieldsEntered", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.TransformRecevingData2", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public IfNullData getTransformData() {
        return new IfNullData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public static class ValueTypes
    implements Cloneable {
        @Injection(name="TYPE_NAME", group="VALUE_TYPES")
        private String typeName;
        @Injection(name="TYPE_REPLACE_VALUE", group="VALUE_TYPES")
        private String typereplaceValue;
        @Injection(name="TYPE_REPLACE_MASK", group="VALUE_TYPES")
        private String typereplaceMask;
        @Injection(name="SET_TYPE_EMPTY_STRING", group="VALUE_TYPES")
        private boolean setTypeEmptyString;

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String getTypereplaceValue() {
            return this.typereplaceValue;
        }

        public void setTypereplaceValue(String typereplaceValue) {
            this.typereplaceValue = typereplaceValue;
        }

        public String getTypereplaceMask() {
            return this.typereplaceMask;
        }

        public void setTypereplaceMask(String typereplaceMask) {
            this.typereplaceMask = typereplaceMask;
        }

        public boolean isSetTypeEmptyString() {
            return this.setTypeEmptyString;
        }

        public void setTypeEmptyString(boolean setTypeEmptyString) {
            this.setTypeEmptyString = setTypeEmptyString;
        }

        public ValueTypes clone() {
            try {
                return (ValueTypes)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Fields
    implements Cloneable {
        @Injection(name="FIELD_NAME", group="FIELDS")
        private String fieldName;
        @Injection(name="REPLACE_VALUE", group="FIELDS")
        private String replaceValue;
        @Injection(name="REPLACE_MASK", group="FIELDS")
        private String replaceMask;
        @Injection(name="SET_EMPTY_STRING", group="FIELDS")
        private boolean setEmptyString;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getReplaceValue() {
            return this.replaceValue;
        }

        public void setReplaceValue(String replaceValue) {
            this.replaceValue = replaceValue;
        }

        public String getReplaceMask() {
            return this.replaceMask;
        }

        public void setReplaceMask(String replaceMask) {
            this.replaceMask = replaceMask;
        }

        public boolean isSetEmptyString() {
            return this.setEmptyString;
        }

        public void setEmptyString(boolean setEmptyString) {
            this.setEmptyString = setEmptyString;
        }

        public Fields clone() {
            try {
                return (Fields)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

