/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.eval;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Node;

@Action(id="EVAL", name="i18n::ActionEval.Name", description="i18n::ActionEval.Description", image="eval.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Scripting", documentationUrl="/workflow/actions/eval.html")
public class ActionEval
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionEval.class;
    private String script;

    public ActionEval(String n, String scr) {
        super(n, "");
        this.script = scr;
    }

    public ActionEval() {
        this("", "");
    }

    public Object clone() {
        ActionEval je = (ActionEval)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(50);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"script", (String)this.script));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.script = XmlHandler.getTagValue((Node)entrynode, (String)"script");
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionEval.UnableToLoadFromXml", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setScript(String s) {
        this.script = s;
    }

    public String getScript() {
        return this.script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluate(Result result, IWorkflowEngine<WorkflowMeta> parentWorkflow, Result prevResult) {
        Context cx = ContextFactory.getGlobal().enterContext();
        try {
            Scriptable scope = cx.initStandardObjects(null);
            Long errors = result.getNrErrors();
            Long linesInput = result.getNrLinesInput();
            Long linesOutput = result.getNrLinesOutput();
            Long linesUpdated = result.getNrLinesUpdated();
            Long linesRejected = result.getNrLinesRejected();
            Long linesRead = result.getNrLinesRead();
            Long linesWritten = result.getNrLinesWritten();
            Long exitStatus = result.getExitStatus();
            Long filesRetrieved = result.getNrFilesRetrieved();
            Long nr = result.getEntryNr();
            scope.put("errors", scope, (Object)errors);
            scope.put("lines_input", scope, (Object)linesInput);
            scope.put("lines_output", scope, (Object)linesOutput);
            scope.put("lines_updated", scope, (Object)linesUpdated);
            scope.put("lines_rejected", scope, (Object)linesRejected);
            scope.put("lines_read", scope, (Object)linesRead);
            scope.put("lines_written", scope, (Object)linesWritten);
            scope.put("files_retrieved", scope, (Object)filesRetrieved);
            scope.put("exit_status", scope, (Object)exitStatus);
            scope.put("nr", scope, (Object)nr);
            scope.put("is_windows", scope, (Object)Const.isWindows());
            scope.put("_entry_", scope, (Object)this);
            scope.put("_action_", scope, (Object)this);
            scope.put("action", scope, (Object)this);
            Object[] array = null;
            if (result.getRows() != null) {
                array = result.getRows().toArray();
            }
            scope.put("rows", scope, (Object)array);
            scope.put("parent_job", scope, parentWorkflow);
            scope.put("parent_workflow", scope, parentWorkflow);
            scope.put("previous_result", scope, (Object)prevResult);
            scope.put("log", scope, (Object)this.getLogChannel());
            try {
                Object res = cx.evaluateString(scope, this.script, "<cmd>", 1, null);
                boolean retval = Context.toBoolean((Object)res);
                result.setNrErrors(0L);
                boolean bl = retval;
                return bl;
            }
            catch (Exception e) {
                boolean bl;
                try {
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(PKG, (String)"ActionEval.CouldNotCompile", (String[])new String[]{e.toString()}));
                    bl = false;
                }
                catch (Exception e2) {
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(PKG, (String)"ActionEval.ErrorEvaluating", (String[])new String[]{e2.toString()}));
                    boolean bl2 = false;
                    return bl2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                Context.exit();
                return bl;
            }
        }
        finally {
            Context.exit();
        }
    }

    public Result execute(Result prevResult, int nr) {
        prevResult.setResult(this.evaluate(prevResult, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, prevResult));
        return prevResult;
    }

    public boolean resetErrorsBeforeExecution() {
        return false;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "script", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

