/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getvariable;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getvariable.GetVariable;
import org.apache.hop.pipeline.transforms.getvariable.GetVariableData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="GetVariable.Injection.", groups={"FIELDS"})
@Transform(id="GetVariable", image="getvariable.svg", name="i18n::BaseTransform.TypeLongDesc.GetVariable", description="i18n::BaseTransform.TypeTooltipDesc.GetVariable", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Workflow", documentationUrl="/pipeline/transforms/getvariable.html")
public class GetVariableMeta
extends BaseTransformMeta
implements ITransformMeta<GetVariable, GetVariableData> {
    private static final Class<?> PKG = GetVariableMeta.class;
    @InjectionDeep
    private FieldDefinition[] fieldDefinitions;

    public FieldDefinition[] getFieldDefinitions() {
        return this.fieldDefinitions;
    }

    public void setFieldDefinitions(FieldDefinition[] fieldDefinitions) {
        this.fieldDefinitions = fieldDefinitions;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int count) {
        this.fieldDefinitions = new FieldDefinition[count];
        for (int i = 0; i < this.fieldDefinitions.length; ++i) {
            this.fieldDefinitions[i] = new FieldDefinition();
        }
    }

    public Object clone() {
        GetVariableMeta retval = (GetVariableMeta)((Object)super.clone());
        int count = this.fieldDefinitions.length;
        retval.allocate(count);
        for (int i = 0; i < count; ++i) {
            retval.getFieldDefinitions()[i] = this.fieldDefinitions[i].clone();
        }
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int count = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldDefinitions[i].setFieldName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                this.fieldDefinitions[i].setVariableString(XmlHandler.getTagValue((Node)fnode, (String)"variable"));
                this.fieldDefinitions[i].setFieldType(ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)fnode, (String)"type")));
                this.fieldDefinitions[i].setFieldFormat(XmlHandler.getTagValue((Node)fnode, (String)"format"));
                this.fieldDefinitions[i].setCurrency(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
                this.fieldDefinitions[i].setDecimal(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.fieldDefinitions[i].setGroup(XmlHandler.getTagValue((Node)fnode, (String)"group"));
                this.fieldDefinitions[i].setFieldLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.fieldDefinitions[i].setFieldPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                this.fieldDefinitions[i].setTrimType(ValueMetaString.getTrimTypeByCode((String)XmlHandler.getTagValue((Node)fnode, (String)"trim_type")));
                if (this.fieldDefinitions[i].getFieldType() != 0) continue;
                this.fieldDefinitions[i].setFieldType(2);
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to read transform information from XML", (Throwable)e);
        }
    }

    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fieldDefinitions[i].setFieldName("field" + i);
            this.fieldDefinitions[i].setVariableString("");
        }
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        int length = -1;
        for (int i = 0; i < this.fieldDefinitions.length; ++i) {
            String string;
            String variableString = this.fieldDefinitions[i].getVariableString();
            if (variableString == null || (string = variables.resolve(variableString)).length() <= length) continue;
            length = string.length();
        }
        RowMeta row = new RowMeta();
        for (int i = 0; i < this.fieldDefinitions.length; ++i) {
            IValueMeta v;
            try {
                v = ValueMetaFactory.createValueMeta((String)this.fieldDefinitions[i].getFieldName(), (int)this.fieldDefinitions[i].getFieldType());
            }
            catch (HopPluginException e) {
                throw new HopTransformException((Throwable)e);
            }
            int fieldLength = this.fieldDefinitions[i].getFieldLength();
            if (fieldLength < 0) {
                v.setLength(length);
            } else {
                v.setLength(fieldLength);
            }
            int fieldPrecision = this.fieldDefinitions[i].getFieldPrecision();
            if (fieldPrecision >= 0) {
                v.setPrecision(fieldPrecision);
            }
            v.setConversionMask(this.fieldDefinitions[i].getFieldFormat());
            v.setGroupingSymbol(this.fieldDefinitions[i].getGroup());
            v.setDecimalSymbol(this.fieldDefinitions[i].getDecimal());
            v.setCurrencySymbol(this.fieldDefinitions[i].getCurrency());
            v.setTrimType(this.fieldDefinitions[i].getTrimType());
            v.setOrigin(name);
            row.addValueMeta(v);
        }
        inputRowMeta.mergeRowMeta((IRowMeta)row, name);
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldDefinitions.length; ++i) {
            String fieldName = this.fieldDefinitions[i].getFieldName();
            if (fieldName == null || fieldName.length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)fieldName));
            retval.append("        ").append(XmlHandler.addTagValue((String)"variable", (String)this.fieldDefinitions[i].getVariableString()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.fieldDefinitions[i].getFieldType())));
            retval.append("        ").append(XmlHandler.addTagValue((String)"format", (String)this.fieldDefinitions[i].getFieldFormat()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"currency", (String)this.fieldDefinitions[i].getCurrency()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"decimal", (String)this.fieldDefinitions[i].getDecimal()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"group", (String)this.fieldDefinitions[i].getGroup()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"length", (int)this.fieldDefinitions[i].getFieldLength()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"precision", (int)this.fieldDefinitions[i].getFieldPrecision()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"trim_type", (String)ValueMetaString.getTrimTypeCode((int)this.fieldDefinitions[i].getTrimType())));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        int nrRemarks = remarks.size();
        for (int i = 0; i < this.fieldDefinitions.length; ++i) {
            if (!Utils.isEmpty((CharSequence)this.fieldDefinitions[i].getVariableString())) continue;
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetVariableMeta.CheckResult.VariableNotSpecified", (String[])new String[]{this.fieldDefinitions[i].getFieldName()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetVariableMeta.CheckResult.AllVariablesSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public GetVariable createTransform(TransformMeta transformMeta, GetVariableData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new GetVariable(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public GetVariableData getTransformData() {
        return new GetVariableData();
    }

    public static class FieldDefinition
    implements Cloneable {
        @Injection(name="FIELDNAME", group="FIELDS")
        private String fieldName;
        @Injection(name="VARIABLE", group="FIELDS")
        private String variableString;
        @Injection(name="FIELDTYPE", group="FIELDS")
        private int fieldType;
        @Injection(name="FIELDFORMAT", group="FIELDS")
        private String fieldFormat;
        @Injection(name="FIELDLENGTH", group="FIELDS")
        private int fieldLength;
        @Injection(name="FIELDPRECISION", group="FIELDS")
        private int fieldPrecision;
        @Injection(name="CURRENCY", group="FIELDS")
        private String currency;
        @Injection(name="DECIMAL", group="FIELDS")
        private String decimal;
        @Injection(name="GROUP", group="FIELDS")
        private String group;
        @Injection(name="TRIMTYPE", group="FIELDS")
        private int trimType;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getVariableString() {
            return this.variableString;
        }

        public void setVariableString(String variableString) {
            this.variableString = variableString;
        }

        public int getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(int fieldType) {
            this.fieldType = fieldType;
        }

        public String getFieldFormat() {
            return this.fieldFormat;
        }

        public void setFieldFormat(String fieldFormat) {
            this.fieldFormat = fieldFormat;
        }

        public int getFieldLength() {
            return this.fieldLength;
        }

        public void setFieldLength(int fieldLength) {
            this.fieldLength = fieldLength;
        }

        public int getFieldPrecision() {
            return this.fieldPrecision;
        }

        public void setFieldPrecision(int fieldPrecision) {
            this.fieldPrecision = fieldPrecision;
        }

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public String getDecimal() {
            return this.decimal;
        }

        public void setDecimal(String decimal) {
            this.decimal = decimal;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public int getTrimType() {
            return this.trimType;
        }

        public void setTrimType(int trimType) {
            this.trimType = trimType;
        }

        public FieldDefinition clone() {
            try {
                return (FieldDefinition)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

